pro find_beam_times, btime, hdr, data_count, data, $
                     atime, beam_time1, beam_time2, one_det = one_det
; CLUSTER II IDL Procedure
;
; Abstract: determine atimes and beam times
;
; Created by: Mark Chutter, UNH
; Nov. 18, 2000
;
; Modified:
; Nov. 20, 2000 MWC add time of one structure if data is before
;                   Nov. 3, 2000
; Jun.  3, 2002 MWC made bps a double
; Sep. 25, 2002 added one_det keyword and adjusted atimes for one
;               detector mode
;
; Calling Interface:
; hdr         struct   (i)
; data_count  int      (i)
; data        struct   (i)
; atime       lonarr   (o)
; beam_time1  dblarr   (o)
; beam_time2  dblarr   (o)
;
; Description:
; This routine converts the information in the index and frame bits
; and the atimes to determine the beam times and atimes

one_detector = 0
IF keyword_set(one_det) THEN one_detector = 1

q_0 = 0.D ;time correction to beam times for q NE 0
q0_0 = 0.D ;time correction to beam times for q = 0

i1 = double(data.i1)
i2 = double(data.i2)

IF hdr.sub_mode EQ 5 OR hdr.pacmo EQ 5 THEN BEGIN
    frame1 = 4.D * double(data.frame1)
    frame2 = 4.D * double(data.frame2)
    IF hdr.sub_mode EQ 1 THEN BEGIN
        bps = 32.D
        struct_time = 125000L
    ENDIF ELSE BEGIN
        bps = 4.D
        struct_time = 15625L
    ENDELSE
ENDIF ELSE BEGIN
    frame1 = 3.D + 8.D * double(data.frame1)
    frame2 = 3.D + 8.D * double(data.frame2)
    bps = 16.D
    struct_time = 62500L
ENDELSE

IF hdr.packet_time[0] LT 973209600L THEN $ ;'03-nov-2000 00:00:00'
  btime = add_ctime(btime, [0L, struct_time])
index = lindgen(data_count)
data[index].atime[0] = btime[0]
data[index].atime[1] = btime[1] + index * struct_time

IF one_detector EQ 1 THEN BEGIN
    data[index+data_count].atime[0] = data[index].atime[0]
    data[index+data_count].atime[1] = data[index].atime[1]
ENDIF

w = where(data.atime[1] GE 1000000L, count)
IF (count GE 1) THEN BEGIN
    data[w].atime[0] = data[w].atime[0] + $
      (data[w].atime[1]/1000000L)
    data[w].atime[1] = data[w].atime[1] - $
      (data[w].atime[1]/1000000L)*1000000L
END
atime = data.atime

;now use the index and frame bits for the final correction
dtime = double(data.atime[0]) + double(data.atime[1])/1.D6
beam_time1 = dtime
beam_time2 = dtime

w = where(data.sq1 NE 0, q_cnt)
IF q_cnt GT 0 THEN $
  beam_time1[w] = $
  dtime[w] - (16.D * (i1[w]+1.D) - frame1[w]) / 4096.D + q0_0
w = where(data.sq1 EQ 0, q_cnt)
IF q_cnt GT 0 THEN $
  beam_time1[w] = dtime[w] - 16.D * (bps+1.D) / 4096.D + q_0
w = where(data.sq2 NE 0, q_cnt)
IF q_cnt GT 0 THEN $
  beam_time2[w] = $
  dtime[w] - (16.D * (i2[w]+1.D) - frame2[w]) / 4096.D + q0_0
w = where(data.sq2 EQ 0, q_cnt)
IF q_cnt GT 0 THEN $
  beam_time2[w] = dtime[w] - 16.D * (bps+1.D) / 4096.D + q_0

return
end
