FUNCTION cdm_parse_time_stamp, header
; CLUSTER II IDL Function
;
; Abstract: parse the time stamp from the edisim dump file
;
; Created by: Mark Chutter, UNH 
; July 8, 1999
;
; Modified:
; Apr. 28, 2000 MWC check for dates from before the year 2000
;
; Calling Interface:
; header     bytarr (i) cdm record header
;
; Return Value:
; time stamp of the form '14-OCT-1998 11:26:33.00'
;
; Affected Variables:
;
; Description:
; parses the edisim dump header and makes a time string that can be
; used by the Pick Library.  This is not a user level function.
time_stamp = '  -   -20     :  :  .00'

month_table = ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', $
               'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC']
month_index = (header[2] - '30'x) * 10 + (header[3] - '30'x) - 1

IF (month_index GT -1) THEN BEGIN

    strput,time_stamp, header[5]
    strput,time_stamp, header[6], 1

    strput,time_stamp,month_table[month_index], 3
    strput,time_stamp, header[8], 9
    IF header[8] NE '30'x THEN BEGIN ;check for dates before the year 2000
        strput, time_stamp, '1', 7
        strput, time_stamp, '9', 8
    ENDIF
    strput,time_stamp, header[9], 10
    strput,time_stamp, header[12], 12
    strput,time_stamp, header[13], 13
    strput,time_stamp, header[15], 15
    strput,time_stamp, header[16], 16
    strput,time_stamp, header[18], 18
    strput,time_stamp, header[19], 19
    
ENDIF

return, time_stamp
END

