FUNCTION bm1_pacmo1_fill, packet, hdr, sc_id
; CLUSTER II IDL Function
;
; Abstract: fill an EDI bm1_pacmo1 data structure
;
; Created by: Mark Chutter, UNH 
; July 8, 1999
;
; Modified:
; July 23, 1999 MWC move btime correction to dealias_clu_time_tag
; Aug.  9, 1999 MWC changed error field to status
; Oct. 19, 1999 MWC used common block for structure definitions
; Feb. 29, 2000 MWC added to check to see if there is any data; this
;                   is useful when trying to look at simulator files
; Mar. 23, 2000 MWC fixed count
; May   9, 2000 MWC time tag at TMR was incorrect
; Aug. 28, 2000 MWC added check to see if delta time tags was too large
; Oct. 20, 2000 MWC set status to DELTA_TIME_TAG_BIG is
;                   dealias_cl_time_tag returns with
;                   status = DELTA_TIME_TAG_BIG 
; Nov.  7, 2000 MWC add the time of one data structure to btime
; Nov. 13, 2000 MWC added sc_id to bm1_pacmo1_fill
; Nov. 18, 2000 MWC find_beam_times now assigns atime and beam times
; Nov. 20, 2000 MWC just pass header to find_beam_times
; Mar.  7, 2001 MWC added sc_id and hdr.packet_time to gd_fill because
;                   of TOF definition changes
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; July 19, 2001 MWC oops, when I checked to see if the data count was
;                   0, I just returned without setting the status
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; Apr. 29, 2002 MWC simplified the code a bit by getting rid of fctmr checks.
;                   The old version is saved as bm1_pacmo1_fill.fctmr
;                   in case we ever want it back.
; July 19, 2002 MWC increased NUMBER_PACMO1_DATA to 350 to handle 
;                   "one detector" mode
; Sep. 25, 2002 MWC set NUMBER_PACMO1_DATA back to 330; add check for
;                   one detector mode
; Oct. 31, 2002 MWC atime was botched for 2 detector WW
;
; Calling Interface:
; packet bytarr              (i) EDI science packet
; hdr    sc_pick_ehdr_struct (i) EDI header structure
;
; Return Value:
; A sc_pick_bpacmo1_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; bm1_pacmo1_fill fills a burst mode 1, pacmo 1 data structure.  It
; is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

PACMO1_DATA_START = 44
PACMO1_DATA_SIZE = 20; /* size in bytes */
NUMBER_PACMO1_DATA = 330

bci_start = 0
time_tag_TMR = 0
btime = lonarr(2)

pacmo1 = sc_pick_bpacmo1_struct
pacmo1.status = 1

pacmo1.time_tag = long(packet[40]) * '100'x + long(packet[41])
pacmo1.data_count = fix(packet[42]) * '100'x + fix(packet[43])
IF hdr.one_det EQ 1 THEN $
  pacmo1.data_count = pacmo1.data_count * 2

;WW is the only mode that uses bm1, pacmo1
IF pacmo1.data_count EQ 0 OR $
  hdr.science_mode NE '5'x THEN BEGIN
    pacmo1.status = INVALID_EDI_DATA
    return,  pacmo1
ENDIF

time_tag_TMR = long(packet[8]) * '100'xL + long(packet[9])
dealias_clu_time_tag, hdr, time_tag_TMR, pacmo1.time_tag, btime, $
  sc_id, status
IF status EQ DELTA_TIME_TAG_BIG THEN BEGIN
    pacmo1.status = DELTA_TIME_TAG_BIG
    return, pacmo1
ENDIF

bci_buf = packet[PACMO1_DATA_START:$
                 PACMO1_DATA_START+NUMBER_PACMO1_DATA*PACMO1_DATA_SIZE-1]
IF hdr.one_det EQ 0 THEN BEGIN
    data = gd_fill(bci_buf, pacmo1.data_count, NUMBER_PACMO1_DATA, 5, $
                   sc_id, hdr.packet_time)
    find_beam_times, btime, hdr, NUMBER_PACMO1_DATA, data, atime, $
      beam_time1, beam_time2
ENDIF ELSE BEGIN
    data = gd_one_fill(bci_buf, 2*NUMBER_PACMO1_DATA, 2*NUMBER_PACMO1_DATA, $
                       5, sc_id, hdr.packet_time, hdr.which_det)
    find_beam_times, btime, hdr, NUMBER_PACMO1_DATA, data, atime, $
      beam_time1, beam_time2, /one_det
ENDELSE

pacmo1.data = data

IF hdr.one_det EQ 0 THEN BEGIN
    pacmo1.data[0:NUMBER_PACMO1_DATA-1].atime[0] = $
      reform(atime[0, 0:NUMBER_PACMO1_DATA-1])
    pacmo1.data[0:NUMBER_PACMO1_DATA-1].atime[1] = $
      reform(atime[1, 0:NUMBER_PACMO1_DATA-1])
    pacmo1.data[0:NUMBER_PACMO1_DATA-1].beam_time1 = beam_time1
    pacmo1.data[0:NUMBER_PACMO1_DATA-1].beam_time2 = beam_time2
ENDIF ELSE BEGIN
    pacmo1.data.atime = atime
    pacmo1.data.beam_time1 = beam_time1
    pacmo1.data.beam_time2 = beam_time2
ENDELSE

return, pacmo1
END

