FUNCTION bci16_fill, bci_buf, data_count, sc_id, packet_time
; CLUSTER II IDL Function
;
; Abstract: fill an EDI bci16 data structure
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; Oct. 15, 1999 MWC working on efficiency: replaced all those
;                   multiplications: i*PACMO1_DATA_SIZE with offset
; Oct. 19, 1999 MWC used common block for structure definitions
; Dec.  8, 1999 MWC got rid of for loop
; May   3, 2000 MWC RTFM, needed to multiply directions and ToF as per 
;                   manual; nnn was not completely procesed
; May   5, 2000 MWC Barb found the factor of 4 that was making ToF too 
;                   small.
; Oct. 11, 2000 MWC Barbs says that t1m2 should be multiplied by 16
;                   when the first bit is set
; Oct. 13, 2000 MWC Barb and I worked out the sign issue of t1m2
; Mar.  8, 2001 MWC TOF definition changed:
;                   SC3 session 0050 IPCH files 1240-1265  26-Feb 08:44 - 09:18
;                   SC1 session 0048 IPCH files 1188-1213  26-Feb 10:37 - 11:14
;                   SC2 session 0049 IPCH files 1214-1239  26-Feb 11:46 - 12:19
;                   SC4 : EDI is off
; Mar. 19, 2001 MWC new TOF code did not allow for case when data
;                   count is less than 329
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Apr.  4, 2001 MWC there seemed to be a overflow problem with the new
;                   t1 calculation, I converted quantities to longs,
;                   and it seems OK now
; Sep. 20, 2001 MWC qualities (sq1 and sq2) have been changed from
;                   byte to int type
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; Feb. 25, 2002 MWC added overflow flags for ToF
; Feb. 27, 2002 MWC dtof_p_over was flagging -1
; 
; Calling Interface:
; bci_buf    bytarr  (i) buffer containing all packed bci16 data
; data_count int     (i) number of data collected
;
; Return Value:
; A sc_pick_bci16_struct structureis returned.  If the error field is
; not zero, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; bci16_fill fills all the bci16 structures for a nominal 1, pacmo 1
; packet.  It is much more efficient this way in IDL as opposed to have a
; function that fills one bci16 structure at a time.  This is not a
; user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

PACMO1_DATA_SIZE = 10; /* size in bytes */
NUMBER_PACMO1_DATA = 81

new_TOF = 0

n_out = bytarr(8)
n_out = [1,2,4,8,8,16,32,64]

bci16 = replicate({sc_pick_bci16_struct}, NUMBER_PACMO1_DATA)

index = indgen(data_count)
offset = index * PACMO1_DATA_SIZE

IF sc_id EQ 1 AND packet_time[0] GE 983179080L THEN $
  new_TOF = 1 ; '26-Feb-2001 09:18:00'
IF sc_id EQ 2 AND packet_time[0] GE 983186040L THEN $
  new_TOF = 1 ;'26-Feb-2001 11:14:00'
IF sc_id EQ 3 AND packet_time[0] GE 983189940L THEN $
  new_TOF = 1 ;'26-Feb-2001 12:19:00'

;need to know nnn for new TOF method
bci16[index].nnn = n_out[ishft((bci_buf[offset[index]+6] AND '70'x), -4)]

IF new_TOF EQ 0 THEN BEGIN
    mult_check = intarr(data_count)
    mult_check[index] = bci_buf[offset[index]] AND '08'x
    sign = intarr(data_count)
    tmp = intarr(data_count)

    tmp = (long(bci_buf[offset[index]] AND '07'x) * '100'x + $
           long(bci_buf[offset[index]+1])) * 4 
;the 4 is in Barb's code, but not mentioned in the EDI User's Manual
    w = where(mult_check EQ 0, count)
    IF count GT 0 THEN bci16[w].t1 = tmp[w]
    w = where(mult_check EQ 8, count)
    IF count GT 0 THEN bci16[w].t1 = tmp[w] * 16L

    mult_check[index] = bci_buf[offset[index]] AND '80'x
    sign[index] = bci_buf[offset[index]] AND '40'x
    tmp = ishft(fix(bci_buf[offset[index]] AND '70'x), -4) * '100'x + $
      fix(bci_buf[offset[index]+2] AND 'F0'x) + $
      ishft(fix(bci_buf[offset[index]+4] AND 'F0'x), -4)

;t1m2 is signed
    w = where(sign EQ 64, count)
    IF count GT 0 THEN tmp[w] = tmp[w] - '800'x
    w = where(mult_check EQ 0, count)
    IF count GT 0 THEN bci16[w].t1m2 = tmp[w]
    w = where(mult_check EQ 128, count)
    IF count GT 0 THEN bci16[w].t1m2 = tmp[w] * 16
ENDIF 

IF new_TOF EQ 1 THEN BEGIN
    tmp = (long(bci_buf[offset[index]] AND '0F'x) * '100'x + $
           long(bci_buf[offset[index]+1])) 
    bci16[0:data_count-1].t1 = tmp * bci16.nnn
    w_o = where(tmp EQ 'FFF'x, count_o)
    IF count_o GT 0 THEN bci16[w_o].tof_over = 1

;t1m2 is signed
    sign = bci_buf[offset[index]] AND '20'x
    tmp = ishft(fix(bci_buf[offset[index]] AND '10'x), -4) * '100'x + $
      fix(bci_buf[offset[index]+2] AND 'F0'x) + $
      ishft(fix(bci_buf[offset[index]+4] AND 'F0'x), -4)
    w_p = where(tmp EQ '1FF'x AND sign EQ '0'x, count_p)
    IF count_p GT 0 THEN bci16[w_p].dtof_p_over = 1
    w_n = where(tmp EQ '200'x, count_n)
    IF count_n GT 0 THEN bci16[w_n].dtof_n_over = 1

    w_n = where(tmp EQ '000'x AND sign EQ '20'x, count_n)
    IF count_n GT 0 THEN bci16[w_n].dtof_n_over = 1

    w = where(sign EQ '20'x, count)
    IF count GT 0 THEN tmp[w] = tmp[w] - '200'x
    bci16[0:data_count-1].t1m2 = tmp * bci16.nnn

    bci16[index].m = ishft((bci_buf[offset[index]] AND 'C0'x), -6)
ENDIF

bci16[index].vax1 = (fix(bci_buf[offset[index]+2] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+3])) * 8
bci16[index].vay1 = (fix(bci_buf[offset[index]+4] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+5])) * 8
bci16[index].vax2 = (fix(bci_buf[offset[index]+6] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+7])) * 8
bci16[index].vay2 = (fix(bci_buf[offset[index]+8] AND '0F'x) * '100'x + $
  fix(bci_buf[offset[index]+9])) * 8
bci16[index].sq1 = fix(ishft((bci_buf[offset[index]+8] AND 'C0'x), -6))
bci16[index].sq2 = fix(ishft((bci_buf[offset[index]+8] AND '30'x), -4))
bci16[index].e = ishft((bci_buf[offset[index]+6] AND '80'x), -7)

return, bci16
END
