pro tick_example

date = '20010223'
scnum = '1'

; Get data for the plot
extract_aux_data, date, scnum, t_ssm=t_ssm, target_mag=tmag, $
  /nobeam

xrange = [19,22]*3600.          ; ssm
xtickv = [19.,19.5,20.,20.5,21.,21.5,22.]*3600. ; ssm
xticks = n_elements(xtickv)-1
xminor = 4

window, 0, xsize=700, ysize=900
!p.multi = [0,1,2]
!x.omargin = [10,5]
!y.omargin = [10,5]

; Regular plot
plot, t_ssm, tmag, xrange=xrange, xtickv=xtickv, $
  xticks=xticks, xminor=xminor

; To plot using xtickformat='tick_ephem_spaux'
; you must first call prep_tick_ephem_spaux:

prep_tick_ephem_spaux, scnum, xtickv, 'ssm', date=date
plot, t_ssm, tmag, xrange=xrange, xtickv=xtickv, $
  xticks=xticks, xminor=xminor, $
  xtickformat='tick_ephem_spaux'

; NOTE:
; prep_tick_ephem_spaux MUST be called immediately
; before the plot call, and the xtickv sent to
; prep_tick_ephem_spaux MUST be the one sent to
; 'plot'.
;
; The order of the ticks are:  UT
;                              R
;                              LSHELL
;                              INVLAT
;                              LOCAL TIME (GSE)
;
; INVLAT has the sign of MAGLAT assigned to it.

return
end
