pro test_ep_rotate

perror = 1                      ; Plot percentage error in magnitude and
                                ; angular difference...Default is to plot
                                ; all 3 components

use_spaux_info = 1 
date = '20010223' 
scnum = '1'
att_orb_hpath = '/nfs/cl1/att_orb/'
aux_path = '../rel/v1_25/aux_data/'
spaux_path = '/home/ppq/sp_data/'
symsize = .25
edi_setcolors, cs
year = long(strmid(date,0,4))
month = long(strmid(date,4,2))
day = long(strmid(date,6,2))
cdf_epoch, epoch_midnight, year, month, day, 0, 0, 0, 0, /compute_epoch
pick_cvt_str_sec, date2datevax(date)+' 00:00:00.000', t70
t70_midnight = double(t70(0)) + double(t70(1))/1d6 ; decimal t70

; Extract data from the PP CDF file
cdf_name = 'C'+scnum+'_PP_FGM_'+date+'_V01.cdf'
id = cdf_open('/home/ppq/pp_data/'+cdf_name)
cdf_control, id, var='Epoch__C'+scnum+'_PP_FGM', get_var_info=r
nrec = r.maxrec+1
cdf_varget, id, 'Epoch__C'+scnum+'_PP_FGM', epoch1, rec_start=0, rec_count=nrec
t_cdf_gse = reform((epoch1 - epoch_midnight)/1000.d0) ; ssm
cdf_varget, id, 'B_xyz_gse__C'+scnum+'_PP_FGM', b1, rec_start=0, rec_count=nrec
bx_cdf_gse = reform(b1(0,*))
by_cdf_gse = reform(b1(1,*))
bz_cdf_gse = reform(b1(2,*))
cdf_varget, id, 'Status__C'+scnum+'_PP_FGM', status1, rec_start=0, rec_count=nrec
cdf_close, id

; Extract data from the EDI_PISO aux files
extract_aux_data, date, scnum, /search_for_all, $
  aux_path=aux_path, $
  t_ssm=time_aux, $
  bfield_scs=bscs, bfield_gse=bgse, $
  drift_step_scs=dscs, drift_step_gse=dgse, $
  drift_velo_scs=vscs, drift_velo_nocorr_gse=vgse, $
  efield_scs=escs, efield_nocorr_gse=egse, $
  vsc_gse=vsc_gse

; Extract data from Edita's FGM files
; SCS coordinate system
mag_name_scs = './C'+scnum+'_'+date+'_SCS.mag'
spawn,'wc -l '+mag_name_scs,flen
nrl=LONG(flen[0]-2) & ddata=DBLARR(4,nrl)
openr,lun_mag,mag_name_scs,/get_lun
readf,lun_mag,ddata
scsinfo1 = ''
scsinfo2 = ''
readf, lun_mag, scsinfo1
readf, lun_mag, scsinfo2
free_lun,lun_mag
tscs_fgm = reform(ddata(0,*)) - t70_midnight ; ssm
bscs_fgm = dblarr(3,n_elements(tscs_fgm))
bscs_fgm(0,*) = reform(ddata(1,*)) ; nT
bscs_fgm(1,*) = reform(ddata(2,*)) ; nT
bscs_fgm(2,*) = reform(ddata(3,*)) ; nT

; GSE coordinate system
mag_name_gse = './C'+scnum+'_'+date+'_GSE.mag'
spawn,'wc -l '+mag_name_gse,flen
nrl=LONG(flen[0]-2) & ddata=DBLARR(4,nrl)
openr,lun_mag,mag_name_gse,/get_lun
readf,lun_mag,ddata
gseinfo1 = ''
gseinfo2 = ''
readf, lun_mag, gseinfo1
readf, lun_mag, gseinfo2
free_lun,lun_mag
tgse_fgm = reform(ddata(0,*)) - t70_midnight ; ssm
bgse_fgm = dblarr(3,n_elements(tgse_fgm))
bgse_fgm(0,*) = reform(ddata(1,*))  ; nT
bgse_fgm(1,*) = reform(ddata(2,*))  ; nT
bgse_fgm(2,*) = reform(ddata(3,*))  ; nT

; GSM coordinate system
mag_name_gsm = './C'+scnum+'_'+date+'_GSM.mag'
spawn,'wc -l '+mag_name_gsm,flen
nrl=LONG(flen[0]-2) & ddata=DBLARR(4,nrl)
openr,lun_mag,mag_name_gsm,/get_lun
readf,lun_mag,ddata
gsminfo1 = ''
gsminfo2 = ''
readf, lun_mag, gsminfo1
readf, lun_mag, gsminfo2
free_lun,lun_mag
tgsm_fgm = reform(ddata(0,*)) - t70_midnight ; ssm
bgsm_fgm = dblarr(3,n_elements(tgsm_fgm))
bgsm_fgm(0,*) = reform(ddata(1,*))  ; nT
bgsm_fgm(1,*) = reform(ddata(2,*))  ; nT
bgsm_fgm(2,*) = reform(ddata(3,*))  ; nT

if (n_elements(tscs_fgm) ne n_elements(tgse_fgm)) then message, 'ooops'
if (min(tscs_fgm - tgse_fgm) ne 0) then message, 'ooops'
if (max(tscs_fgm - tgse_fgm) ne 0) then message, 'ooops'

if (n_elements(tscs_fgm) ne n_elements(tgsm_fgm)) then message, 'ooops'
if (min(tscs_fgm - tgsm_fgm) ne 0) then message, 'ooops'
if (max(tscs_fgm - tgsm_fgm) ne 0) then message, 'ooops'


; Which data do you want to test?
if (not perror) then !p.multi = [0,1,3] else !p.multi = [0,1,2]
for icase=0,13 do begin
    case icase of
        0:begin
            time = time_aux     ; scs-->gse, internal b check using aux data
            ttype_in = 'ssm'
            vtype_in = 'scs'
            vec_in = bscs
            vtype_out = 'gse'
            ydat = bgse
        end
        1:begin
            time = time_aux     ; scs-->gse, internal d check using aux data
            ttype_in = 'ssm'
            vtype_in = 'scs'
            vec_in = dscs
            vtype_out = 'gse'
            ydat = dgse
        end
        2:begin
            time = time_aux     ; scs-->gse, internal v check using aux data
            ttype_in = 'ssm'
            vtype_in = 'scs'
            vec_in = vscs
            vtype_out = 'gse'
            ydat = vgse
        end
        3:begin
            time = time_aux     ; scs-->gse, internal e check using aux data
            ttype_in = 'ssm'
            vtype_in = 'scs'
            vec_in = escs
            vtype_out = 'gse'
            ydat = egse
        end
        4:begin
            time = time_aux     ; gse-->scs, internal b check using aux data
            ttype_in = 'ssm'
            vtype_in = 'gse'
            vec_in = bgse
            vtype_out = 'scs'
            ydat = bscs
        end
        5:begin
            time = time_aux     ; gse-->scs, internal d check using aux data
            ttype_in = 'ssm'
            vtype_in = 'gse'
            vec_in = dgse
            vtype_out = 'scs'
            ydat = dscs
        end
        6:begin
            time = time_aux     ; gse-->scs, internal v check using aux data
            ttype_in = 'ssm'
            vtype_in = 'gse'
            vec_in = vgse
            vtype_out = 'scs'
            ydat = vscs
        end
        7:begin
            time = time_aux     ; gse-->scs, internal e check using aux data
            ttype_in = 'ssm'
            vtype_in = 'gse'
            vec_in = egse
            vtype_out = 'scs'
            ydat = escs
        end
        8:begin
            time = tscs_fgm     ; scs-->gse, external check using FGM data
            ttype_in = 'ssm'
            vtype_in = 'scs'
            vec_in = bscs_fgm
            vtype_out = 'gse'
            ydat = bgse_fgm
        end
        9:begin
            time = tgse_fgm     ; gse-->scs, external check using FGM data
            ttype_in = 'ssm'
            vtype_in = 'gse'
            vec_in = bgse_fgm
            vtype_out = 'scs'
            ydat = bscs_fgm
        end
        10:begin
            time = tscs_fgm     ; scs-->gsm, external check using FGM data
            ttype_in = 'ssm'
            vtype_in = 'scs'
            vec_in = bscs_fgm
            vtype_out = 'gsm'
            ydat = bgsm_fgm
        end
        11:begin
            time = tgsm_fgm     ; gsm-->scs, external check using FGM data
            ttype_in = 'ssm'
            vtype_in = 'gsm'
            vec_in = bgsm_fgm
            vtype_out = 'scs'
            ydat = bscs_fgm
        end
        12:begin                ; gse-->gsm, external check using FGM data
            time = tgse_fgm
            ttype_in = 'ssm'
            vtype_in = 'gse'
            vec_in = bgse_fgm
            vtype_out = 'gsm'
            ydat = bgsm_fgm
        end
        13:begin                ; gsm-->gse, external check using FGM data
            time = tgsm_fgm
            ttype_in = 'ssm'
            vtype_in = 'gsm'
            vec_in = bgsm_fgm
            vtype_out = 'gse'
            ydat = bgse_fgm
        end
        
    endcase
    
    istat = ep_rotate(scnum, $
                      ttype_in, time, $
                      vtype_in, vec_in, $
                      vtype_out, ydat2, $
                      date=date, att_orb_hpath=att_orb_hpath, $
                      /cache_rotmats, use_spaux_info=use_spaux_info, $
                      spaux_path=spaux_path)
    
    if (not perror) then begin
        ytitstr = ['x','y','z']
        for ic=0,2 do begin
            yrange = [min([ydat(ic,*),ydat2(ic,*)]),$
                      max([ydat(ic,*),ydat2(ic,*)])]
            plot, time/3600., ydat(ic,*), psym=-7, symsize=symsize, $
              yrange=yrange, title='Case '+strtrim(icase,2), $
              ytitle = ytitstr(ic)
            oplot, time/3600., ydat2(ic,*), psym=-1, symsize=symsize, $
              color=cs.red
        endfor
    endif else begin
        ymag = sqrt(total(ydat^2,1))
        ymag2 = sqrt(total(ydat2^2,1))
        theta = acos(total(ydat*ydat2,1)/ymag/ymag2)*!radeg

        perror_mag = abs(ymag-ymag2)/ymag*100.
        plot, time/3600., perror_mag, $
          yrange=[min(perror_mag),max(perror_mag)], $
          ytitle='% error in magntude', title='Case '+strtrim(icase,2)
        plot, time/3600., theta, yrange=[min(theta),max(theta)], $
          ytitle='Angular difference [deg.]', title='Case '+strtrim(icase,2)

    endelse
    
    message, 'Any key to continue', /cont
    res = get_kbrd(1)
    
endfor

stop

return
end
