PRO  SUNEARTH,  THETA,PHI

;C Calculate the heliographic longitude (THETA) and latitude (PHI) of
;C the centre of the disc as seen from the Earth.

common  angle, rot

       zero = 0.0d0
       c = pi()/180.0d0

;C Pull out angle required
       incl    = rot(8)*c
       sunlong = rot(1)*c
       omega   = rot(7)*c

;C Working variable
       smo = sunlong-omega

;C Compute longitude. Initially in range -90 to +90.
       theta = atan(cos(incl)*tan(smo)) / c

;C Convert range to 0 to +180
       if (theta lt zero) then  theta = 180.d0 + theta

;C Assign value of THETA in full range (0 to 360). THETA lies in 
;C the opposite quadrant to SMO, so if SMO < 180 deg (SIN(SMO) +ve)
;C add 180 to THETA
       x = sin(smo)
       if (x gt zero) then  theta = 180.d0 + theta

;C Compute latitude
       phi = asin(sin(smo)*sin(incl)) / c
       return


END
