function qstat_read, date, sc_number, path

qstat = {status:0, $
         msg_out:'', $
         hh:intarr(24), $
         flag:intarr(24), $
         all:intarr(24), $
         good:intarr(24), $
         p1:fltarr(24), $
         p2:fltarr(24), $
         p3:fltarr(24), $
         p4:fltarr(24), $
         p5:fltarr(24), $
         p6:fltarr(24)}


date_lite = strmid(date,2,6)
qfile = path+'/'+date_lite+'eq*'+sc_number
f = findfile(qfile)
if (f(0) eq '') then begin
    qstat.msg_out = 'QSTAT file not found'
    return, qstat
endif

nf = n_elements(f)
pp_qstat_file = f(nf-1)
openr, unit, f(nf-1), /get_lun

;A complete line looks like this
;(amount of actual spaces between entries in qstat files differs from
;the ones in this line):

;yyyy-mm-dd  hh  flag   all  good    f.f  f.f  f.f  f.f  f.f  f.f

;hh	the hour for which the statistics is reported
;flag	1 if there are any WW data at all in the current hour, 0 otherwise
;all	total number of spins containing WW data within this hour
;good   number of 'good' spins (number of beams of quality q>=2 is
;       greater than 3)
;f.f    percentages of good spins for six 10-minute intervals of the hour

;The first line of the file is a comment line, beginning with a
;semicolon.

dum = ''
dstr = ''
hh = 0
flag = 0
all = 0
good = 0
s1 = 0.
s2 = 0.
s3 = 0.
s4 = 0.
s5 = 0.
s6 = 0.

; One comment line at the top
readf, unit, dum

; 24 lines, one for each hour
for ihour=0,23 do begin
    readf, unit, dum
    reads, dum, dstr, hh, flag, all, good, s1, s2, s3, s4, s5, s6, $
      format='(a10,2x,i2,2x,i1,2x,i5,2x,i4,2x,5(f5.1,2x),f5.1)'

    qstat.hh(ihour) = hh
    qstat.flag(ihour) = flag
    qstat.all(ihour) = all
    qstat.good(ihour) = good
    qstat.p1(ihour) = s1
    qstat.p2(ihour) = s2
    qstat.p3(ihour) = s3
    qstat.p4(ihour) = s4
    qstat.p5(ihour) = s5
    qstat.p6(ihour) = s6

endfor

qstat.status = 1
qstat.msg_out = 'Successful QSTAT read'
    
return, qstat
end
