!p.multi=[0,1,2]
if !d.name eq 'PS' then begin
	device,filename="bestarg.ps",xoff=3.5,yoff=1.7,xs=13.77,ys=26.
endif
if !d.name eq 'X' then window,0,xs=485,ys=970

;******************************************************************
;contour plot combined likelihood function
;******************************************************************
xdtit='X='+strcompress(string(format='(f9.3)',xd),/remove_all)
ydtit='Y='+strcompress(string(format='(f9.3)',yd),/remove_all)
rdtitf='R='+strcompress(string(format='(f9.3)',rd),/remove_all)$
; +'!9+!3'+strcompress(string(format='(f9.3)',rderr),/remove_all)$
 +' ('+strcompress(string(format='(f9.3)',rarr(ibestf)),/remove_all)+')'
pdtit='!9P!3='+strcompress(string(format='(f9.3)',180/!pi*pd),/remove_all)$
; +'!9+!3'+strcompress(string(format='(f9.3)',180/!pi*pderr),/remove_all)$
+' ('+strcompress(string(format='(f9.3)',180/!pi*parr(ibestf)),/remove_all)+')'
if yestof then begin
rdtitg='R='+strcompress(string(format='(f9.3)',rd),/remove_all)$
; +'!9+!3'+strcompress(string(format='(f9.3)',rderr),/remove_all)$
 +' ('+strcompress(string(format='(f9.3)',rarr(ibestg)),/remove_all)+')'
tgtit='T='+strcompress(string(format='(f9.3)',tg),/remove_all)$
; +'!9+!3'+strcompress(string(format='(f9.3)',tgerr),/remove_all)$
 +' ('+strcompress(string(format='(f9.3)',tarr(ibestg)),/remove_all)+')'
endif
contour,(farr(*,*,itbest)+garr(*,*,itbest)-fgb)^pp,$
	xarr(*,*,itbest),yarr(*,*,itbest),xra=[-siz,siz],yra=[-siz,siz],$
	xsty=1,ysty=1,nlevels=10,xtit=xdtit,ytit=ydtit,$
	title= '!4v!3!u2!n/('$
	+strcompress(string(format='(i5)',mm),/remove_all) +'+'$
	+strcompress(string(format='(i5)',yestof*mouteq0),/remove_all) +')='$
   +strcompress(string(format='(f9.3)',fgchi/(mm+yestof*mouteq0)),/remove_all)
oplot,	[0],[0],psym=1
oplot,	[-siz,siz],[yd,yd],linestyle=1
oplot,	[xd,xd],[-siz,siz],linestyle=1

;******************************************************************
;draw firing directions and a symbol at each gun location
;thick lines point to the target consistent with the respective tof
;******************************************************************
text5 = strcompress(runner(0),/remove_all)
for order= 2,maxorder do begin
        text5 = text5+', '+strcompress(runner(order-1),/remove_all)
endfor
xtof = xg + (tof-tg)/minord *vb*cos(alpha)
ytof = yg + (tof-tg)/minord *vb*sin(alpha)
plot,	[0],[0],psym=1,xra=[-siz,siz],yra=[-siz,siz],$
	xsty=1,ysty=1,xtit=xdtit,ytit=ydtit,title='Multirunners: '+text5
oplot,	[-siz,siz],[yd,yd],linestyle=1
oplot,	[xd,xd],[-siz,siz],linestyle=1
xx=[-siz,siz]
for im = 0, mm-1 do begin 
  oplot,[xg(im)],[yg(im)],psym=8-gunid(im)
  yy=tan(alpha(im)+1e-4)*(xx-xg(im))+yg(im)
  oplot,xx,yy,thick=0.01
endfor
for im = 0, mm-1 do begin
 if out(im) eq 0 then begin
  xx=[xg(im),xtof(im)]
  yy=[yg(im),ytof(im)]
  oplot,xx,yy
 endif
endfor

if !d.name eq 'X' then pause= get_kbrd(1)

;******************************************************************
;contour plot farr, the likelihood function for triangulation
;for each gun a symbol indicates the target consistent with the respective tof
;******************************************************************
contour,(farr(*,*,itbest)-fb)^pp,$
	rarr(*,*,itbest),180/!pi*parr(*,*,itbest),$
	xsty=1,ysty=1,nlevels=10,xtit=rdtitf,ytit=pdtit,$
	title= '!4v!3!u2!n/'$
	+strcompress(string(format='(i5)',mm),/remove_all) +'='$
	+strcompress(string(format='(f9.3)',fchi/mm),/remove_all)$
	+' (Triangulation)'
oplot,	[rd,rd],180/!pi*[pmin,pmax],linestyle=1
oplot,	[rmin,rmax],180/!pi*[pd,pd],linestyle=1
for im = 0, mm-1 do begin
 if out(im) eq 0 then begin
  oplot,[sqrt(xtof(im)^2+ytof(im)^2)],180/!pi*[atan(ytof(im),xtof(im))],$
  psym=8-gunid(im)
 endif
endfor
oplot, rarr(confidf),180/!pi*parr(confidf),psym=4,symsize=0.2

;******************************************************************
;contour plot garr, the likelihood function for time of flight
;for each gun a symbol gives the respective tof
;******************************************************************
if yestof then begin
contour,(reform(garr(*,ipbest,*),nr,nt)-gb)^pp,$
	reform(rarr(*,ipbest,*),nr,nt),reform(tarr(*,ipbest,*),nr,nt),$
	xsty=1,ysty=1,nlevels=10,xtit=rdtitg,ytit=tgtit,$
	title= '!4v!3!u2!n/'$
	+strcompress(string(format='(i5)',mouteq0),/remove_all) +'='$
	+strcompress(string(format='(f9.3)',gchi/mouteq0),/remove_all)$
	+' (Time of Flight)'
oplot,	[rd,rd],[tmin,tmax],linestyle=1
oplot,	[rmin,rmax],[tg,tg],linestyle=1
oplot,	[rmin,rmax],$
	[tg+rd/vb,tg+rd/vb],linestyle=1
oplot,	[rmin,rmax],$
	[tg-rd/vb,tg-rd/vb],linestyle=1
for im = 0, mm-1 do begin
 if out(im) eq 0 then begin
  oplot,[rarr(ibestg)],[tof(im)],psym=8-gunid(im)
  oplot,[rarr(ibestg)],[tof(im)],psym=(toaw(im)+1)/2
 endif
endfor
oplot, rarr(confidg),tarr(confidg),psym=4,symsize=0.2
endif else begin
plot, findgen(2)
endelse

if !d.name eq 'X' then pause= get_kbrd(1)
