PRO  MAKTRAN,  INSYS,OUTSYS,T


;C Calculate the transformation matrix T corresponding to a 
;C transformation between INSYS and OUTSYS. Construct array LTERMS 
;C indicating the sequence of simple rotations, call MAKET to
;C generate T
;C

       common table,  nsys,defs,tsys,syscode


       t = dblarr(3,3)
       lterms = intarr(20)    &    lterms(*) = 0


;C Find INREF, the index number for system INSYS, pull out the
;C relevant list of tranformations from definition array DEFS,
;C and copy the list into array LTERMS. NT1 is the number of terms in
;C this list.
       inref = getref(insys)		;inref->IDL-index(0:x)
       nt1   = defs(0,inref)

; fortran versio
;       if (nt1 gt 0) then begin
;            for j = 0,nt1-1 do begin
;               lterms(j) = defs(j+1,inref)
;            endfor
;       endif
;
; IDL version
       if (nt1 gt 0) then lterms(0:nt1-1) = defs(1:nt1,inref)


;C Find OUTREF, the index number for system OUTSYS, pull out the
;C relevant list of tranformations from definition array DEFS,
;C and copy the list into array LTERMS in reverse order. NT2 is the 
;C number of terms in this list.
       outref =  getref(outsys)		;outref IDL-index(0:x)
       nt2    =  defs(0,outref)
       if (nt2 gt 0) then begin       
            for  j = 0,nt2-1 do begin
               j1 = j + nt1
               j2 = nt2 + 2 - j  - 2    ;IDL-index
               lterms(j1) = -defs(j2,outref)
            endfor
       endif

;C Clean up list of transformations in array LTERMS by removing terms 
;C which cancel. This can only occur at the interface between the
;C INSYS and OUTSYS lists. So check there. Reduce both NT1 and NT2 
;C by 1 everytime a term is eliminated.
;C
;C Outer loop - don't clean up if either or both of the original lists
;C are empty.

   if ((nt1 gt 0) and (nt2 gt 0)) then begin 

;C Main loop - repeat while both the INSYS and OUTSYS lists are 
;C non-empty (NT1 and NT2 > 0) and there are terms that cancel
;C (ITEST = 0).

main_loop:
;C Test for canceling terms, i.e. adjacent terms of equal magnitude
;C and opposite sign. If found, reduce the size of both input lists by 
;C one and move terms in the second list forward by two steps, 
;c OVERWRITING THE CANCELING TERMS.
           itest = lterms(nt1) + lterms(nt1+1)
           if (itest eq 0) then begin
                nt1 = nt1 - 1
                nt2 = nt2 - 1
                for  j = 0,nt2-1 do begin
                    j1 = j + nt1
                    j2 = j1 + 2
                    lterms(j1) = lterms(j2)
                  
                endfor
           endif

;C End of main loop            
         if ((nt1 gt 0) and (nt2 gt 0) and (itest eq 0)) then goto,main_loop

;C End of outer loop
   endif

;C NTERMS is the number of terms in the cleaned up list in LTERMS
       nterms = nt1 + nt2
 
;C Calculate transformation matrix
       maket, t,nterms,lterms

       return


END
