PRO MAKEMTX,  THETA,AXIS,C

;C Make a simple rotation matrix        

       c = dblarr(3,3)
       th = theta

; Fortran version  :: (row,columne)
;C Sort out which columns contain which values       
;       if (axis eq 'z') then  begin
;         i=0
;         j=1
;         k=2
;       endif else if (axis eq 'x') then begin
;         i=1
;         j=2
;         k=0
;       endif else if (axis eq 'y') then begin
;         i=0
;         j=2
;         k=1
;       endif else begin
;         stop         
;       endelse
;
;;C Turn the angle into radians and make the trig functions       
;       theta = double( theta*PI(0)/180.d0 )
;       st = sin(theta)
;       ct = cos(theta)
;
;;C Make the matrix!        
;
;       c(*,*) = 0.d0
;       c(i,i) = ct
;       c(j,j) = ct
;       c(k,k) = 1.d0
;       c(i,j) = -st
;       c(j,i) = st
;

; IDL version
;C Turn the angle into radians and make the trig functions       
       th   = double( theta*PI(0)/180.d0 )
       st = sin(th)
       ct = cos(th)


       if (axis eq 'z') then  begin
          c = [ [  ct,   st,   0.d0 ],   $
                [ -st,   ct,   0.d0 ],   $
                [  0.d0, 0.d0, 1.d0 ]    ] 


       endif else if (axis eq 'x') then begin
           c = [ [ 1.d0,  0.d0,  0.d0 ],   $
                 [ 0.d0,   ct,     st ],   $
                 [ 0.d0,  -st,     ct ]   ]


       endif else if (axis eq 'y') then begin
           c = [ [ ct,    0.d0,   st   ],   $ 
                 [ 0.d0,  1.d0,  0.d0  ],   $
                 [-st,    0.d0,   ct   ]   ]


       endif else begin
         stop         
       endelse

       return

END
