; =============================================================================
  FUNCTION GyroProjection_, vector, B
; =============================================================================
; EQ-S / Cluster : project a 3D vector into the gyro plane (perp to B)
; The input vector and B must be given as an array [x,y,z], where each 
; component can itself be an array
;
; The resulting vector will be returned as 
;     rvect = [rx,ry,rz]
; *****************************************************************************

dimv = n_elements(vector) / 3
dimB = n_elements(B) / 3

if 3*dimv ne n_elements(vector) then begin
   print, 'GyroProjection_() : passed vector size is incompatible with a '
   print, '                    3-D vector'
;  SHOWCALLSTACK
endif else if 3*dimB ne n_elements(B) then begin
   print, 'GyroProjection_() : passed vector size is incompatible with a '
   print, '                    3-D vector'
;  SHOWCALLSTACK
endif

if dimv ne dimB then begin
   print, 'GyroProjection_() : array dimensions of passed vectors are '
   print, 'incompatible'
;  SHOWCALLSTACK
endif

x = indgen(dimv)
y = x + dimv
z = x + 2*dimv

Bmag = sqrt( B(x)^2 + B(y)^2 + B(z)^2 )

v_dot_B = vector(x)*B(x) + vector(y)*B(y) + vector(z)*B(z)

factor1 = v_dot_B / Bmag    ; component along B, for diagnostics
factor2 = v_dot_B / Bmag^2

rx = vector(x) - factor2 * B(x)
ry = vector(y) - factor2 * B(y)
rz = vector(z) - factor2 * B(z)

return, [rx,ry,rz]

END
