 PRO GETTERMS,  IN_CHANNEL,IO_STATUS

;
;C Read in the data which defines the transformations. 
;C
;C NSYS is the number of systems
;C 
;C TSYS contains the full name of each system
;C
;C SYSCODE contains a four character code for each system. Used
;C internally within the program.
;C
;C DEFS specifies the transformation from each system
;C to GSE. All other transformations can be derived from this.
;C Each definition consists a line of integers. The first value gives
;C the number of valid terms following. The other terms indicate
;C how the fundamental rotations should be applied for the given
;C transformation. If the first value is -1, a rotational transformation
;C is not possible; this allows for systems like Geodetic.
;C
;
;   kzm:
;   in_channel  : dummy no longer needed: io-channel is defined here with get_lun 

;   if logical CLUSTRAN_DIR is not defined, then TABLE-data are defined
;                             in IDL-program terms2_init
;                         else read file terms2.data
;
;   Modified by G.Leistner Jan 2000
;      cl_dir + 'TERMS2.DAT'  replaced by  cl_dir + '/TERMS2.DAT'
;   Modified by G.Leistner Feb 2000
;     "close,io_channel,/all" replaced by "close,io_channel"
;     
  

       COMMON TABLE,  NSYS,DEFS,TSYS,SYSCODE

       nsys = -1 
       nrot = 7
      
       cl_dir    = ' '
       data_file = ' '
       
;*** Locate and open the data file
;* Pick up the directory from environment variable CLUSTRAN_DIR and
;* find the number of characters in that path

       cl_dir = getenv('CLUSTRAN_DIR')
       cl_dir = strtrim(cl_dir)


;  If CL_DIR is of zero length, call terms2_init
       if (cl_dir eq '') then begin
;             print,' terms2 data are defined by idl-prog term2_init'
             terms2_init
             return
       endif

; read terms2 data from file 
;* Construct the full name of the data file
       data_file = cl_dir + '/TERMS2.DAT'

       on_ioerror, io_error2	;* If OPEN returns an error, exit with that error code
                                ;   or READ error
       openr,io_channel,data_file,/get_lun

;* Read first line in TERMS2.DATA
       readf,io_channel, nsys

       tsys  = strarr(20)
       defs  = intarr(10,nsys)
       syscode = strarr(20)
       temp = ' '

       for i=0,nsys-1 do begin
          readf,io_channel, temp
          temp = strmid(temp,1,31)           ;delete '   ' of inputfile
          tsys(i) = temp
        endfor

       for i=0,nsys-1 do begin
          readf,io_channel, format='(i2,i3,i4,i4,i4,i3,i3)', i1,i2,i3,i4,i5,i6,i7
          defs(0,i)=i1  &  defs(1,i)=i2  &  defs(2,i)=i3  &  defs(3,i)=i4
          defs(4,i)=i5  &  defs(5,i)=i6  &  defs(6,i)=i7
       endfor
       for i=0,nsys-1 do begin
            readf,io_channel,  temp
            temp = strmid(temp,1,4)           ;delete ' ' of inputfile
            syscode(i) = temp
       endfor

;       print,' terms2 data are taken from terms2.dat file'
       
       free_lun, io_channel
       return 
;*
;
;
;io_error1:
;       io_status = 1000
;       print, 'logical CLUSTRAN_DIR not defined'
;       return

io_error2:
       io_status = 1000
       print,!error_state.msg
       return
       
       
       
   END
   
