PRO  GEOD2GEO,  DS

;C Convert geodetic coordinates to geocentric polar coordinates:
;C (i) convert geodetic latitude to geocentric, (ii) longitude is
;C unchanged, (iii) convert height above geoid in kilometres to 
;C radial distance in Earth radii

       w = dblarr(3)

       if (DS.sys eq 'GEOD') then  begin
           copyx, DS.vect,w
           DS.vect(0) = w(0) - (3.37d-3)*sin(2.d0*w(0))
           DS.vect(1) = w(1)
           DS.vect(2) = (0.99832707d0 + 0.00167644d0*cos(2.d0*w(0))) + w(2) / 6378.14d0
           DS.sys  = 'GEOC'
           DS.form = 'PO'
           DS.rcode = 0
       endif else begin
           DS.rcode = 2
       endelse
;C
       return


END
