#-------------------------------------------------------
# Assign command-line arguments
setenv EDI_PISO_PRODUCTION_DATE $1
setenv EDI_PISO_SC_NUMBER $2
setenv EDI_PISO_MACHINE $3
setenv EDI_PISO_CONTROL $4

if ("$EDI_PISO_CONTROL" == "2") then
    setenv EP_CODE_PATH ${EDI_SPROD_TEMPCODE_PATH}
    setenv EP_IDL_STARTUP ${EDI_SPROD_TEMPCODE_PATH}/edi_sprod_idl_startup.pro
else
    setenv EP_CODE_PATH ./
    setenv EP_IDL_STARTUP ./edi_piso_idl_startup.pro
endif

#-------------------------------------------------------
# Source the control parameters
setenv SPROD_OK 0                 # Possibly overwritten by control script
setenv MSF_MULTI 0                # Possibly overwritten by control script
setenv RDDA_MULTI 0               # Possibly overwritten by control script

if ("$EDI_PISO_CONTROL" == "0") then
   source ${EP_CODE_PATH}/ep_control_gcdc.csh
else if ("$EDI_PISO_CONTROL" == "1") then
   source ${EP_CODE_PATH}/ep_control.csh
else
    source ${EP_CODE_PATH}/ep_control_sprod.csh
    if ("${SPROD_OK}" == "0") then
	echo "EDI_SPROD setup not successful: Aborting"
	exit
    endif
endif

# Check to see if current and backup rdda roots should be the same
if ("$RDDA_MULTI" == "0") then
    setenv GDC_RDDA_ROOT2 ${GDC_RDDA_ROOT}
endif

mkdir $EP_TEMPDATA_PATH

#-------------------------------------------------------
# Get full path for bash; Store in EDI_PISO_BASH
# The FGM scripts are in BASH.
setenv EDI_PISO_BASH `which bash`

#-------------------------------------------------------
# Set the official, nominal phase offset for Cluster 
# spin interval definition as defined in the document
# "Spin Timings and Offsets for Cluster Prime Parameters"
# by Schwarz and Daly, DS-QMW-TN-0007, 1996
#         OFFSET = 75/1024 * 360 degrees
# Note: EDI_PISO software assumes that the FGM software that
# produces the spin-averaged magnetic field file uses this
# exact offset also!!!  If this number ever changes, check to
# make sure the FGM code changes it's value also!!!

setenv EDI_PISO_OFFSET 26.3671875
#-------------------------------------------------------

#echo 'ATT_ORB:'
#echo ${EDI_PISO_ATT_ORB_PATH}

# Copy ATT_ORB data to a temporary working directory
cp -p ${EDI_PISO_ATT_ORB_PATH}/* ${EP_TEMPDATA_PATH}/.
setenv EDI_PISO_ATT_ORB_TPATH ${EP_TEMPDATA_PATH}

#echo ${EDI_PISO_ATT_ORB_TPATH}
#ls ${EDI_PISO_ATT_ORB_TPATH}

@ j = 0
foreach i ($finfo)

    @ j++

    setenv EDI_PISO_SC_NUMBER `echo $i | cut -c3-3`
    setenv EDI_PISO_TSTRING `echo $i | cut -c16-23`
    setenv EDI_PISO_TINFO $tinfo[${j}]
    if ("${SPROD_OK}" == "1") then
	setenv EDI_PISO_FILENAME_ROOT $filename_root[${j}]
    else
	setenv EDI_PISO_FILENAME_ROOT auto
    endif
    
    set year = `echo $i | cut -c5-8`
    set month = `echo $i | cut -c10-11`
    set day = `echo $i | cut -c13-14`
    setenv EDI_PISO_PRODUCTION_DATE ${year}${month}${day}

    set ftype = `echo $i | cut -c26-28`

    if ("$ftype" == "msf") then

	 set date_lite = `echo $EDI_PISO_PRODUCTION_DATE | cut -c3-8`

	 echo "Searching primary MSF path: ${GDC_MSF_ROOT}"
	 set files = `ls -1 ${GDC_MSF_ROOT}/msf_${EDI_PISO_SC_NUMBER}/${date_lite}em.??${EDI_PISO_SC_NUMBER}`

	 if ("${#files}" == "0") then

	    if ("$MSF_MULTI" == "1") then
		echo "Searching secondary MSF path: ${GDC_MSF_ROOT2}"
		set files = `ls -1 ${GDC_MSF_ROOT2}/msf_${EDI_PISO_SC_NUMBER}/${date_lite}em.??${EDI_PISO_SC_NUMBER}`
		if ("${#files}" == "0") then
		    echo "MSF file not found on this path: ${GDC_MSF_ROOT2}/msf_${EDI_PISO_SC_NUMBER}/${date_lite}em.??${EDI_PISO_SC_NUMBER}"
		    goto next_file
		else
		    setenv EDI_PISO_FNAME $files[${#files}]
		    setenv EDI_PISO_SNAME msf
		    setenv EDI_PISO_CONFIG ${EDI_PISO_MACHINE}_msf
# Copy MSF file to a temporary working directory
		    echo "Copying MSF file to temporary data directory"
		    cp -p $files[${#files}] ${EP_TEMPDATA_PATH}/.
		    set ftemp = `echo $files[${#files}] | tail -13c`
		    setenv EDI_PISO_FNAME ${EP_TEMPDATA_PATH}/$ftemp
		endif
	    else
		echo "MSF file not found on this path: ${GDC_MSF_ROOT}/msf_${EDI_PISO_SC_NUMBER}/${date_lite}em.??${EDI_PISO_SC_NUMBER}"
		goto next_file
	    endif

	 else

	     setenv EDI_PISO_FNAME $files[${#files}]
	     setenv EDI_PISO_SNAME msf
	     setenv EDI_PISO_CONFIG ${EDI_PISO_MACHINE}_msf
# Copy MSF file to a temporary working directory
	     echo "Copying MSF file to temporary data directory"
	     cp -p $files[${#files}] ${EP_TEMPDATA_PATH}/.
	     set ftemp = `echo $files[${#files}] | tail -13c`
	     setenv EDI_PISO_FNAME ${EP_TEMPDATA_PATH}/$ftemp

	 endif

    else
         set ftp_fname = `echo $i | cut -c1-28`

         set files = `ls -1 ${EDI_PISO_FTP_PATH}/sc${EDI_PISO_SC_NUMBER}/${ftp_fname}`

         if ("${#files}" == "0") then
      	    echo "FTP file not found"
	    goto next_file
	 else
	     setenv EDI_PISO_FNAME $files[${#files}]
	     setenv EDI_PISO_SNAME ftp
	     setenv EDI_PISO_CONFIG ${EDI_PISO_MACHINE}_ftp
	 endif
     endif

#     setenv > setenv${j}.txt
#     ls ${EDI_PISO_ATT_ORB_TPATH}

# Setup default IDL session, then augment necessary paths in startup
     source $EDI_PISO_IDL_SETUP
     setenv IDL_STARTUP $EP_IDL_STARTUP

# IDL 'dynamic memory' size controlled by the csh variable datasize
# Default datasize for ppq on the mpecl is 131 Mbytes
# This is set only for this process. 
     limit datasize unlimited

#     setenv > setenv${j}.txt

     idl ${EP_CODE_PATH}/edi_piso_wrapper

# Remove MSF and fgm files (edi_sprod case) from working directory
     rm -f ${EP_TEMPDATA_PATH}/$ftemp
     if ("${SPROD_OK}" == "1") rm -f ${EP_TEMPDATA_PATH}/fgm*.txt

     echo "============================================"

     next_file:

end

# Remove everything from tempdata directory and the directory itself
rm -f ${EP_TEMPDATA_PATH}/*
rmdir ${EP_TEMPDATA_PATH}

exit
