function ep_rotate, scnum_in, $ ; IN
                    ttype_in0, time_in, $ ; IN
                    vtype_in0, vec_in, $ ; IN
                    vtype_out0, vec_out, $ ; IN/OUT
                    date=date_in, att_orb_hpath=ao_hpath_in, $
                    cache_rotmats=cache_rotmats, $ ; IN
                    use_spaux_info=use_spaux_info, $
                    spaux_path=spaux_path_in

common ep_rotate_cb, ccache, cmethod, csc_number, ctime, cpp_att_orb_hpath, satgse_cache, satgei_cache, geocgse_cache, geigse_cache, gsegsm_cache, magsm_cache, smgse_cache

; Process keywords and massage some of the arguments
ttype_in = strlowcase(ttype_in0)
vtype_in = strlowcase(vtype_in0)
vtype_out = strlowcase(vtype_out0)
if (n_elements(ao_hpath_in) eq 0) then $
  pp_att_orb_hpath = '/nfs/cl5/data/orbit/' else $
  pp_att_orb_hpath = ao_hpath_in
sc_number = string(scnum_in,'(i1)')
if (ttype_in ne 't70') then $
  time = ep_time_handler(time_in, ttype_in, 't70', date=date_in) else $
  time = time_in
cache_rotmats = keyword_set(cache_rotmats)
use_spaux_info = keyword_set(use_spaux_info)
if (n_elements(spaux_path_in) eq 0) then $
  spaux_path = 'nfs/cl11/CDF/spaux/' else $
  spaux_path = spaux_path_in
if (use_spaux_info) then method = 'spaux' else method = 'hapgood'
if ((vtype_in eq 'gei' or vtype_out eq 'gei') and $
    use_spaux_info) then begin
    message, 'GEI rotation info not available in the SPAUX files.', /cont
    message, 'Must turn off the "use_spaux_info" keyword.', /cont
    return, 0
endif

if ((vtype_in eq 'mag' or vtype_out eq 'mag') and $
    use_spaux_info) then begin
    message, 'MAG rotation info not available in the SPAUX files.', /cont
    message, 'Must turn off the "use_spaux_info" keyword.', /cont
    return, 0
endif

; Define the intermediate output array, vrot
ntime = n_elements(time)
vrot = make_array(size=size(vec_in))
vrot = double(vrot)             ; We'll work internally in double precision

; Check to see if the right rotation matricies are already in the cache
if (n_elements(ccache) ne 0) then begin
    if (cmethod ne method) then goto, all
    if (csc_number ne sc_number) then goto, all
    if (n_elements(ctime) ne n_elements(time)) then goto, all
    if (min(ctime-time) ne 0. or max(ctime-time) ne 0.) then goto, all
    if (cpp_att_orb_hpath ne pp_att_orb_hpath) then goto, all
    message, 'Rotation matricies already in cache', /cont
    for itime=0,ntime-1 do begin
        vin = double(vec_in(*,itime))
        if (not use_spaux_info) then $
          vout = ep_rotate_handler(vtype_in, vin, vtype_out, $
                                   satgse_cache(*,*,itime), $
                                   gsegsm_cache(*,*,itime), $
                                   satgei_cache(*,*,itime), $
                                   geocgse_cache(*,*,itime), $
                                   geigse_cache(*,*,itime), $
                                   magsm=magsm_cache(*,*,itime), $
                                   smgse=smgse_cache(*,*,itime)) else $
          vout = ep_rotate_handler(vtype_in, vin, vtype_out, $
                                   satgse_cache(*,*,itime), $
                                   gsegsm_cache(*,*,itime))
        vrot(*,itime) = vout
    endfor
    vec_out = vrot
    return, 1
endif

;==============================================================
all:

if (use_spaux_info) then begin
    
    message, 'Using spaux_info.pro to get the rotation matricies...', /cont
    istat = spaux_info(sc_number, time, 't70', $
                       spaux_path=spaux_path, /rotmat, $
                       sat2gse_rotmat=satgse, $
                       gse2gsm_rotmat=gsegsm)
    for itime=0,ntime-1 do begin
        vin = double(vec_in(*,itime))
        vout = ep_rotate_handler(vtype_in, vin, vtype_out, $
                                 satgse(*,*,itime), $
                                 gsegsm(*,*,itime))
        vrot(*,itime) = vout
    endfor
    if (cache_rotmats) then begin
        satgse_cache = satgse
        gsegsm_cache = gsegsm
        ccache = 1
        cmethod = method
        csc_number = sc_number
        ctime = time
        cpp_att_orb_hpath = pp_att_orb_hpath
    endif    
    
endif else begin
    
;    message, 'Using Hapgood routines to get rotation matricies...', /cont
;    message, 'This takes awhile...', /cont
    
    if (cache_rotmats) then begin
        satgse_cache = dblarr(3,3,ntime)
        satgei_cache = dblarr(3,3,ntime)
        geocgse_cache = dblarr(3,3,ntime)
        geigse_cache = dblarr(3,3,ntime)
        gsegsm_cache = dblarr(3,3,ntime)
        magsm_cache = dblarr(3,3,ntime)
        smgse_cache = dblarr(3,3,ntime)
    endif
    
    for itime=0L,ntime-1 do begin ; Hapgood routines are not vectorized
        
        chunk_mid_t70 = time(itime)    
        
        att_stat = ep_extract_att(sc_number,chunk_mid_t70,decl,rasc,$
                                  pp_att_orb_hpath)
        if (not att_stat) then begin
            message, 'Attitude info extraction unsuccessful', /cont
            return, 0
        endif
        
; NOTE: All rotation matricies have been constructed so that the first
; index is the 'row' index, and the second index is the 'column'
; index, i.e., M(irow,icol) so that to use them:
;       v_rotated(i) = M(i,k)*v(k) (in Einstein notation).
; I know this doesn't lend itself easily to using the IDL matrix
; operators, but I didn't figure this out until afterwards...
        
        mi0 = long(chunk_mid_t70)
        mi1 = long( (chunk_mid_t70 - mi0)*1d6 )
        pick_cvt_sec_vax, [mi0,mi1], mistr ; '09-Dec-2000 02:59:42.583'
        date = date2datevax(strmid(mistr,0,11),/reverse)
        year = long(strmid(date,0,4))
        mon = long(strmid(date,4,2))
        day = long(strmid(date,6,2))
        hour = long(strmid(mistr,12,2))
        minute = long(strmid(mistr,15,2))
        nlen = strlen(mistr)
        sec = double(strmid(mistr,18,nlen-18))
        
        ep_get_haprotmat, year, mon, day, hour, minute, sec, $
          rasc, decl, ierr, $
          satgse=satgse, $
          satgei=satgei, geigse=geigse, $
          gsegsm=gsegsm, magsm=magsm, smgse=smgse, $
          geocgse=geocgse

        if (cache_rotmats) then begin
            satgse_cache(*,*,itime) = satgse
            satgei_cache(*,*,itime) = satgei
            geocgse_cache(*,*,itime) = geocgse
            geigse_cache(*,*,itime) = geigse
            gsegsm_cache(*,*,itime) = gsegsm
            magsm_cache(*,*,itime) = magsm
            smgse_cache(*,*,itime) = smgse
        endif
        
        if (ierr ne 0) then begin
            message, 'Haprotmat extraction unsuccessful', /cont
            return, 0
        endif
        
        vin = double(vec_in(*,itime))
        vout = ep_rotate_handler(vtype_in, vin, vtype_out, $
                                 satgse, gsegsm, satgei, geigse, $
                                 magsm=magsm, smgse=smgse, geocgse=geocgse)
        vrot(*,itime) = vout
    endfor
    
    if (cache_rotmats) then begin
        ccache = 1
        cmethod = method
        csc_number = sc_number
        ctime = time
        cpp_att_orb_hpath = pp_att_orb_hpath
    endif
    
endelse

vec_out = vrot
return, 1

end

