function ep_errorfree_check, sn, checknum, mode_fields

mode_fields(4) = sn.shdr.m5.init_table
mode_fields(5) = sn.shdr.m5.sob
mode_fields(6) = sn.shdr.m5.code_type
mode_fields(7) = ep_calc_samtype(sn.shdr.m5.init_table)

; At this point we're in Science mode 5, and NON-RAM-DUMP...
; So why would the data_count ever be 0?  I don't know, but
; it happens (unfortunately) so I have to check it here...
; Another ground software bug?
pacmo_str = string(sn.hdr.pacmo,'(i1)')
estat = execute('pdata=sn.pacmo'+pacmo_str) ; Packet data
if (pdata.data_count le 0) then begin
    checknum = 4
    return, 0
endif

; No illegal combinations of NNN, CODE_TYPE and SAMPLE_TYPE
; Since NNN is on the subpacket level, throw out the whole packet if
; any one of the subpackets meets the following condition.  Could code
; this better in the future...
if (mode_fields(6) eq 0 and mode_fields(7) eq 4) then begin ; Short/4-samp
    pacmo_str = string(sn.hdr.pacmo,'(i1)')
    estat = execute('pdata=sn.pacmo'+pacmo_str) ; Packet data
    n_subp = pdata.data_count
    nnn64 = where(pdata.data(0:n_subp-1).nnn eq 64)
    if (nnn64(0) ne -1) then begin
        checknum = 5
        return, 0
    endif
endif

; 7th bit of SOB consistent with energy switching
if (not ep_bit7sob_eswitch_check(sn)) then begin
    checknum = 6
    return, 0
endif
        
; Some timing anomolies still exist
if (not ep_timeanom_check(sn)) then begin
    checknum = 7
    return, 0
endif

; Have some cases where srt=0
if (sn.srt(0) eq 0) then begin
    checknum = 8
    return, 0
endif

; Have some cases where tspin is huge
if (sn.tspin lt 2000000. or $
    sn.tspin gt 6000000.) then begin
    checknum = 9
    return, 0
endif

return, 1
end
