pro ep_convert_iff, inpath, outpath, rename=rename, date=date_in

;+
; NAME: ep_convert_iff.pro
;
; PURPOSE: Replace those status='BAD' data lines of an IFF
;          file with fill lines.
;
; CATEGORY: File manipulation
;
; CALLING SEQUENCE: ep_convert_iff, inpath, outpath, rename=rename
;
; INPUTS:  inpath      String, Where the original IFF files reside.
;          outpath     String, Where the converted IFF files are written.
;
; KEYWORD PARAMETERS:  /rename    If set, the original IFF file is
;                                 renamed to have an '.IFFALL'
;                                 extension
;                      date='YYYYMMDD' String, if set, only this day
;                                      will be processed.
;
; OUTPUTS: None
;
; MODIFICATION HISTORY: Written 10.10.2001, Pamela A. Puhl-Quinn
;-

pp_rfill = -1.e+31
pp_bfill = 255
rename = keyword_set(rename)
if (n_elements(date_in) eq 0) then date_in='????????'

; Get the names of all IFF files
fnames = findfile(inpath+'/'+'C?_PP_EDI_'+date_in+'.IFF')

if (fnames(0) eq '') then begin
    message, 'No IFF files found in this directory: '+inpath, /cont
    return
endif

; For each file, loop over all lines and replace those data lines with
; 'BAD' data status with fill lines.

for ifile=0,n_elements(fnames)-1 do begin
    
    forig = fnames(ifile)
    nlen = strlen(forig)
    date = strmid(forig,nlen-12,8)
    scnum = strmid(forig,nlen-21,1)
    
    message, '=================================================', /cont
    message, 'Opening '+forig, /cont
    openr, uorig, forig, /get_lun
    
    fout = outpath+'/'+'C'+scnum+'_PP_EDI_'+date+'.IFF'
    message, 'Opening '+fout, /cont
    openw, uout, fout, /get_lun
    
;R 000167 14:11:26.144 51086144 002 069 255 008 017 003 000 -7.485e+00 -5.894e+00  6.723e+00 -9.419e-01  1.087e+00 -9.615e-02  1.503e+00
    dum = ''
    i = -1L
    d = ''
    n = 0L
    t = ''
    ms = 0L
    s0 = 0L
    s1 = 0L
    s2 = 0L
    s3 = 0L
    s4 = 0L
    s5 = 0L
    s6 = 0L
    r1 = 0.
    r2 = 0.
    r3 = 0.
    r4 = 0.
    r5 = 0.
    r6 = 0.
    r7 = 0.

    while not eof(uorig) do begin
        
        readf, uorig, dum
        if (strmid(dum,0,1) eq 'R') then begin
            
            reads, dum, d,n,t,ms,s0,s1,s2,s3,s4,s5,s6,r1,r2,r3,r4,r5,r6,r7, $
              format='(a1,1x,i6.6,1x,a12,1x,i8.8,1x,7(i3.3,1x),6(e10.3,1x),e10.3)'
            
            if (s0 ne 0) then begin
                printf, uout, dum
            endif else begin    ; 'BAD' record replaced with fill values
                printf, uout, d, n, t, ms, $
                  pp_bfill, pp_bfill, pp_bfill, pp_bfill, $
                  pp_bfill, pp_bfill, pp_bfill, $
                  pp_rfill, pp_rfill, pp_rfill, pp_rfill, $
                  pp_rfill, pp_rfill, pp_rfill, $
                  format='(a1,1x,i6.6,1x,a12,1x,i8.8,1x,7(i3.3,1x),6(e10.3,1x),e10.3)'
            endelse
            
        endif else begin
            printf, uout, dum
        endelse
        
    endwhile
    free_lun, uorig
    free_lun, uout

    if (rename) then begin
        message, 'Renaming the original IFF file to IFFALL', /cont
        spawn, 'mv '+forig+' '+forig+'ALL', sout
    endif
    
endfor


return
end
