pro ep_construct_scs2bpp, bhat_scs, scs2gse, $ ; IN
                          flip, yhatgse_scs, scs2bpp, bpp2scs ; OUT

flip = 0
zhatbpp_scs = bhat_scs          ; Unit length, zhat of the BPP coordinate 
                                ; system as seen from the SCS 
                                ; coordinate system
                                ; Might have to flip this

zhatbpp_gse = [total(scs2gse(0,*)*zhatbpp_scs,/double), $
               total(scs2gse(1,*)*zhatbpp_scs,/double), $
               total(scs2gse(2,*)*zhatbpp_scs,/double)]

if (zhatbpp_gse(2) lt 0.) then begin ; Must flip
    flip = 1
    zhatbpp_scs = -1.d0*zhatbpp_scs
endif

; At this point:
;                zhatbpp_scs has been forced to have 
;                a POSITIVE Z-GSE sense so that
;                yhatgse_scs cross zhatbpp_scs is guaranteed to have a
;                POSITIVE X-GSE sense (which is what we want).

gse2scs = transpose(scs2gse)    ; Orthogonal, Inverse=Transpose

; yhatgse_gse = yhat of the GSE system as seen from GSE
yhatgse_gse = [0.d0,1.d0,0.d0]  ; Unit length

; yhatgse_scs = yhat of the GSE system as seen from SCS
yhatgse_scs = [total(gse2scs(0,*)*yhatgse_gse,/double), $ ; Unit length
               total(gse2scs(1,*)*yhatgse_gse,/double), $
               total(gse2scs(2,*)*yhatgse_gse,/double)]

; xhatbpp_scs = xhat of the BPP coordinate system as seen from SCS
;             = yhatgse_scs X zhatbpp_scs (and then normalized)
;               Guaranteed to have a sunward sense.
xhatbpp_scs = [yhatgse_scs(1)*zhatbpp_scs(2)-yhatgse_scs(2)*zhatbpp_scs(1), $
               yhatgse_scs(2)*zhatbpp_scs(0)-yhatgse_scs(0)*zhatbpp_scs(2), $
               yhatgse_scs(0)*zhatbpp_scs(1)-yhatgse_scs(1)*zhatbpp_scs(0)]
xhatbpp_scs = xhatbpp_scs/sqrt(total(xhatbpp_scs^2,/double)) ; Unit length

; yhatbpp_scs = yhat of the BPP coordinate system as seen from SCS
;             = zhatbpp_scs X xhatbpp_scs
yhatbpp_scs = [zhatbpp_scs(1)*xhatbpp_scs(2)-zhatbpp_scs(2)*xhatbpp_scs(1), $
               zhatbpp_scs(2)*xhatbpp_scs(0)-zhatbpp_scs(0)*xhatbpp_scs(2), $
               zhatbpp_scs(0)*xhatbpp_scs(1)-zhatbpp_scs(1)*xhatbpp_scs(0)]
; No need to normalize yhatbpp_scs because zhatbpp_scs and xhatbpp_scs
; are already of unit length and are orthogonal.

scs2bpp = dblarr(3,3)
scs2bpp(2,*) = zhatbpp_scs
scs2bpp(0,*) = xhatbpp_scs
scs2bpp(1,*) = yhatbpp_scs

bpp2scs = transpose(scs2bpp)

return
end
