pro ep_choose_tri_beams, beam, TRI_OK

common ep_envar_con_cb

; NOTE: "C", "D", and "G" class beams have been given 
; an "out" value of 3 already in the routine ep_prep_order.pro

;============================================================
; Triangulation-worthy beams:
; 1) maxchan = 7
; 2) beam quality = 1, 2 or 3 (out eq 0 or 1) and
;    not triangulation outlier (out ne 2)  and
;    Class "A" or "B" only (out ne 3)

beam.tri_ok(*) = 0              ; Initialize

id_tri = where(beam.maxchan eq 7 and $
               beam.out le 1)
if (id_tri(0) ne -1) then beam.tri_ok(id_tri) = 1

TRI_OK = 1
if (n_elements(where(beam.tri_ok eq 1)) lt pp_nbeam_min) then TRI_OK = 0

return
end
