pro ep_calculate_dp, edi6, bpp2scs, scs2bpp, gei2gse, scs2gse, $ ; IN
                     bx_scs, by_scs, bz_scs, $ ; IN
                     scnum, t70, hpath, flip, log_unit, $ ; IN
                     d_bpp, d_scs, d_gse, $ ; OUT
                     v_bpp, v_scs, v_gse, $ ; OUT
                     e_bpp, e_scs, e_gse, $ ; OUT
                     v_gse_nocorr=v_gse_nocorr, $ ; OUT
                     e_gse_nocorr=e_gse_nocorr, $ ; OUT
                     vsc_gse=vsc_gse, $ ; OUT
                     b_gse=b_gse, $ ; OUT
                     method=method, $ ; IN
                     e_scs_earthframe=e_scs_earthframe, $ ; OUT
                     magd_error=magd_error, phid_error=phid_error, $ ; IN
                     ambig_180=ambig_180, $ ; IN
                     mei=magd_error_inertial, pei=phid_error_inertial, $ ; OUT
                     e_dsi_scframe=e_dsi_scframe, $ ; OUT
                     e_dsi_earthframe=e_dsi_earthframe

common ep_envar_con_cb

; Initialize
d_bpp=fltarr(3) & d_scs=fltarr(3) & d_gse=fltarr(3)
v_bpp=fltarr(3) & v_scs=fltarr(3) & v_gse=fltarr(3)
e_bpp=fltarr(3) & e_scs=fltarr(3) & e_gse=fltarr(3)
e_scs_earthframe = fltarr(3)
e_dsi_scframe = fltarr(3)
e_dsi_earthframe = fltarr(3)

; Calculate the target vector in BPP (b-perp plane)
target = edi6(0)*[cos(edi6(2)*pp_deg2rad),$ ; m
                  sin(edi6(2)*pp_deg2rad),$
                  0.]

; Calculate b, d, v, e in BPP
bmag = sqrt(bx_scs^2+by_scs^2+bz_scs^2) ; nT
if (flip) then b_bpp=[0.,0.,-1.*bmag] else $ ; nT
  b_bpp=[0.,0.,bmag]
d_bpp = -1.*target              ; m
v_bpp_cgs = d_bpp*1e+2/(edi6(4)*1e-6) ; cm/s
b_bpp_cgs = b_bpp*pp_nt2gauss   ; gauss
vcrossb_cgs = [v_bpp_cgs(1)*b_bpp_cgs(2) - v_bpp_cgs(2)*b_bpp_cgs(1), $
               v_bpp_cgs(2)*b_bpp_cgs(0) - v_bpp_cgs(0)*b_bpp_cgs(2), $
               v_bpp_cgs(0)*b_bpp_cgs(1) - v_bpp_cgs(1)*b_bpp_cgs(0)]
e_bpp = -1./pp_clight_cgs*vcrossb_cgs*pp_svpcm2mvpm ; mV/m
v_bpp = v_bpp_cgs/1e5           ; km/s

;----------V/E consistency check------------------
;vcgs = v_bpp*1.e+5
;bcgs = b_bpp*pp_nt2gauss
;vcrossb = [vcgs(1)*bcgs(2) - vcgs(2)*bcgs(1), $
;           vcgs(2)*bcgs(0) - vcgs(0)*bcgs(2), $
;           vcgs(0)*bcgs(1) - vcgs(1)*bcgs(0)]
;ecgs = -1./pp_clight_cgs*vcrossb
;emvpm = ecgs*pp_svpcm2mvpm
;print, 'V/E BPP check: ----------------------'
;print, e_bpp
;print, emvpm
;-------------------------------------------------

; Calculate d, v, e in the SCS system, Satellite frame
d_scs = [total(bpp2scs(0,*)*d_bpp,/double), $ ; m
         total(bpp2scs(1,*)*d_bpp,/double), $
         total(bpp2scs(2,*)*d_bpp,/double)]

v_scs = [total(bpp2scs(0,*)*v_bpp,/double), $ ; km/s
         total(bpp2scs(1,*)*v_bpp,/double), $
         total(bpp2scs(2,*)*v_bpp,/double)]

e_scs = [total(bpp2scs(0,*)*e_bpp,/double), $ ; mV/m
         total(bpp2scs(1,*)*e_bpp,/double), $
         total(bpp2scs(2,*)*e_bpp,/double)]

;---------------------------------------------------------------
; Return the electric field in DSI coordinates, spacecraft frame
; (don't correct for spacecraft motion)

; Notes from Yuri on definition of DSI:
;   Satellite spin axis (Z SCS) is close to -Z GSE. 
;   We invert Z and Y axes of SCS so that we have a new system, 
;   DSI, which we can approximately regard as GSE.
;
;    X_DSI = X_SCS ~= X_GSE
;    Y_DSI = -Y_SCS ~= Y_GSE
;    Z_DSI = -Z_SCS ~= Z_GSE

;Yuri Khotyaintsev, PhD
;---------------------------------------------------------------

e_dsi_scframe(0) = e_scs(0)     ; mV/m
e_dsi_scframe(1) = -1.*e_scs(1)
e_dsi_scframe(2) = -1.*e_scs(2)

b_dsi = [bx_scs,-1.*by_scs,-1.*bz_scs]
v_dsi = [v_scs(0),-1.*v_scs(1),-1.*v_scs(2)]
;---------------------------------------------------------------


b_scs = [bx_scs,by_scs,bz_scs]  ; nT

;----------bpp2scs check--------------------------
;print, 'bpp2scs check: ----------------------'
;b_scs2 = [total(bpp2scs(0,*)*b_bpp,/double), $ ; nT
;          total(bpp2scs(1,*)*b_bpp,/double), $
;          total(bpp2scs(2,*)*b_bpp,/double)]
;print, b_scs
;print, b_scs2
;-------------------------------------------------

;----------V/E consistency check------------------
;vcgs = v_scs*1.e+5
;bcgs = b_scs*pp_nt2gauss
;vcrossb = [vcgs(1)*bcgs(2) - vcgs(2)*bcgs(1), $
;           vcgs(2)*bcgs(0) - vcgs(0)*bcgs(2), $
;           vcgs(0)*bcgs(1) - vcgs(1)*bcgs(0)]
;ecgs = -1./pp_clight_cgs*vcrossb
;emvpm = ecgs*pp_svpcm2mvpm
;print, 'V/E SCS check: ----------------------'
;print, e_scs
;print, emvpm
;-------------------------------------------------

; Rotate from SCS2GSE, still satellite frame
d_gse = [total(scs2gse(0,*)*d_scs,/double), $ ; m
         total(scs2gse(1,*)*d_scs,/double), $
         total(scs2gse(2,*)*d_scs,/double)]

v_gse = [total(scs2gse(0,*)*v_scs,/double), $ ; km/s
         total(scs2gse(1,*)*v_scs,/double), $
         total(scs2gse(2,*)*v_scs,/double)]

e_gse = [total(scs2gse(0,*)*e_scs,/double), $ ; mV/m
         total(scs2gse(1,*)*e_scs,/double), $
         total(scs2gse(2,*)*e_scs,/double)]

b_gse = [total(scs2gse(0,*)*b_scs,/double), $ ; nT
         total(scs2gse(1,*)*b_scs,/double), $
         total(scs2gse(2,*)*b_scs,/double)]

v_gse_nocorr = v_gse            ; Satellite frame
e_gse_nocorr = e_gse            ; Satellite frame

;----------V/E consistency check------------------
;vcgs = v_gse*1.e+5
;bcgs = b_gse*pp_nt2gauss
;vcrossb = [vcgs(1)*bcgs(2) - vcgs(2)*bcgs(1), $
;           vcgs(2)*bcgs(0) - vcgs(0)*bcgs(2), $
;           vcgs(0)*bcgs(1) - vcgs(1)*bcgs(0)]
;ecgs = -1./pp_clight_cgs*vcrossb
;emvpm = ecgs*pp_svpcm2mvpm
;print, 'V/E GSE check: ----------------------'
;print, e_gse
;print, emvpm
;-------------------------------------------------

; Get the SC velocity
epoch = ep_time_handler(t70,'t70','epoch')
cdf_epoch, epoch, year, month, day, hour, minute, second, msec, /break
second = double(second) + double(msec)/1000.d0
jd2000, mjd2000, year, month, day, hour, minute, second
ep_orbit, mjd2000, 6, hpath+'/stof.cl'+scnum, ierr, nsat, svec, revnum
if (ierr ne 0) then begin
    printf, log_unit, '-----------------------------------------'
    printf, log_unit, 'ep_orbit.pro failure:  ierr = '+strtrim(ierr,2)
    printf, log_unit, '   No V_SC correction to V_GSE or E_GSE possible'
    printf, log_unit, '   v_gse, vsc_gse and e_gse all set to fill'
    v_gse = fltarr(3) + pp_rfill
    vsc_gse = fltarr(3) + pp_rfill
    e_gse = fltarr(3) + pp_rfill
    return
endif

vgei = svec(3:5)                ; km/s
vsc_gse = [total(gei2gse(0,*)*vgei), $
           total(gei2gse(1,*)*vgei), $
           total(gei2gse(2,*)*vgei)]

; Errors on inertial frame drift step (performed in the BPP)
gse2scs = invert(scs2gse, /double)
ep_errors_inertial, v_bpp, vsc_gse, gse2scs, scs2bpp, $ ; IN
  edi6(4), magd_error, phid_error, ambig_180, $ ; IN
  magd_error_inertial, phid_error_inertial ; OUT

; What is the perpendicular part of vsc_gse?
bhat_gse = b_gse/sqrt(total(b_gse^2))
dot = total(vsc_gse*bhat_gse)
vsc_parl_gse = dot*bhat_gse
vsc_perp_gse = vsc_gse - vsc_parl_gse

; What is the perpendicular part of vsc_scs?
vsc_scs = [total(gse2scs(0,*)*vsc_gse), $
           total(gse2scs(1,*)*vsc_gse), $
           total(gse2scs(2,*)*vsc_gse)]
bhat_scs = b_scs/sqrt(total(b_scs^2))
dot = total(vsc_scs*bhat_scs)
vsc_parl_scs = dot*bhat_scs
vsc_perp_scs = vsc_scs - vsc_parl_scs

; What is the perpendicular part of vsc_dsi?
vsc_dsi = [vsc_scs(0),-1.*vsc_scs(1),-1.*vsc_scs(2)]
bhat_dsi = b_dsi/sqrt(total(b_dsi^2))
dot = total(vsc_dsi*bhat_dsi)
vsc_parl_dsi = dot*bhat_dsi
vsc_perp_dsi = vsc_dsi - vsc_parl_dsi


;=================================================
; Correct v_gse and e_gse for the satellite motion
;=================================================

; Drift Velocity correction (Galilean):
;       V_DRIFT_EARTH = V_DRIFT_WRT_SC + V_SC_WRT_EARTH
; The drift velocity with respect to the earth is equal to the drift
; velocity with respect to spacecraft plus the velocity of spacecraft with
; respect to the earth.
; WRONG WRONG WRONG    v_gse = v_gse + vsc_gse         ; km/s
; ONLY CORRECT FOR THE PERP COMPONENT OF THE SC MOTION!!
v_gse = v_gse + vsc_perp_gse    ; km/s, Earth frame


goto, skip_hav_check
;============================
; HAV CHECK==================
t_ssm = ep_time_handler(t70,'t70','ssm')
if (t_ssm-2. ge 18.*3600.+7.*60.+27.) then begin
    
    openw, havu, '15-Feb-2001_hans_out2.txt', /get_lun
    printf, havu, 'Center Time [ssm]:        ', t_ssm
    printf, havu, 'Tgyro [microsec]:         ', edi6(4)
    printf, havu, 'Target [m,BPP]:           ', target(0), target(1), target(2), sqrt(total(target^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Drift Step [m,BPP]:       ', d_bpp(0), d_bpp(1), d_bpp(2), sqrt(total(d_bpp^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Drift Velo [km/s,BPP]:    ', v_bpp(0), v_bpp(1), v_bpp(2), sqrt(total(v_bpp^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Drift Step [m,SCS]:       ', d_scs(0), d_scs(1), d_scs(2), sqrt(total(d_scs^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Drift Velo [km/s,SCS]:    ', v_scs(0), v_scs(1), v_scs(2), sqrt(total(v_scs^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Mag. Field [nT,SCS]:      ', bx_scs, by_scs, bz_scs, sqrt(bx_scs^2+by_scs^2+bz_scs^2), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Drift Step [m,GSE_nc]:    ', d_gse(0), d_gse(1), d_gse(2), sqrt(total(d_gse^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Drift Velo [km/s,GSE_nc]: ', v_gse_nocorr(0), v_gse_nocorr(1), v_gse_nocorr(2), sqrt(total(v_gse_nocorr^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'SC Velo [km/s,GSE]:       ', vsc_gse(0), vsc_gse(1), vsc_gse(2), sqrt(total(vsc_gse^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, 'Perp SC Velo [km/s,GSE]:  ', vsc_perp_gse(0), vsc_perp_gse(1), vsc_perp_gse(2), sqrt(total(vsc_perp_gse^2)), format='(a26,2x,4(f8.4,1x))'
    printf, havu, '===============FINAL ANSWER=============='
    printf, havu, 'Drift Velo [km/s,GSE]:    ', v_gse(0), v_gse(1), v_gse(2), sqrt(total(v_gse^2)), format='(a26,2x,4(f8.4,1x))'

    havec = [-13.9803, 19.5066, 2.07693]
    printf, havu, 'Drift Velo [km/s,GSE] HAV:', havec(0), havec(1), havec(2), sqrt(total(havec^2)), format='(a26,2x,4(f8.4,1x))'

    m1 = sqrt(total(v_gse^2))
    m2 = sqrt(total(havec^2))
    ad = acos(total(v_gse*havec)/m1/m2)*!radeg
    printf, havu, 'Angle Difference [deg]:      ', ad
    printf, havu, 'Magnitude Difference [km/s]: ', abs(m1-m2)

    free_lun, havu
    stop
endif
; HAV CHECK==================
;============================
skip_hav_check:


; Electric Field correction (Galilean) IN GSE COORDINATES:
;       E_EARTH = -1/c * (V_DRIFT_EARTH x B)
; The electric field with respect to the earth is equal to minus
; the inverse of the speed of light times the drift velocity
; with respect to the earth crossed with the magnetic field (gaussian units).
b_gse_cgs = b_gse*pp_nt2gauss   ; cgs
v_gse_cgs = v_gse*1.e+5         ; cgs
vcrossb_cgs = [v_gse_cgs(1)*b_gse_cgs(2) - v_gse_cgs(2)*b_gse_cgs(1), $
               v_gse_cgs(2)*b_gse_cgs(0) - v_gse_cgs(0)*b_gse_cgs(2), $
               v_gse_cgs(0)*b_gse_cgs(1) - v_gse_cgs(1)*b_gse_cgs(0)]
e_gse_cgs = -1./pp_clight_cgs*vcrossb_cgs
e_gse = e_gse_cgs*pp_svpcm2mvpm ; mV/m, Earthframe


; Electric Field correction (Galilean) IN SCS CORRDINATES:
b_scs_cgs = b_scs*pp_nt2gauss   ; cgs
v_scs_cgs = (v_scs+vsc_perp_scs)*1.e+5 ; cgs, Earth frame
vcrossb_cgs = [v_scs_cgs(1)*b_scs_cgs(2) - v_scs_cgs(2)*b_scs_cgs(1), $
               v_scs_cgs(2)*b_scs_cgs(0) - v_scs_cgs(0)*b_scs_cgs(2), $
               v_scs_cgs(0)*b_scs_cgs(1) - v_scs_cgs(1)*b_scs_cgs(0)]
e_scs_cgs = -1./pp_clight_cgs*vcrossb_cgs
e_scs_earthframe = e_scs_cgs*pp_svpcm2mvpm ; mV/m, Earthframe


; Electric Field correction (Galilean) IN DSI CORRDINATES:
b_dsi_cgs = b_dsi*pp_nt2gauss   ; cgs
v_dsi_cgs = (v_dsi+vsc_perp_dsi)*1.e+5 ; cgs, Earth frame
vcrossb_cgs = [v_dsi_cgs(1)*b_dsi_cgs(2) - v_dsi_cgs(2)*b_dsi_cgs(1), $
               v_dsi_cgs(2)*b_dsi_cgs(0) - v_dsi_cgs(0)*b_dsi_cgs(2), $
               v_dsi_cgs(0)*b_dsi_cgs(1) - v_dsi_cgs(1)*b_dsi_cgs(0)]
e_dsi_cgs = -1./pp_clight_cgs*vcrossb_cgs
e_dsi_earthframe = e_dsi_cgs*pp_svpcm2mvpm ; mV/m, Earthframe

return
end
