function ep_calc_samtype, init_table

; Sample type (2 versus 4) comes from the init_table:
;       2 sample for tables 2e,2f,5e,5f,30,31,60,61
;       4 sample for tables 2a,2b,5a,5b,2c,2d,5c,5d
inds2 = ['2e'x,'2f'x,'5e'x,'5f'x,'30'x,'31'x,'60'x,'61'x]
inds4 = ['2a'x,'2b'x,'5a'x,'5b'x,'2c'x,'2d'x,'5c'x,'5d'x]
maxind = max([inds2,inds4])
sample_map = make_array(maxind+1,/byte,value=255)
sample_map(inds2) = 2
sample_map(inds4) = 4
if (init_table gt maxind or $
    init_table lt 0) then begin
    SAMPLETYPE = 255b            ; Init table unknown
endif else begin
    SAMPLETYPE = sample_map(init_table)
endelse

return, SAMPLETYPE
end
