;	ep_calc_beamwidth.pro,v 1.2 2001/05/25 17:01:12 ppq Exp	
pro ep_calc_beamwidth, g1ph, g1th, g2ph, g2th, omega, dt1, dt2, $
   bx_scs, by_scs, bz_scs, $
   bwidth1, bwidth2

common ep_envar_con_cb

; Define the scs2 coordinate system, and recast B
;       x_scs2 = z_scs
;       y_scs2 = x_scs
;       z_scs2 = y_scs
bx_scs2 = bz_scs
by_scs2 = bx_scs
bz_scs2 = by_scs

;=================================================================
; GUN1 -- GUN1 -- GUN1 -- GUN1 -- GUN1 -- GUN1 -- GUN1 -- GUN1 -- 
;=================================================================
; Gun1 firing directions in G1S coordinates:
; G1S means Gun1-referenced and spinning:
;       x=spin axis
;       z=radially outward through Gun1
;       y=z cross x
gx = sin(g1th*!dtor) * cos(g1ph*!dtor)
gy = sin(g1th*!dtor) * sin(g1ph*!dtor)
gz = cos(g1th*!dtor)

; Bfield directions in G1S coordinates:
phase0 = -26.2*!dtor ; radians
wt = omega*dt1       ; radians
bx = bx_scs2
by = cos(wt+phase0)*by_scs2 + sin(wt+phase0)*bz_scs2
bz = cos(wt+phase0+90.*!dtor)*by_scs2 + sin(wt+phase0+90.*!dtor)*bz_scs2

bwidth1=make_array(n_elements(g1ph),/float,value=pp_acfir_rad)
if (pp_acfir_assign eq 1) then bwidth1=beamwidth(gx,gy,gz,bx,by,bz)*!dtor else if (pp_acfir_assign eq 2) then bwidth1=sigma_angle(bz,gz)*!dtor

;=================================================================
; GUN2 -- GUN2 -- GUN2 -- GUN2 -- GUN2 -- GUN2 -- GUN2 -- GUN2 -- 
;=================================================================
; Gun2 firing directions in G2S coordinates:
; G2S means Gun2-referenced and spinning:
;       x=spin axis
;       z=radially outward through Gun2
;       y=z cross x
gx = sin(g2th*!dtor) * cos(g2ph*!dtor)
gy = sin(g2th*!dtor) * sin(g2ph*!dtor)
gz = cos(g2th*!dtor)

; Bfield directions in G2S coordinates:
phase0 = (180.-26.2)*!dtor ; radians
wt = omega*dt2             ; radians
bx = bx_scs2
by = cos(wt+phase0)*by_scs2 + sin(wt+phase0)*bz_scs2
bz = cos(wt+phase0+90.*!dtor)*by_scs2 + sin(wt+phase0+90.*!dtor)*bz_scs2

bwidth2=make_array(n_elements(g2ph),/float,value=pp_acfir_rad)
if (pp_acfir_assign eq 1) then bwidth2=beamwidth(gx,gy,gz,bx,by,bz)*!dtor else if (pp_acfir_assign eq 2) then bwidth2=sigma_angle(bz,gz)*!dtor

;print, bwidth1*!radeg
;print, bwidth2*!radeg

return
end
        
