pro edi_piso_write_iff_header, iff_unit, finfo, sc_id_str

common ep_envar_con_cb

printf, iff_unit, '%I Pamela Puhl-Quinn MPE EDI_PISO Version '+pp_rcs_snapshot_name
printf, iff_unit, '%I EDI_PISO configuration: '+finfo.config
printf, iff_unit,'G Logical_file_id "C' + sc_id_str + '_PP_EDI_' + $
  finfo.date + '_V00"'
printf, iff_unit,'G MODS " "'
printf, iff_unit,'G Parents "RDM>' + finfo.date + '"'
printf, iff_unit,'G Software_version "EDI_PISO '+pp_rcs_snapshot_name+'"'

if (sc_id_str eq '4') then printf, iff_unit, 'G Caveats "C4 EDI switched off"' else printf, iff_unit, 'G Caveats " "'

for i=0,pp_nvar-1 do begin
    istat = execute('val = '+pp_varnames(i))
    printf, iff_unit, 'G Inst_settings "'+pp_varnames(i)+'>'+strtrim(val,2)+'"'
endfor

printf, iff_unit,'%I ------------------------------------------------'
printf, iff_unit,'%I END Controller Input'
printf, iff_unit,'%I ------------------------------------------------'
printf, iff_unit,'U 0 00:00:00.000 0 255 255 255 255 255 255 255 -1.000E+31 -1.000E+31 -1.000E+31 -1.000E+31 -1.000E+31 -1.000E+31 -1.000E+31'
printf, iff_unit,'S 4000.'

calsof = 'Calib_software "EDI_CAL '+pp_rcs_snapshot_name+'_'+finfo.date+'"'
calinp = 'Calib_input "EDI_CAL_INPUT '+pp_rcs_snapshot_name+'_'+finfo.date+'"'

printf, iff_unit,'V Epoch__C' + sc_id_str + '_PP_EDI '+ calsof
printf, iff_unit,'V Epoch__C' + sc_id_str + '_PP_EDI '+ calinp

printf, iff_unit,'V Status__C' + sc_id_str + '_PP_EDI '+ calsof
printf, iff_unit,'V Status__C' + sc_id_str + '_PP_EDI '+ calinp

printf, iff_unit,'V V_ed_xyz_gse__C' + sc_id_str + '_PP_EDI '+ calsof
printf, iff_unit,'V V_ed_xyz_gse__C' + sc_id_str + '_PP_EDI '+ calinp

printf, iff_unit,'V E_xyz_gse__C' + sc_id_str + '_PP_EDI '+ calsof
printf, iff_unit,'V E_xyz_gse__C' + sc_id_str + '_PP_EDI '+ calinp

printf, iff_unit,'V Reduced_chi_sq__C' + sc_id_str + '_PP_EDI '+ calsof
printf, iff_unit,'V Reduced_chi_sq__C' + sc_id_str + '_PP_EDI '+ calinp

printf, iff_unit,'%I ------------------------------------------------'


return
end
