pro edi_piso_write_iff_data, recnum, iff_unit, saveit, rectime_old_ssm, sbyte1=sbyte1, sbyte2=sbyte2, fill=fill, ediefw=ediefw, iff_hourly=iff_hourly, edidsi=edidsi, inertial_edidsi=inertial_edidsi

common ep_envar_con_cb
common iff_hourly_cb, iff_output

iffh = keyword_set(iff_hourly)
 
if keyword_set(fill) then begin

    if (n_elements(rectime_old_ssm) eq 0) then rectime_old_ssm = saveit
    if (abs(saveit - rectime_old_ssm) gt 10. and $
        not iffh) then printf, iff_unit, 'N' else $
      if (abs(saveit - rectime_old_ssm) gt 10. and $
          iffh) then iff_output=[iff_output,'N']

; Output a fill data record to the IFF file
    t_ssm = saveit
    hr =   long(t_ssm/3600.)
    mn =   long( (t_ssm/3600. - hr)*60. )
    sc =   long( ( (t_ssm/3600. - hr)*60. - mn)*60. )
    msec = long( ( ( (t_ssm/3600. - hr)*60. - mn)*60. - sc)*1e3 )
    t_mssm = long(hr*3600000.) + long(mn*60000.) + long(sc*1000.) + msec
    
    if (not iffh) then printf, iff_unit, format=$
      '("R ", i6.6," ",i2.2,":",i2.2,":",i2.2,".",i3.3," ",i8.8,7(i4.3),7(e11.3))', $
      recnum, hr, mn, sc, msec, t_mssm, pp_bfill, pp_bfill, pp_bfill, pp_bfill, $
      pp_bfill, pp_bfill, pp_bfill, pp_rfill, pp_rfill, pp_rfill, pp_rfill, pp_rfill, $
      pp_rfill, pp_rfill else $
      iff_output=[iff_output,string(recnum, hr, mn, sc, msec, t_mssm, pp_bfill, $
                                    pp_bfill, pp_bfill, pp_bfill, pp_bfill, pp_bfill, $
                                    pp_bfill, pp_rfill, pp_rfill, pp_rfill, pp_rfill, $
                                    pp_rfill, pp_rfill, pp_rfill,$
                                    format='("R ", i6.6," ",i2.2,":",i2.2,":",i2.2,".",i3.3," ",i8.8,7(i4.3),7(e11.3))')]
    
    return
end

if (keyword_set(ediefw)) then begin ; Only output E in SCS/Earthframe
    
; Which index should we use?
;OLD    if (saveit(0).status le 9 and saveit(1).status le 9) then begin
;OLD        iuse = 0                ; Both energies successful, use the 1keV result
;OLD    endif else if (saveit(0).status le 9 and saveit(1).status gt 9) then begin
;OLD        iuse = 0                ; 1keV result only
;OLD    endif else if (saveit(0).status gt 9 and saveit(1).status le 9) then begin
;OLD        iuse = 1                ; .5keV result only
;OLD    endif else begin
;OLD        iuse = 0                ; No results, doesn't matter
;OLD    endelse
    
; Which index should we use?
    i = where(saveit(*).win_status eq 1) ; saveit has length 4 now
    if (i(0) ne -1) then iuse = i(0) else $ ; Take the lowest index (1keV)
      iuse = 0                  ; No winners, no results, doesn't matter
    
    stat0 = saveit(iuse).sbyte0
    stat1 = sbyte1              ;saveit(0).sbyte_1or2
    stat2 = sbyte2              ;saveit(1).sbyte_1or2
    stat3 = saveit(iuse).sbyte3
    stat4 = saveit(iuse).sbyte4
    stat5 = saveit(iuse).sbyte5
    stat6 = saveit(iuse).sbyte6
    
; Output this data record to the EDI/EFW Comparison IFF file
    t_ssm = saveit(iuse).time_ssm
    hr =   long(t_ssm/3600.)
    mn =   long( (t_ssm/3600. - hr)*60. )
    sc =   long( ( (t_ssm/3600. - hr)*60. - mn)*60. )
    msec = long( ( ( (t_ssm/3600. - hr)*60. - mn)*60. - sc)*1e3 )
    t_mssm = long(hr*3600000.) + long(mn*60000.) + long(sc*1000.) + msec
    
    printf, iff_unit, format='("R ", i6.6," ",i2.2,":",i2.2,":",i2.2,".",i3.3," ",i8.8,7(i4.3),7(e11.3))', recnum, hr, mn, sc, msec, t_mssm, stat0, stat1, stat2, stat3, stat4, stat5, stat6, pp_rfill, pp_rfill, pp_rfill, saveit(iuse).e_out2(0), saveit(iuse).e_out2(1), saveit(iuse).e_out2(2), saveit(iuse).rchi2
    
    return
    
endif

if (keyword_set(edidsi)) then begin ; Only output E in DSI/Satelliteframe
    
; Which index should we use?
    i = where(saveit(*).win_status eq 1) ; saveit has length 4 now
    if (i(0) ne -1) then iuse = i(0) else $ ; Take the lowest index (1keV)
      iuse = 0                ; No winners, no results, doesn't matter
    
    stat0 = saveit(iuse).sbyte0
    stat1 = sbyte1              ;saveit(0).sbyte_1or2
    stat2 = sbyte2              ;saveit(1).sbyte_1or2
    stat3 = saveit(iuse).sbyte3
    stat4 = saveit(iuse).sbyte4
    stat5 = saveit(iuse).sbyte5
    stat6 = saveit(iuse).sbyte6
    
; Output this data record to the EDI/EFW Comparison IFF file
    t_ssm = saveit(iuse).time_ssm
    hr =   long(t_ssm/3600.)
    mn =   long( (t_ssm/3600. - hr)*60. )
    sc =   long( ( (t_ssm/3600. - hr)*60. - mn)*60. )
    msec = long( ( ( (t_ssm/3600. - hr)*60. - mn)*60. - sc)*1e3 )
    t_mssm = long(hr*3600000.) + long(mn*60000.) + long(sc*1000.) + msec
    
    printf, iff_unit, format='("R ", i6.6," ",i2.2,":",i2.2,":",i2.2,".",i3.3," ",i8.8,7(i4.3),7(e11.3))', recnum, hr, mn, sc, msec, t_mssm, stat0, stat1, stat2, stat3, stat4, stat5, stat6, pp_rfill, pp_rfill, pp_rfill, saveit(iuse).e_out3(0), saveit(iuse).e_out3(1), saveit(iuse).e_out3(2), saveit(iuse).rchi2
    
    return
    
endif

if (keyword_set(inertial_edidsi)) then begin ; Only output E in DSI/Inertialframe
    
; Which index should we use?
    i = where(saveit(*).win_status eq 1) ; saveit has length 4 now
    if (i(0) ne -1) then iuse = i(0) else $ ; Take the lowest index (1keV)
      iuse = 0                ; No winners, no results, doesn't matter
    
    stat0 = saveit(iuse).sbyte0
    stat1 = sbyte1              ;saveit(0).sbyte_1or2
    stat2 = sbyte2              ;saveit(1).sbyte_1or2
    stat3 = saveit(iuse).sbyte3
    stat4 = saveit(iuse).sbyte4
    stat5 = saveit(iuse).sbyte5
    stat6 = saveit(iuse).sbyte6
    
; Output this data record to the EDI/EFW Comparison IFF file
    t_ssm = saveit(iuse).time_ssm
    hr =   long(t_ssm/3600.)
    mn =   long( (t_ssm/3600. - hr)*60. )
    sc =   long( ( (t_ssm/3600. - hr)*60. - mn)*60. )
    msec = long( ( ( (t_ssm/3600. - hr)*60. - mn)*60. - sc)*1e3 )
    t_mssm = long(hr*3600000.) + long(mn*60000.) + long(sc*1000.) + msec
    
    printf, iff_unit, format='("R ", i6.6," ",i2.2,":",i2.2,":",i2.2,".",i3.3," ",i8.8,7(i4.3),7(e11.3))', recnum, hr, mn, sc, msec, t_mssm, stat0, stat1, stat2, stat3, stat4, stat5, stat6, pp_rfill, pp_rfill, pp_rfill, saveit(iuse).e_out4(0), saveit(iuse).e_out4(1), saveit(iuse).e_out4(2), saveit(iuse).rchi2
    
    return
    
endif

;==========================================================
;==========================================================
; Which index should we use?
;OLD if (saveit(0).status le 9 and saveit(1).status le 9) then begin
;OLD     iuse = 0                    ; Both energies successful, use the 1keV result
;OLD endif else if (saveit(0).status le 9 and saveit(1).status gt 9) then begin
;OLD     iuse = 0                    ; 1keV result only
;OLD endif else if (saveit(0).status gt 9 and saveit(1).status le 9) then begin
;OLD     iuse = 1                    ; .5keV result only
;OLD endif else begin
;OLD     iuse = 0                    ; No results, doesn't matter
;OLD endelse

; Which index should we use?
i = where(saveit(*).win_status eq 1) ; saveit has length 4 now
if (i(0) ne -1) then iuse = i(0) else $ ; Take the lowest index (1keV)
  iuse = 0                      ; No winners, no results, doesn't matter

if (saveit(iuse).status eq pp_bfill) then begin
    if (not iffh) then printf, iff_unit, $
      '%M edi_piso_write_iff_data: No analysis performed for this spin; insufficient data' $
    else $
      iff_output = [iff_output,'%M edi_piso_write_iff_data: No analysis performed for this spin; insufficient data']
endif

if (n_elements(rectime_old_ssm) eq 0) then $
  rectime_old_ssm = saveit(iuse).time_ssm

if (abs(saveit(iuse).time_ssm - rectime_old_ssm) gt 10.) then begin
    if (not iffh) then printf, iff_unit, 'N' else $
      iff_output=[iff_output,'N']
endif

stat0 = saveit(iuse).sbyte0
stat1 = sbyte1                  ;saveit(0).sbyte_1or2
stat2 = sbyte2                  ;saveit(1).sbyte_1or2
stat3 = saveit(iuse).sbyte3
stat4 = saveit(iuse).sbyte4
stat5 = saveit(iuse).sbyte5
stat6 = saveit(iuse).sbyte6

; Output this data record to the IFF file
t_ssm = saveit(iuse).time_ssm
hr =   long(t_ssm/3600.)
mn =   long( (t_ssm/3600. - hr)*60. )
sc =   long( ( (t_ssm/3600. - hr)*60. - mn)*60. )
msec = long( ( ( (t_ssm/3600. - hr)*60. - mn)*60. - sc)*1e3 )
t_mssm = long(hr*3600000.) + long(mn*60000.) + long(sc*1000.) + msec

if (not iffh) then printf, iff_unit, $
  format='("R ", i6.6," ",i2.2,":",i2.2,":",i2.2,".",i3.3," ",i8.8,7(i4.3),7(e11.3))', $
  recnum, hr, mn, sc, msec, t_mssm, stat0, stat1, stat2, stat3, stat4, stat5, stat6, $
  saveit(iuse).v_out(0), saveit(iuse).v_out(1), saveit(iuse).v_out(2), $
  saveit(iuse).e_out(0), saveit(iuse).e_out(1), saveit(iuse).e_out(2), saveit(iuse).rchi2 $
else $
  iff_output = [iff_output,string(recnum, hr, mn, sc, msec, t_mssm, stat0, stat1, $
                                  stat2, stat3, stat4, stat5, stat6, $
                                  saveit(iuse).v_out(0), saveit(iuse).v_out(1), $
                                  saveit(iuse).v_out(2), saveit(iuse).e_out(0), $
                                  saveit(iuse).e_out(1), saveit(iuse).e_out(2), $
                                  saveit(iuse).rchi2, format = $
                                  '("R ", i6.6," ",i2.2,":",i2.2,":",i2.2,".",i3.3," ",i8.8,7(i4.3),7(e11.3))')]

rectime_old_ssm = saveit(iuse).time_ssm

return
end
