pro edi_piso_onespin, atime_out, btime_out, $
                      data_out, nnn_out, mm_out, ct_out, mxch_out, $
                      gdotb_out, $
                      scs2gyro, gyro2scs, spin_status, $
                      atime_t70, $
                      spin_srt_t70_pck, spin_srt_t70_fgm, $
                      spin_srt_ssm_pck, spin_srt_ssm_fgm, $
                      unitout, unitout2, phase0_offset=phase0_offset, $
                      gdotb_error=gdotb_error
common ep_envar_con_cb
common edi_piso_onespin_common, spin_start_ssm, spin_width_sec, spin_srt_ssm, bx, by, bz, atime_ssm, btime1_ssm, btime2_ssm, t1, t1m2, VAX1, VAY1, VAX2, VAY2, I1, I2, SQ1, SQ2, NNN, mm, code_type, mxch1, mxch2

ndata = n_elements(atime_ssm)

vx1  = vax1 - 12800.            ; vax1 has already been X by 8.
vy1  = vay1 - 12800.
vv1  = sqrt(vx1*vx1+vy1*vy1)
vx2  = vax2 - 12800.
vy2  = vay2 - 12800.
vv2  = sqrt(vx2*vx2+vy2*vy2)
g1ph = !radeg * atan(vy1,vx1)
g2ph = !radeg * atan(vy2,vx2)
g1th = 79.0 * asin(vv1/13336.) 
g2th = 79.0 * asin(vv2/13336.)

tof_scale = 1.e3/59.6046	; convert (by dividing) tof in 59.6-ns to tof in mics (NOS)
tof1 = t1/tof_scale		; [mics]
tof2 = (t1 - t1m2)/tof_scale	; [mics]

v1xg1 = sin(g1th*!dtor) * cos(g1ph*!dtor) ; beam 1 firing direction in gun1 coord...g1
v1yg1 = sin(g1th*!dtor) * sin(g1ph*!dtor) ; x=spin axis, z=radial outward through gun1
v1zg1 = cos(g1th*!dtor)         ; y=z ^ x

v2xg1 = sin(g2th*!dtor) * cos(g2ph*!dtor) ; beam 2 firing direction in gun1 coord.!
v2yg1 =-sin(g2th*!dtor) * sin(g2ph*!dtor) ;
v2zg1 =-cos(g2th*!dtor)         ;

; HAV says that this below is a good first approximation to taking
; into account the correction to ddtime for Cluster.  There will be
; fine tuning changes in the future. PPQ 14.10.2000
; NOTE: 1 BCI = 1/256 sec = 3.90625E-3 sec
ddtime1 = atime_ssm(*) - spin_srt_ssm - i2(*)*3.90625D-3 ; Timing for GUN1/DET2
ddtime2 = atime_ssm(*) - spin_srt_ssm - i1(*)*3.90625D-3 ; Timing for GUN2/DET1

; USE THE BEAM TIME FROM THE PICK LIBRARY INSTEAD OF CORRECTING THE
; ATIMES YOURSELF!!!!
ddtime1 = btime2_ssm - spin_srt_ssm ; Timing for GUN1/DET2
ddtime2 = btime1_ssm - spin_srt_ssm ; Timing for GUN2/DET1

omega = 2.D0*!dpi / spin_width_sec ; Hz
phase1 = omega*(ddtime1(*))
phase2 = omega*(ddtime2(*))
cos_wt1 = cos(phase1(*) - pp_phase0)
sin_wt1 = sin(phase1(*) - pp_phase0)
cos_wt2 = cos(phase2(*) - pp_phase0)
sin_wt2 = sin(phase2(*) - pp_phase0)

;brett_comp2 deltat_fgm = atime_ssm - spin_srt_ssm_fgm - i1*3.90625D-3
;brett_comp2 deltat_pck = atime_ssm - spin_srt_ssm_pck - i1*3.90625D-3
;brett_comp2 for iout=0,n_elements(atime_t70)-1 do begin
;brett_comp2     printf, unitout2, spin_srt_t70_pck, spin_srt_t70_fgm, $
;brett_comp2       atime_t70(iout), deltat_fgm(iout), deltat_pck(iout), $
;brett_comp2       format='(3(f16.6,2x),2(f8.6,2x))'
;brett_comp2 endfor

; Gun positions in inertial frame (no spin-axis component!)
; Z_intertial is towards the sun!!!!
g1posy = -(pp_sc_base + 0.D0) * sin_wt1 ; Remeber: pp_sc_base = diameter of Cluster = radius of 'virtual' triangulation spacecraft (which is twice as big as Cluster)
g1posz =  (pp_sc_base + 0.D0) * cos_wt1

g2posy =  (pp_sc_base + 0.D0) * sin_wt2
g2posz = -(pp_sc_base + 0.D0) * cos_wt2

; switch to coordinate system with Z along spin axis:

g1posx =  g1posz
g1posy = -g1posy

g2posx =  g2posz
g2posy = -g2posy

g1posz = replicate(0.D0,ndata)
g2posz = replicate(0.D0,ndata)

; firing directions in inertial frame

g1y =  v1yg1 * cos_wt1 - v1zg1 * sin_wt1
g1z =  v1yg1 * sin_wt1 + v1zg1 * cos_wt1

g2y =  v2yg1 * cos_wt2 - v2zg1 * sin_wt2
g2z =  v2yg1 * sin_wt2 + v2zg1 * cos_wt2

; switch coordinate system:

g1y = -g1y
g1x =  g1z
g1z =  v1xg1

g2y = -g2y
g2x =  g2z
g2z =  v2xg1

;brett_comp ; Gun 1 firing directions in rotating payload: [v1xg1,v1yg1,v1zg1]
;brett_comp ; Gun 1 firing directions in SCS: [g1x,g1y,g1z]
;brett_comp natime = n_elements(atime_t70)
;brett_comp for iout=0,natime-1 do begin
;brett_comp     printf, unitout, atime_t70(iout),v1xg1(iout),v1yg1(iout),v1zg1(iout), $
;brett_comp       g1x(iout),g1y(iout),g1z(iout), $
;brett_comp       format='(f16.6,2x,6(f8.5,2x))'
;brett_comp endfor

; Now have B in SCS and the gun firing directions in SCS
; ([g1x,g1y,g1z] and [g2x,g2y,g2z]).  Take the dot products and return
; this information.
bmag = sqrt(bx^2+by^2+bz^2)
g1mag = sqrt(g1x^2+g1y^2+g1z^2)
g2mag = sqrt(g2x^2+g2y^2+g2z^2)
gdotb1 = acos((bx*g1x+by*g1y+bz*g1z)/bmag/g1mag)*180d0/!dpi ; Degrees
gdotb2 = acos((bx*g2x+by*g2y+bz*g2z)/bmag/g2mag)*180d0/!dpi ; Degrees

; Transformation to gyro-coordinates:

;========================================================================
; Pam's method test:
; This test was carried out and it was determined to give the exact
; same results as Hans' original method which calls
; GyroProjection_.pro and GyroComponents_.pro.  The method was changed
; because of the need to return the gyro2scs transformation matrix.
; This routine, edi_piso_onespin.pro only handles one spin, 
; so there is actually only one B...
; The bx, by and bz arrays contain redundant information (have same
; dimensions as the number of beams to conform with the former method
; of transformation)...Therefore, we only use the first element of
; each below to construct the scs2gyro transformation matrix.
xy_gyro_one = GyroUnitVector_([bx(0),by(0),bz(0)])
scs2gyro = dblarr(3,3)
scs2gyro(0,*) = xy_gyro_one(0:2)
scs2gyro(1,*) = xy_gyro_one(3:5)
scs2gyro(2,*) = [bx(0),by(0),bz(0)]/sqrt(bx(0)^2+by(0)^2+bz(0)^2)

; Return the gyro2scs matrix so that you can transform the drift steps
; back into the SCS system, and then ultimately transform to the GSE system.
gyro2scs = transpose(scs2gyro)  ; Inverse = Transpose
;test gyro2scs_2 = invert(scs2gyro,gstat,/double)
;test print, gyro2scs
;test print, gyro2scs_2
;test stop

; Gun1 position
gunx1 = scs2gyro(0,0)*g1posx + scs2gyro(0,1)*g1posy + $
  scs2gyro(0,2)*g1posz
guny1 = scs2gyro(1,0)*g1posx + scs2gyro(1,1)*g1posy + $
  scs2gyro(1,2)*g1posz
gunz1 = scs2gyro(2,0)*g1posx + scs2gyro(2,1)*g1posy + $
  scs2gyro(2,2)*g1posz

; Gun2 position
gunx2 = scs2gyro(0,0)*g2posx + scs2gyro(0,1)*g2posy + $
  scs2gyro(0,2)*g2posz
guny2 = scs2gyro(1,0)*g2posx + scs2gyro(1,1)*g2posy + $
  scs2gyro(1,2)*g2posz
gunz2 = scs2gyro(2,0)*g2posx + scs2gyro(2,1)*g2posy + $
  scs2gyro(2,2)*g2posz

; Gun1 firing direction/angle
gun1firx_gyro = scs2gyro(0,0)*g1x + scs2gyro(0,1)*g1y + $
  scs2gyro(0,2)*g1z
gun1firy_gyro = scs2gyro(1,0)*g1x + scs2gyro(1,1)*g1y + $
  scs2gyro(1,2)*g1z
gun1firz_gyro = scs2gyro(2,0)*g1x + scs2gyro(2,1)*g1y + $
  scs2gyro(2,2)*g1z
firaz1 = atan(gun1firy_gyro,gun1firx_gyro) * !radeg

; Gun2 firing direction
gun2firx_gyro = scs2gyro(0,0)*g2x + scs2gyro(0,1)*g2y + $
  scs2gyro(0,2)*g2z
gun2firy_gyro = scs2gyro(1,0)*g2x + scs2gyro(1,1)*g2y + $
  scs2gyro(1,2)*g2z
gun2firz_gyro = scs2gyro(2,0)*g2x + scs2gyro(2,1)*g2y + $
  scs2gyro(2,2)*g2z
firaz2 = atan(gun2firy_gyro,gun2firx_gyro) * !radeg

;test print, '=========PAM==========='
;test print, 'gunx1: ', gunx1
;test print, 'guny1: ', guny1
;test print, 'gunx2: ', gunx2
;test print, 'guny2: ', guny2
;test print, 'firaz1: ', firaz1
;test print, 'firaz2: ', firaz2
;test print, 'gyro2scs: ', gyro2scs

goto, trans_out

;========================================================================
hans_method:

bxyz = [bx,by,bz]
xy_gyro = GyroUnitVector_(bxyz)

; projection of gun positions into gyro-plane:
g1pos_gyro = GyroProjection_([g1posx,g1posy,g1posz],bxyz)
g2pos_gyro = GyroProjection_([g2posx,g2posy,g2posz],bxyz)

; components of the projected gun positions along x_gyro and y_gyro
; ( = output gunx1,guny1 and gunx2,guny2 in 'ediq_printo.lis') 

xy_gun1 = GyroComponents_(g1pos_gyro, xy_gyro)
xy_gun2 = GyroComponents_(g2pos_gyro, xy_gyro)

xy_g1=reform(xy_gun1,ndata,2)
xy_g2=reform(xy_gun2,ndata,2)

gunx1 = reform(xy_g1(*,0)) & guny1 = reform(xy_g1(*,1))
gunx2 = reform(xy_g2(*,0)) & guny2 = reform(xy_g2(*,1))

; the same with the firing directions:

g1xyz=[g1x,g1y,g1z]
g2xyz=[g2x,g2y,g2z]

g1_gyro = GyroProjection_(g1xyz,bxyz)
g2_gyro = GyroProjection_(g2xyz,bxyz)

; components of the projected gun firing directions along x_gyro and y_gyro

xy_gun1 = GyroComponents_(g1_gyro, xy_gyro)
xy_gun2 = GyroComponents_(g2_gyro, xy_gyro)

xygg1=reform(xy_gun1,ndata,2)
xygg2=reform(xy_gun2,ndata,2)

firaz1  = atan(xygg1(*,1),xygg1(*,0)) * !radeg
firaz2  = atan(xygg2(*,1),xygg2(*,0)) * !radeg

print, '=========HANS==========='
print, 'gunx1: ', gunx1
print, 'guny1: ', guny1
print, 'gunx2: ', gunx2
print, 'guny2: ', guny2
print, 'firaz1: ', firaz1
print, 'firaz2: ', firaz2

stop

trans_out:

; Output
data_out = fltarr(7,ndata*2)    ; Gun1 and Gun2 data concatonated on return
atime_out = dblarr(ndata*2)
btime_out = dblarr(ndata*2)
mxch_out = bytarr(ndata*2)
gdotb_out = fltarr(ndata*2)
nnn_keep = lonarr(ndata*2)
mm_keep = lonarr(ndata*2)
ct_keep = lonarr(ndata*2)
gd1 = where(sq2 ge pp_qual_min)      ; Gun1/Det2 remember...
istart = 0
nout = 0
if (gd1(0) ne -1) then begin
    ngd1 = n_elements(gd1)
    data_out(0,0:ngd1-1) = 1.0  ; Gun 1
    data_out(1,0:ngd1-1) = float(sq2(gd1)) ; Detector 2
    data_out(2,0:ngd1-1) = gunx1(gd1) ; Gun 1
    data_out(3,0:ngd1-1) = guny1(gd1) ; Gun 1
    data_out(4,0:ngd1-1) = firaz1(gd1) ; Gun 1
    data_out(5,0:ngd1-1) = tof2(gd1) ; Detector 2
    data_out(6,0:ngd1-1) = code_type(gd1)
    btime_out(0:ngd1-1) = btime2_ssm(gd1) ; Detector 2
    atime_out(0:ngd1-1) = atime_ssm(gd1)
    mxch_out(0:ngd1-1) = mxch2(gd1) ; Detector 2
    gdotb_out(0:ngd1-1) = gdotb1(gd1) ; Gun 1
    nnn_keep(0:ngd1-1) = nnn(gd1)
    mm_keep(0:ngd1-1) = mm(gd1)
    ct_keep(0:ngd1-1) = code_type(gd1)
    istart = ngd1
    nout = nout + ngd1
endif

gd2 = where(sq1 ge pp_qual_min) ; Gun2/Det1
if (gd2(0) ne -1) then begin
    ngd2 = n_elements(gd2)
    data_out(0,istart:istart+ngd2-1) = 2.0 ; Gun2
    data_out(1,istart:istart+ngd2-1) = float(sq1(gd2)) ; Detector 1
    data_out(2,istart:istart+ngd2-1) = gunx2(gd2) ; Gun2
    data_out(3,istart:istart+ngd2-1) = guny2(gd2) ; Gun2
    data_out(4,istart:istart+ngd2-1) = firaz2(gd2) ; Gun2
    data_out(5,istart:istart+ngd2-1) = tof1(gd2) ; Detector 1
    data_out(6,istart:istart+ngd2-1) = code_type(gd2)
    btime_out(istart:istart+ngd2-1) = btime1_ssm(gd2) ; Detector 1
    atime_out(istart:istart+ngd2-1) = atime_ssm(gd2)
    mxch_out(istart:istart+ngd2-1) = mxch1(gd2) ; Detector 1
    gdotb_out(istart:istart+ngd2-1) = gdotb2(gd2) ; Gun2
    nnn_keep(istart:istart+ngd2-1) = nnn(gd2)
    mm_keep(istart:istart+ngd2-1) = mm(gd2)
    ct_keep(istart:istart+ngd2-1) = code_type(gd2)
    nout = nout + ngd2
endif

if (nout ne 0) then begin
    
    data_out = data_out(0:6,0:nout-1)
    atime_out = atime_out(0:nout-1)
    btime_out = btime_out(0:nout-1)
    mxch_out = mxch_out(0:nout-1)
    gdotb_out = gdotb_out(0:nout-1)
    nnn_keep = nnn_keep(0:nout-1)
    mm_keep = mm_keep(0:nout-1)
    ct_keep = ct_keep(0:nout-1)

    
; Paschmann says this check on whether or not nnn or mm changes within
; this spin interval isn't necessary...Just take the nnn and mm
; values for the 1st beam...This goes for the code type too...
    
;decom ; nnn and mm check
;decom     if (min(nnn_keep) ne max(nnn_keep)) then message, $
;decom       'nnn changes during this spin interval...problem for bestarg.pro'
;decom     if (min(mm_keep) ne max(mm_keep)) then message, $
;decom       'mm changes during this spin interval...problem for bestarg.pro'
    
    nnn_out = nnn_keep(0)
    mm_out = mm_keep(0)
    ct_out = ct_keep(0)
    
    spin_status = 1

;==============================================================
;==============================================================
    if (n_elements(phase0_offset) eq 0) then goto, skip_gdotb_plot
; gdotb plot
    if !p.multi(0) eq 0 then begin
        xtitle = 'Seconds since Spin Start'
        ytitle = 'cos!u-1!n(ghat dot bhat)  [degrees]'
    endif else begin
        xtitle = ''
        ytitle = ''
    endelse
    edi_setcolors, cs
    yrange = [min([gdotb1,gdotb2]),max([gdotb1,gdotb2])]
    yrange = [80,100]
    plot, (atime_ssm-atime_ssm(0)), gdotb1, yrange=yrange, psym=3,title='pp_phase0 = '+strtrim(pp_phase0*180d0/!dpi,2), xtitle=xtitle, ytitle=ytitle
    oplot,(atime_ssm-atime_ssm(0)), gdotb2, psym=3, color=cs.red
    oplot, !x.crange, [90,90], line=3
    gdotb_error = total(abs(90-gdotb1)) + total(abs(90-gdotb2))
    skip_gdotb_plot:
;==============================================================
;==============================================================
    
endif else spin_status = 0


return
end

