;	edi_piso_onechunk.pro,v 1.13 2003/07/17 14:47:11 ppq Exp	
pro edi_piso_onechunk, atime_out, btime_out, bwidth_out, $
                       data_out, nnn_out, mm_out, ct_out, mxch_out, $
                       gdotb_out, runstat_out, $
                       scs2bpp, bpp2scs, chunk_status, $
                       atime_t70, $
                       spin_srt_t70_pck, spin_srt_t70_fgm, $
                       spin_srt_ssm_pck, spin_srt_ssm_fgm, $
                       unitout, unitout2, $
                       runstruc1_oc, runstruc2_oc, $
                       phase0_offset=phase0_offset, $
                       gdotb_error=gdotb_error, $
                       scs2gse=scs2gse, flip=flip, $
                       scs2bpp_refvec=scs2bpp_refvec

common ep_envar_con_cb
common edi_piso_onespin_common, spin_start_ssm, spin_width_sec, spin_srt_ssm

common edi_piso_onechunk_common, bx, by, bz, atime_ssm, btime1_ssm, btime2_ssm, t1, t1m2, VAX1, VAY1, VAX2, VAY2, I1, I2, SQ1, SQ2, NNN, mm, code_type, mxch1, mxch2

; NaN check======================
;s = ''
;read, s, prompt='NaN Hunt onechunk'
;print, n_elements(btime1_ssm)
;print, btime1_ssm(0)
;print, vax1
;print, vay1
;print, sq2
;print, '----------------'
;print, vax2
;print, vay2
;print, sq1
;i = where(vax1 eq 0 and vay1 eq 0)
;if (i(0) ne -1) then if (min(sq2(i)) eq 2) then stop
;i = where(vax2 eq 0 and vay2 eq 0)
;if (i(0) ne -1) then if (min(sq1(i)) eq 2) then stop
; NaN check======================

ndata = n_elements(atime_ssm)
omega = 2.D0*!dpi / spin_width_sec ; Hz

; USE THE BEAM TIME FROM THE PICK LIBRARY INSTEAD OF CORRECTING THE
; ATIMES YOURSELF!!!!
ddtime1 = btime2_ssm - spin_srt_ssm ; Timing for GUN1/DET2
ddtime2 = btime1_ssm - spin_srt_ssm ; Timing for GUN2/DET1

vx1  = vax1 - 12800.            ; vax1 has already been X by 8.
vy1  = vay1 - 12800.
vv1  = sqrt(vx1*vx1+vy1*vy1)
vx2  = vax2 - 12800.
vy2  = vay2 - 12800.
vv2  = sqrt(vx2*vx2+vy2*vy2)
g1ph = !radeg * atan(vy1,vx1)
g2ph = !radeg * atan(vy2,vx2)
g1th = 79.0 * asin(vv1/13336.) 
g2th = 79.0 * asin(vv2/13336.)

; Calculate the beam widths
ep_calc_beamwidth, g1ph, g1th, g2ph, g2th, omega, ddtime1, ddtime2, $
   bx, by, bz, $
   bwidth1, bwidth2

tof_scale = 1.e3/59.6046	; convert (by dividing) tof in 59.6-ns to tof in mics (NOS)
tof1 = t1/tof_scale		; [mics]
tof2 = (t1 - t1m2)/tof_scale	; [mics]

v1xg1 = sin(g1th*!dtor) * cos(g1ph*!dtor) ; beam 1 firing direction in gun1 coord...g1
v1yg1 = sin(g1th*!dtor) * sin(g1ph*!dtor) ; x=spin axis, z=radial outward through gun1
v1zg1 = cos(g1th*!dtor)         ; y=z ^ x

v2xg1 = sin(g2th*!dtor) * cos(g2ph*!dtor) ; beam 2 firing direction in gun1 coord.!
v2yg1 =-sin(g2th*!dtor) * sin(g2ph*!dtor) ;
v2zg1 =-cos(g2th*!dtor)         ;

phase1 = omega*(ddtime1(*))
phase2 = omega*(ddtime2(*))
cos_wt1 = cos(phase1(*) - pp_phase0)
sin_wt1 = sin(phase1(*) - pp_phase0)
cos_wt2 = cos(phase2(*) - pp_phase0)
sin_wt2 = sin(phase2(*) - pp_phase0)

; Gun positions in inertial frame (no spin-axis component!)
; Z_intertial is towards the sun!!!!
g1posy = -(pp_sc_base + 0.D0) * sin_wt1 ; Remeber: pp_sc_base = diameter of Cluster = radius of 'virtual' triangulation spacecraft (which is twice as big as Cluster)
g1posz =  (pp_sc_base + 0.D0) * cos_wt1

g2posy =  (pp_sc_base + 0.D0) * sin_wt2
g2posz = -(pp_sc_base + 0.D0) * cos_wt2

; switch to coordinate system with Z along spin axis:

g1posx =  g1posz
g1posy = -g1posy

g2posx =  g2posz
g2posy = -g2posy

g1posz = replicate(0.D0,ndata)
g2posz = replicate(0.D0,ndata)

; firing directions in inertial frame

g1y =  v1yg1 * cos_wt1 - v1zg1 * sin_wt1
g1z =  v1yg1 * sin_wt1 + v1zg1 * cos_wt1

g2y =  v2yg1 * cos_wt2 - v2zg1 * sin_wt2
g2z =  v2yg1 * sin_wt2 + v2zg1 * cos_wt2

; switch coordinate system:

g1y = -g1y
g1x =  g1z
g1z =  v1xg1

g2y = -g2y
g2x =  g2z
g2z =  v2xg1

;brett_comp ; Gun 1 firing directions in rotating payload: [v1xg1,v1yg1,v1zg1]
;brett_comp ; Gun 1 firing directions in SCS: [g1x,g1y,g1z]
;brett_comp natime = n_elements(atime_t70)
;brett_comp for iout=0,natime-1 do begin
;brett_comp     printf, unitout, atime_t70(iout),v1xg1(iout),v1yg1(iout),v1zg1(iout), $
;brett_comp       g1x(iout),g1y(iout),g1z(iout), $
;brett_comp       format='(f16.6,2x,6(f8.5,2x))'
;brett_comp endfor

; Now have B in SCS and the gun firing directions in SCS
; ([g1x,g1y,g1z] and [g2x,g2y,g2z]).  Take the dot products and return
; this information.
bmag = sqrt(bx^2+by^2+bz^2)
g1mag = sqrt(g1x^2+g1y^2+g1z^2)
g2mag = sqrt(g2x^2+g2y^2+g2z^2)
gdotb1 = acos((bx*g1x+by*g1y+bz*g1z)/bmag/g1mag)*180d0/!dpi ; Degrees
gdotb2 = acos((bx*g2x+by*g2y+bz*g2z)/bmag/g2mag)*180d0/!dpi ; Degrees

;========================================================================
; Transformation to BPP-coordinates: 'B'-'P'erp 'P'lane
;========================================================================

bhat_scs = [bx(0),by(0),bz(0)]/sqrt(bx(0)^2+by(0)^2+bz(0)^2)
ep_construct_scs2bpp, bhat_scs, scs2gse, $ ; IN
  flip, scs2bpp_refvec, scs2bpp, bpp2scs ; OUT

;===============================================================
;   SKIP -- SKIP -- SKIP -- SKIP -- SKIP -- SKIP -- SKIP
;===============================================================
goto, skip_old_scs2bpp
; Pam's method test:
; This test was carried out and it was determined to give the exact
; same results as Hans' original method which calls
; GyroProjection_.pro and GyroComponents_.pro.  The method was changed
; because of the need to return the bpp2scs transformation matrix.
; This routine, edi_piso_onechunk.pro only handles one chunk, 
; so there is actually only one B...
; The bx, by and bz arrays contain redundant information (have same
; dimensions as the number of beams to conform with the former method
; of transformation)...Therefore, we only use the first element of
; each below to construct the scs2bpp transformation matrix.
xy_bpp_one = GyroUnitVector_([bx(0),by(0),bz(0)])
scs2bpp = dblarr(3,3)
scs2bpp(0,*) = xy_bpp_one(0:2)
scs2bpp(1,*) = xy_bpp_one(3:5)
scs2bpp(2,*) = [bx(0),by(0),bz(0)]/sqrt(bx(0)^2+by(0)^2+bz(0)^2)

; At this point, scs2bpp is equal to the OLD scs2gyro.  We want the
; z-axis of the BPP system to have the same sense as the z-axis of
; the GSE system.  Therefore, we MIGHT have to do a flip and redefine
; scs2bpp:
flip = 0
zhatbpp_scs = reform(scs2bpp(2,*))
zhatbpp_gse = [total(scs2gse(0,*)*zhatbpp_scs,/double), $
               total(scs2gse(1,*)*zhatbpp_scs,/double), $
               total(scs2gse(2,*)*zhatbpp_scs,/double)]
scs2bpp_refvec = [0.,1.,0.]

if (zhatbpp_gse(2) lt 0.) then begin ; Must flip
    flip = 1
    z = -1.d0*zhatbpp_scs       ; Unit length, has same sense as z-GSE
    r = [0.,-1.,0.]             ; Reference vector that ensures that
                                ; x (below) has sunward sense
    scs2bpp_refvec = r
    
    x = [r(1)*z(2)-r(2)*z(1), $ ; r cross z
         r(2)*z(0)-r(0)*z(2), $
         r(0)*z(1)-r(1)*z(0)]
; Normalize this!!!! Error found by M. Chutter, 10.07.2001
    x = x/sqrt(total(x^2,/double)) ; Unit length
    
    y = [z(1)*x(2)-z(2)*x(1), $ ; z cross x
         z(2)*x(0)-z(0)*x(2), $
         z(0)*x(1)-z(1)*x(0)]
; Normalize this!!!! Error found by M. Chutter, 10.07.2001
    y = y/sqrt(total(y^2,/double)) ; Unit length
    
    scs2bpp(2,*) = z
    scs2bpp(0,*) = x
    scs2bpp(1,*) = y
    
endif

; Return the bpp2scs matrix so that you can transform the drift steps
; back into the SCS system, and then ultimately transform to the GSE system.
bpp2scs = transpose(scs2bpp)  ; Inverse = Transpose (orthogonal)
;test bpp2scs_2 = invert(scs2bpp,gstat,/double)
;test print, bpp2scs
;test print, bpp2scs_2
;test stop
skip_old_scs2bpp:
;===============================================================
;===============================================================

; Gun1 position
gunx1 = scs2bpp(0,0)*g1posx + scs2bpp(0,1)*g1posy + $
  scs2bpp(0,2)*g1posz
guny1 = scs2bpp(1,0)*g1posx + scs2bpp(1,1)*g1posy + $
  scs2bpp(1,2)*g1posz
gunz1 = scs2bpp(2,0)*g1posx + scs2bpp(2,1)*g1posy + $
  scs2bpp(2,2)*g1posz

; Gun2 position
gunx2 = scs2bpp(0,0)*g2posx + scs2bpp(0,1)*g2posy + $
  scs2bpp(0,2)*g2posz
guny2 = scs2bpp(1,0)*g2posx + scs2bpp(1,1)*g2posy + $
  scs2bpp(1,2)*g2posz
gunz2 = scs2bpp(2,0)*g2posx + scs2bpp(2,1)*g2posy + $
  scs2bpp(2,2)*g2posz

; Gun1 firing direction/angle
gun1firx_bpp = scs2bpp(0,0)*g1x + scs2bpp(0,1)*g1y + $
  scs2bpp(0,2)*g1z
gun1firy_bpp = scs2bpp(1,0)*g1x + scs2bpp(1,1)*g1y + $
  scs2bpp(1,2)*g1z
gun1firz_bpp = scs2bpp(2,0)*g1x + scs2bpp(2,1)*g1y + $
  scs2bpp(2,2)*g1z
firaz1 = atan(gun1firy_bpp,gun1firx_bpp) * !radeg

; Gun2 firing direction
gun2firx_bpp = scs2bpp(0,0)*g2x + scs2bpp(0,1)*g2y + $
  scs2bpp(0,2)*g2z
gun2firy_bpp = scs2bpp(1,0)*g2x + scs2bpp(1,1)*g2y + $
  scs2bpp(1,2)*g2z
gun2firz_bpp = scs2bpp(2,0)*g2x + scs2bpp(2,1)*g2y + $
  scs2bpp(2,2)*g2z
firaz2 = atan(gun2firy_bpp,gun2firx_bpp) * !radeg

;test print, '=========PAM==========='
;test print, 'gunx1: ', gunx1
;test print, 'guny1: ', guny1
;test print, 'gunx2: ', gunx2
;test print, 'guny2: ', guny2
;test print, 'firaz1: ', firaz1
;test print, 'firaz2: ', firaz2
;test print, 'bpp2scs: ', bpp2scs

goto, trans_out

;========================================================================
hans_method:

bxyz = [bx,by,bz]
xy_bpp = GyroUnitVector_(bxyz)

; projection of gun positions into bpp-plane:
g1pos_bpp = GyroProjection_([g1posx,g1posy,g1posz],bxyz)
g2pos_bpp = GyroProjection_([g2posx,g2posy,g2posz],bxyz)

; components of the projected gun positions along x_bpp and y_bpp
; ( = output gunx1,guny1 and gunx2,guny2 in 'ediq_printo.lis') 

xy_gun1 = GyroComponents_(g1pos_bpp, xy_bpp)
xy_gun2 = GyroComponents_(g2pos_bpp, xy_bpp)

xy_g1=reform(xy_gun1,ndata,2)
xy_g2=reform(xy_gun2,ndata,2)

gunx1 = reform(xy_g1(*,0)) & guny1 = reform(xy_g1(*,1))
gunx2 = reform(xy_g2(*,0)) & guny2 = reform(xy_g2(*,1))

; the same with the firing directions:

g1xyz=[g1x,g1y,g1z]
g2xyz=[g2x,g2y,g2z]

g1_bpp = GyroProjection_(g1xyz,bxyz)
g2_bpp = GyroProjection_(g2xyz,bxyz)

; components of the projected gun firing directions along x_bpp and y_bpp

xy_gun1 = GyroComponents_(g1_bpp, xy_bpp)
xy_gun2 = GyroComponents_(g2_bpp, xy_bpp)

xygg1=reform(xy_gun1,ndata,2)
xygg2=reform(xy_gun2,ndata,2)

firaz1  = atan(xygg1(*,1),xygg1(*,0)) * !radeg
firaz2  = atan(xygg2(*,1),xygg2(*,0)) * !radeg

print, '=========HANS==========='
print, 'gunx1: ', gunx1
print, 'guny1: ', guny1
print, 'gunx2: ', gunx2
print, 'guny2: ', guny2
print, 'firaz1: ', firaz1
print, 'firaz2: ', firaz2

stop

trans_out:

; Output
dimout = long(float(ndata)*2.)
data_out = fltarr(7,dimout)    ; Gun1 and Gun2 data concatonated on return
atime_out = dblarr(dimout)
btime_out = dblarr(dimout)
bwidth_out = fltarr(dimout)
mxch_out = bytarr(dimout)
gdotb_out = fltarr(dimout)
dimout2 = long(3.*float(pp_maxorder_runest) + 2.)
runstat_out = dblarr(dimout2,dimout)
; Here is the structure when pp_maxorder_runest = 6
; runstat_out(0,*)     = runorder(*)
; runstat_out(1:6,*)   = flag(0:5,*)
; runstat_out(7:12,*)  = estof(0:5,*)
; runstat_out(13,*)    = tg(*)
; runstat_out(14:19,*) = prob(0:5,*)

nnn_keep = lonarr(dimout)
mm_keep = lonarr(dimout)
ct_keep = lonarr(dimout)
gd1 = where((sq2 ge pp_qual_min) and $
            (mxch2 ge pp_maxchan_min) and $
            (mxch2 le pp_maxchan_max)) ; Gun1/Det2 remember...
istart = 0
nout = 0
if ((gd1(0) ne -1) and (pp_gunid le 1)) then begin
    ngd1 = n_elements(gd1)
    data_out(0,0:ngd1-1) = 1.0  ; Gun 1
    data_out(1,0:ngd1-1) = float(sq2(gd1)) ; Detector 2
    data_out(2,0:ngd1-1) = gunx1(gd1) ; Gun 1
    data_out(3,0:ngd1-1) = guny1(gd1) ; Gun 1
    data_out(4,0:ngd1-1) = firaz1(gd1) ; Gun 1
    data_out(5,0:ngd1-1) = tof2(gd1) ; Detector 2
    data_out(6,0:ngd1-1) = code_type(gd1)
    btime_out(0:ngd1-1) = btime2_ssm(gd1) ; Detector 2
    bwidth_out(0:ngd1-1) = bwidth1(gd1) ; Gun 1
    atime_out(0:ngd1-1) = atime_ssm(gd1)
    mxch_out(0:ngd1-1) = mxch2(gd1) ; Detector 2
    gdotb_out(0:ngd1-1) = gdotb1(gd1) ; Gun 1

    runstat_out(0,0:ngd1-1) = runstruc2_oc(gd1).runorder ; DET2
    runstat_out(1:pp_maxorder_runest,0:ngd1-1) = $
      runstruc2_oc(gd1).flag(0:pp_maxorder_runest-1) ; DET2
    runstat_out(pp_maxorder_runest+1:2*pp_maxorder_runest,0:ngd1-1) = $
      runstruc2_oc(gd1).estof(0:pp_maxorder_runest-1) ; DET2
    runstat_out(2*pp_maxorder_runest+1,0:ngd1-1) = $
      runstruc2_oc(gd1).tg
    runstat_out(2*pp_maxorder_runest+2:3*pp_maxorder_runest+1,0:ngd1-1) = $
      runstruc2_oc(gd1).prob(0:pp_maxorder_runest-1) ; DET2
    
    nnn_keep(0:ngd1-1) = nnn(gd1)
    mm_keep(0:ngd1-1) = mm(gd1)
    ct_keep(0:ngd1-1) = code_type(gd1)
    istart = ngd1
    nout = nout + ngd1
endif

gd2 = where((sq1 ge pp_qual_min) and $
            (mxch1 ge pp_maxchan_min) and $
            (mxch1 le pp_maxchan_max)) ; Gun2/Det1
if ((gd2(0) ne -1) and ((pp_gunid eq 0) or (pp_gunid eq 2))) then begin
    ngd2 = n_elements(gd2)
    data_out(0,istart:istart+ngd2-1) = 2.0 ; Gun2
    data_out(1,istart:istart+ngd2-1) = float(sq1(gd2)) ; Detector 1
    data_out(2,istart:istart+ngd2-1) = gunx2(gd2) ; Gun2
    data_out(3,istart:istart+ngd2-1) = guny2(gd2) ; Gun2
    data_out(4,istart:istart+ngd2-1) = firaz2(gd2) ; Gun2
    data_out(5,istart:istart+ngd2-1) = tof1(gd2) ; Detector 1
    data_out(6,istart:istart+ngd2-1) = code_type(gd2)
    btime_out(istart:istart+ngd2-1) = btime1_ssm(gd2) ; Detector 1
    bwidth_out(istart:istart+ngd2-1) = bwidth2(gd2) ; Gun2
    atime_out(istart:istart+ngd2-1) = atime_ssm(gd2)
    mxch_out(istart:istart+ngd2-1) = mxch1(gd2) ; Detector 1
    gdotb_out(istart:istart+ngd2-1) = gdotb2(gd2) ; Gun2

    runstat_out(0,istart:istart+ngd2-1) = runstruc1_oc(gd2).runorder ; DET1
    runstat_out(1:pp_maxorder_runest,istart:istart+ngd2-1) = $
      runstruc1_oc(gd2).flag(0:pp_maxorder_runest-1) ; DET1
    runstat_out(pp_maxorder_runest+1:2*pp_maxorder_runest, $
                istart:istart+ngd2-1) = $
      runstruc1_oc(gd2).estof(0:pp_maxorder_runest-1) ; DET1
    runstat_out(2*pp_maxorder_runest+1,istart:istart+ngd2-1) = $
      runstruc1_oc(gd2).tg
    runstat_out(2*pp_maxorder_runest+2:3*pp_maxorder_runest+1, $
                istart:istart+ngd2-1) = $
      runstruc1_oc(gd2).prob(0:pp_maxorder_runest-1) ; DET1
    
    nnn_keep(istart:istart+ngd2-1) = nnn(gd2)
    mm_keep(istart:istart+ngd2-1) = mm(gd2)
    ct_keep(istart:istart+ngd2-1) = code_type(gd2)
    nout = nout + ngd2
endif

if (nout ge pp_nbeam_min) then begin
    
    data_out = data_out(0:6,0:nout-1)
    atime_out = atime_out(0:nout-1)
    btime_out = btime_out(0:nout-1)
    bwidth_out = bwidth_out(0:nout-1)
    mxch_out = mxch_out(0:nout-1)
    gdotb_out = gdotb_out(0:nout-1)
    runstat_out = runstat_out(0:3*pp_maxorder_runest+1,0:nout-1)
    nnn_keep = nnn_keep(0:nout-1)
    mm_keep = mm_keep(0:nout-1)
    ct_keep = ct_keep(0:nout-1)
    
; Paschmann says this check on whether or not nnn or mm changes within
; this chunk interval isn't necessary...Just take the nnn and mm
; values for the 1st beam...This goes for the code type too...
    
;decom ; nnn and mm check
;decom     if (min(nnn_keep) ne max(nnn_keep)) then message, $
;decom       'nnn changes during this chunk interval...problem for bestarg.pro'
;decom     if (min(mm_keep) ne max(mm_keep)) then message, $
;decom       'mm changes during this chunk interval...problem for bestarg.pro'
    
    nnn_out = nnn_keep(0)
    mm_out = mm_keep(0)
    ct_out = ct_keep(0)
    
    chunk_status = 1

;==============================================================
;==============================================================
    if (n_elements(phase0_offset) eq 0) then goto, skip_gdotb_plot
; gdotb plot
    if !p.multi(0) eq 0 then begin
        xtitle = 'Seconds since Chunk Start'
        ytitle = 'cos!u-1!n(ghat dot bhat)  [degrees]'
    endif else begin
        xtitle = ''
        ytitle = ''
    endelse
    edi_setcolors, cs
    yrange = [min([gdotb1,gdotb2]),max([gdotb1,gdotb2])]
    yrange = [80,100]
    plot, (atime_ssm-atime_ssm(0)), gdotb1, yrange=yrange, psym=3,title='pp_phase0 = '+strtrim(pp_phase0*180d0/!dpi,2), xtitle=xtitle, ytitle=ytitle
    oplot,(atime_ssm-atime_ssm(0)), gdotb2, psym=3, color=cs.red
    oplot, !x.crange, [90,90], line=3
    gdotb_error = total(abs(90-gdotb1)) + total(abs(90-gdotb2))
    skip_gdotb_plot:
;==============================================================
;==============================================================
    
endif else chunk_status = 0


return
end


