function date2datevax, date, reverse=reverse

ms = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']

if (n_elements(date) gt 1) then message, 'Only a scalar operation'

if not keyword_set(reverse) then begin
    
; Construct the date in VAX format from 'YYYYMMDD' format
    imonth = fix(strmid(date,4,2))
    return, strmid(date,6,2)+'-'+ms(imonth-1)+'-'+strmid(date,0,4)
    
endif else begin
    
; Construct the date in 'YYYYMMDD' format from VAX format
    i = where(ms eq strmid(date,3,3))
    imonth = i(0) + 1
    return, strmid(date,7,4)+string(imonth,'(i2.2)')+strmid(date,0,2)
    
endelse
end
