pro comp_edi_dsigse

date = '20010714'
scnum = '1'
fname_dsi = '/home/ppq/edi/edi_piso/dev/aux_data/20010714_1_021000_devel_DM03_p59_1_edidsi.d'
fname_gse = '/home/ppq/edi/edi_piso/dev/aux_data/20010714_1_021000_devel_DM03_p59_1_aux.d'

date = '20030417'
scnum = '3'
fname_dsi = '/home/ppq/edi/edi_piso/dev/aux_data/20030417_3_111000_devel_DM03_p59_1_edidsi.d'
fname_gse = '/home/ppq/edi/edi_piso/dev/aux_data/20030417_3_111000_devel_DM03_p59_1_aux.d'

extract_aux_data, date, scnum, filename=fname_gse, $
  t_ssm=t_gse, efield_nocorr_gse=e_gse, stat=istat_gse

istat_dsi = read_edidsi_data(fname_dsi, t_dsi, e_dsi)

if (not istat_gse or not istat_dsi) then message, 'Data not found'

edi_setcolors, cs
!p.charsize = 2.0
!p.multi = [0,1,3]
!p.color = cs.black
!p.background = cs.white
window, 0, xs=1400, ys=1200
for i=0,2 do begin
    
    yrange = [min([min(e_gse(i,*)),min(e_dsi(i,*))]), $
              max([max(e_gse(i,*)),max(e_dsi(i,*))])]
    
    xrange = [min([t_gse,t_dsi]),max([t_gse,t_dsi])]
    
    plot, t_gse, e_gse(i,*), psym=1, symsize=.5, $
      xrange=xrange, yrange=yrange, /ystyle, /xstyle, $
      xtickformat='tick_hms_pam'
    
    oplot, t_dsi, e_dsi(i,*), psym=7, symsize=.5, color=cs.magenta

endfor

return
end
