PRO CALANGLE,  MJD,UT,SUB_STATUS

;C Calculate all 12 rotation angles need for the transformations
;C given time as MJD and UT hours. Output is via array ROT in COMMON 
;C block ANGLE. Values of ROT are in degrees.

       common angle, rot
           rot = dblarr(12)


;C Also pick up the position of the magnetic pole which should be
;C calculated by a previous call to GETMPL
       common mpole,  mcolat,mlong
       mcolat = dblarr(1)    &   mlong = dblarr(1)

;*
;* MAH mod 22/7/97 call CALC_DIPOLE to calculate position of magnetic
;* pole using IGRF coefficients. Exit if error detected.
       calc_dipole_2005,  mjd,sub_status
       if (sub_status ne 0) then return

;C        
;C Convert MJD into time in Julian centuries from Epoch 2000
; PPQ    01-Jan-2000 12:00:00 has mjd = 51544.5
; PPQ    There are 36525 days in one century

       t0 = (double(mjd) - 51544.5d0) / 36525.0d0

;C
;C Calculate first 3 angles: Greenwich Sideral Time, Solar Longitude
;C and the obliquity of the ecliptic
       rot(0) = gst(t0,ut)
       rot(1) = slong(t0,ut)
       rot(2) = obliq(t0)

;C Calculate the latitude and longitude of the dipole pole and
;C convert to rotation angles
       lat    = 90.d0 - mcolat*180.d0 / PI(0)
       long   = mlong*180.d0 / PI(0)
       rot(5) = lat - 90.d0
       rot(6) = long

;C Calculate the rotation angles from GSE to GSM (PSI) and GSM to
;C SM (MU= dipole tilt). Note this needs dipole latitude and
;C and longitude explicitly. It also implictly needs ROT(0) through (2)
;C via internal calls in subroutine GSMGSE. Thus we must calculate
;C these angles last.
       gsmgse,  psi,mu,lat,long
       rot(3) = -psi
       rot(4) = -mu


;C Calculate the ecliptic longitude of the ascending node of the solar
;C equator and the inclination of that equator to the ecliptic
       rot(7) = suneq(mjd)
       rot(8) = 7.25d0

;C Calculate the heliographic longitude (THETA) and latitude (PHI) of
;C the centre of the disc as seen from the Earth. This is also the
;C heliographic position of the Earth.
       sunearth,  theta,phi
       rot( 9) = theta
       rot(10) = phi


;C 180 degree rotation needed for XY inversion
       rot(11) = 180.d0

;       prtangle,dummy
;


END
