#include <stdio.h>
#include <string.h>

#include "swepam_level2_data_ion.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SWEPAM_ion *testdata;
  int ii,jj,retval;
  int32 numrec;

  if (argc!=2)
    {
      printf("Usage: swepam_l2_64sec_rd hdf_file\n");
      exit(1);
    }

  testdata=malloc(sizeof(struct SWEPAM_ion));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
	  fprintf(stderr, "SDstart: could not open hdf file\n");
	  exit(-1);
	}

  numrec=init_rd_swepam_level2_data_ion(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No swepam level2 64sec data\n");
    exit(-1);
  }

  ii=0;
  while((retval= read_swepam_level2_data_ion(testdata,ii))!=-1) {
          printf("%4d %10.6f ",
                 testdata->year,testdata->fp_doy);
          printf("% 11.4e % 11.4e % 11.4e % 11.4e % 11.4e % 11.4e\n", 
                 testdata->pos_gse_x, testdata->pos_gse_y, testdata->pos_gse_z,
                 testdata->pos_gsm_x, testdata->pos_gsm_y, testdata->pos_gsm_z);      
		 
	  ii++;
  }

  /* all done, close HDF file */

  close_rd_swepam_level2_data_ion();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}


