#include <stdio.h>
#include <string.h>

#include "swepam_level2_data_1hr.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SWEPAM_data_1hr *testdata;
  int ii,jj,retval;
  int32 numrec;

  if (argc!=2)
    {
      printf("Usage: swepam_l2_1hr_rd hdf_file\n");
      exit(1);
    }

  testdata=malloc(sizeof(struct SWEPAM_data_1hr));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
	  fprintf(stderr, "SDstart: could not open hdf file\n");
	  exit(-1);
	}

  numrec=init_rd_swepam_level2_data_1hr(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No swepam level2 1hr data\n");
    exit(-1);
  }

  ii=0;
  printf("BEGIN DATA\n");
  while((retval= read_swepam_level2_data_1hr(testdata,ii))!=-1) {
	  printf("%.8f %8.2f\n",
		 testdata->fp_year,testdata->proton_speed);
	  ii++;
  }

  /* all done, close HDF file */

  close_rd_swepam_level2_data_1hr();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}


