#include <stdio.h>
#include <string.h>
#include <time.h>


#include "sis_level2_data_1day.h"
#include "sis_level2_header.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SIS_data_1day *testdata;
  struct SIS_header *header;
  int ii,jj,retval;
  int32 numrec;
  time_t tloc;
  char timestr[80];
  

  if (argc!=3) {
      printf("Usage: sis_l2_1day_rd hdf_file one_of: He, C, N, O, Ne, Mg, Si, S, Fe, or all\n");
      exit(1);
  }

  if (
      (strcmp("He",argv[2])) &&
      (strcmp("C",argv[2])) &&
      (strcmp("N",argv[2])) &&
      (strcmp("O",argv[2])) &&
      (strcmp("Ne",argv[2])) &&
      (strcmp("Mg",argv[2])) &&
      (strcmp("Si",argv[2])) &&
      (strcmp("S",argv[2])) &&
      (strcmp("Fe",argv[2])) &&
      (strcmp("all",argv[2]))
     ) {
      printf("Usage: sis_l2_1day_rd hdf_file one_of: He, C, N, O, Ne, Mg, Si, S, Fe, or all\n");
      exit(1);
  }
     

  testdata=malloc(sizeof(struct SIS_data_1day));
  header=malloc(sizeof(struct SIS_header));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
  }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
  }

  numrec=init_rd_sis_level2_data_1day(hdf_fp, sd_id, "r");

  if( numrec<=0) {
      fprintf(stderr,"No sis level2 1day data\n");
      exit(-1);
  }

  time(&tloc);
  strftime(timestr,79,"%c",localtime(&tloc));
  if (!strcmp("all",argv[2])) {
    printf("SIS Daily Averaged Element Fluxes\n");
    printf("Data downloaded from ACE Science Center on %s\n",timestr);
    printf("SIS Team Software Version: %3.1f\n",header->software_version);
    printf("STOPSIS TEAM PROCESSING DATE :   %s\n",header->time_date_made);
    printf("ACE Science Center Level2 Software Version: 1.4\n");
    printf("ACE Science Center Processing Date/Time: %s\n",timestr);
    printf("\n");
    printf("\n");
    printf("Note: All timestamps are UT, and refer to the start of the time period.\n");
    printf("year,day,hr,min,sec: year, day of year, hour of day, minutes, seconds.\n");
    printf("fp_year  : fractional year.\n");
    printf("fp_doy   : fractional day-of-year.\n");
    printf("ACEepoch : seconds since %s\n",timestr);
    printf("flux_XX  : Element XX flux in eight energy ranges, particles/(cm2 Sr sec MeV/nucleon).\n");
    printf("cnt_XX   : Number of counts for Element XX, unitless. Eight values.\n");
    printf("Energy ranges are different for each element. See supporting documentation.\n");
    printf("Flux or count values of -999.9 indicates bad or missing data.\n");
    printf("\n");
    printf("More Documentation of the ACE SIS level 2 data is at this web site:\n");
    printf("http://www.srl.caltech.edu/ACE/ASC/level2/sis_l2desc.html\n");
    printf("\n");
    printf("year day hr min sec fp_year fp_doy ACEepoch flux_He(8 energies) flux_C(8 energies) flux_N(8 energies) flux_O(8 energies) flux_Ne(8 energies) flux_Mg(8 energies) flux_Si(8 energies) flux_S(8 energies) flux_Fe(8 energies) cnt_He(8 energies) cnt_C(8 energies) cnt_N(8 energies) cnt_O(8 energies) cnt_Ne(8 energies) cnt_Mg(8 energies) cnt_Si(8 energies) cnt_S(8 energies) cnt_Fe(8 energies) up_time_fraction solar_activity_flag \n");
  }
  else {
    printf("Daily %s Data extracted from HDF file on %s\n",argv[2],timestr);
    printf("HDF File: %s\n\n",argv[1]);
    printf("fpyear  day-of-year  8-fluxes 8-counts uptime_fraction solar_activity\n");
  }

  ii=0;
  while( (retval = read_sis_level2_data_1day(testdata,ii))!=-1 ) {
     if (!strcmp("all",argv[2])) {
       printf("%4d ",testdata->year);
       printf("%3d ",testdata->day);
       printf("%2d ",testdata->hr);
       printf("%2d ",testdata->min);
       printf("%6.3f ",testdata->sec);
       printf("%13.8f ",testdata->fp_year);
       printf("%10.6f ",testdata->fp_doy);
       printf("%13.3f ",testdata->ACEepoch);

       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_He[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_C[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_N[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_O[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Ne[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Mg[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Si[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_S[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Fe[jj]);

       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_He[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_C[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_N[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_O[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Ne[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Mg[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Si[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_S[jj]);
       for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Fe[jj]);

       printf("% 11.4e % 7d\n", testdata->up_time_fraction, 
	      testdata->solar_activity_flag);
     }
     else {
       printf("%13.8f %3d ",testdata->fp_year,testdata->day);
       if (!strcmp("He",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_He[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_He[jj]);
       }
       if (!strcmp("C",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_C[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_C[jj]);
       }
       if (!strcmp("N",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_N[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_N[jj]);
       }
       if (!strcmp("O",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_O[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_O[jj]);
       }
       if (!strcmp("Ne",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Ne[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Ne[jj]);
       }
       if (!strcmp("Mg",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Mg[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Mg[jj]);
       }
       if (!strcmp("Si",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Si[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Si[jj]);
       }
       if (!strcmp("S",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_S[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_S[jj]);
       }
       if (!strcmp("Fe",argv[2])) {
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Fe[jj]);
	 for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Fe[jj]);
       }
       printf("% 11.4e %d\n", testdata->up_time_fraction, 
	      testdata->solar_activity_flag);
     }
     ii++;
  }

  /* all done, close HDF file */

  close_rd_sis_level2_data_1day();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
  }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
  }
  exit(0);
}


