/* $Id:$ */

#include "hdfi.h"
#include "ss_qdist.h"

struct SS_qdist_2hr {

  /* UT time at the start of each record */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  float32 qdistC[nqC];			/* charge-state distribution for carbon */
  float32 qdistO[nqO];			/* charge-state distribution for oxygen */
  float32 qdistNe[nqNe];
  float32 qdistMg[nqMg];
  float32 qdistSi[nqSi];
  float32 qdistFe[nqFe];

  float32 qdistC_err[nqC];			/* charge-state distribution for carbon */
  float32 qdistO_err[nqO];			/* charge-state distribution for oxygen */
  float32 qdistNe_err[nqNe];
  float32 qdistMg_err[nqMg];
  float32 qdistSi_err[nqSi];
  float32 qdistFe_err[nqFe];

  int16 qf_qdistC[nqC];		/* charge-state distribution quality factors for carbon */
  int16 qf_qdistO[nqO];		/* charge-state distribution quality factors for oxygen */
  int16 qf_qdistNe[nqNe];
  int16 qf_qdistMg[nqMg];
  int16 qf_qdistSi[nqSi];
  int16 qf_qdistFe[nqFe];
  
};
