/* $Id: $ */

#include "hdfi.h"

struct MAGSWE_data_64sec {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  /* SWEPAM data */
  float32 Np;				/* proton_density */
  float32 Tp;				/* proton_temp */
  float32 Alpha_ratio;			/* He4toprotons */
  float32 Vp;				/* proton_speed (km/s)*/

  float32 V_rtn_r;             /* Proton Velocity: R coord. RTN */
  float32 V_rtn_t;             /* Proton Velocity: T coord. RTN */
  float32 V_rtn_n;             /* Proton Velocity: N coord. RTN */

  float32 V_gse_x;             /* Proton Velocity: x coord. GSE */
  float32 V_gse_y;             /* Proton Velocity: y coord. GSE */
  float32 V_gse_z;             /* Proton Velocity: z coord. GSE */

  float32 V_gsm_x;             /* Proton Velocity: x coord. GSM */
  float32 V_gsm_y;             /* Proton Velocity: y coord. GSM */
  float32 V_gsm_z;             /* Proton Velocity: z coord. GSM */
      
  /* mag average data */
  float32 B_rtn_r;	       /* gamma */
  float32 B_rtn_t;
  float32 B_rtn_n;

  float32 B_gse_x;             /* Magnetic vector: x coord. GSE */
  float32 B_gse_y;             /* Magnetic vector: y coord. GSE */
  float32 B_gse_z;             /* Magnetic vector: z coord. GSE */

  float32 B_gsm_x;             /* Magnetic vector: x coord. GSM */
  float32 B_gsm_y;             /* Magnetic vector: y coord. GSM */
  float32 B_gsm_z;             /* Magnetic vector: z coord. GSM */

  float32 Bmag;
  float32 Lambda;
  float32 Delta;

  float32 dBrms;

  /* Spacecraft Position in GSE coordinates */
  float32 pos_gse_x;
  float32 pos_gse_y;
  float32 pos_gse_z;

  /* Spacecraft Position in GSM coordinates */
  float32 pos_gsm_x;
  float32 pos_gsm_y;
  float32 pos_gsm_z;

  /* Spacecraft Position in HS coordinates */
  float32 pos_hs_x;
  float32 pos_hs_y;
  float32 pos_hs_z;

  /* number of hi-res MAG measurements included in the average */
  int32   MAG_pts;

};
