/* $Id: epam_level2_data_5min.h,v 1.2 2002/06/11 17:57:45 asc Exp $ */


#include "hdfi.h"

struct EPAM_data_12sec {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  /* LEMS30 ,Sector Avg,1/(cm**2-s-sr-MeV) */
  float32 P1;            /* 0.047-0.065 MeV Ions */
  float32 P2;            /* 0.065-0.112 MeV Ions */
  float32 P3;            /* 0.112-0.187 MeV Ions */
  float32 P4;            /* 0.187-0.310 MeV Ions */
  float32 P5;            /* 0.310-0.580 MeV Ions */
  float32 P6;            /* 0.580-1.06 MeV Ions  */
  float32 P7;            /* 1.06-1.91 MeV Ions   */
  float32 P8;            /* 1.91-4.75 MeV Ions   */

  /* LEMS30 uncertainties */
  float32 unc_P1; 
  float32 unc_P2; 
  float32 unc_P3; 
  float32 unc_P4; 
  float32 unc_P5; 
  float32 unc_P6; 
  float32 unc_P7; 
  float32 unc_P8; 

  /* DE, Sector Avg,1/(cm**2-s-sr-MeV) */
  float32 DE1;           /* 0.038-0.053 MeV Electrons */
  float32 DE2;           /* 0.053-0.103 MeV Electrons */
  float32 DE3;           /* 0.103-0.175 MeV Electrons */
  float32 DE4;           /* 0.175-0.315 MeV Electrons */

  /* DE uncertainties */
  float32 unc_DE1; 
  float32 unc_DE2; 
  float32 unc_DE3; 
  float32 unc_DE4; 

  /* CA60 Sector Avg,1/(cm**2-s-sr-MeV/nuc) */
  float32 W3;            /* 0.389-1.28 MeV/nuc He */
  float32 W4;            /* 1.28-6.98 MeV/nuc He */
  float32 W5;            /* 0.465-1.71 MeV/nuc CNO */
  float32 W6;            /* 1.71-19.1 MeV/nuc CNO */
  float32 W7;            /* 0.239-0.840 MeV/nuc Fe (9 < Z < 29 */
  float32 W8;            /* 0.840-92.7 MeV/nuc Fe (9 < Z < 29)*/

  /* CA60 uncertainties */
  float32 unc_W3; 
  float32 unc_W4; 
  float32 unc_W5; 
  float32 unc_W6; 
  float32 unc_W7; 
  float32 unc_W8;

  /* LEFS60 Sector Avg,1/(cm**2-s-sr-MeV) */
  float32 E1p;           /* 0.045-0.062 MeV Electrons (+Ions) */
  float32 E2p;           /* 0.062-0.103 MeV Electrons (+Ions) */
  float32 E3p;           /* 0.103-0.175 MeV Electrons (+Ions) */
  float32 E4p;           /* 0.175-0.312 MeV Electrons (+Ions) */
  float32 FP5p;          /* 0.546-0.761 MeV Ions */
  float32 FP6p;          /* 0.761-1.22 MeV Ions */
  float32 FP7p;          /* 1.22-4.97 MeV Ions */

  /* LEFS60 uncertainties */
  float32 unc_E1p;
  float32 unc_E2p; 
  float32 unc_E3p; 
  float32 unc_E4p; 
  float32 unc_FP5p; 
  float32 unc_FP6p; 
  float32 unc_FP7p; 

  /* WARTD Sector Avg,1/(cm**2-s-sr) */
  float32 Z2;            /* Z>1-E>0.7 MeV Ions */
  float32 Z2A;           /* Z>7-E>7.5 MeV Ions */
  float32 Z3;            /* Z>5-E>2.5 MeV Ions */
  float32 Z4;            /* Z>10-E>9.0 MeV Ions */

  /* WARTD uncertainties */
  float32 unc_Z2; 
  float32 unc_Z2A; 
  float32 unc_Z3; 
  float32 unc_Z4; 

  /* LEMS120 Sector Avg,1/(cm**2-s-sr-MeV) */
  float32 P1p;           /* 0.047-0.066 MeV Ions */
  float32 P2p;           /* 0.066-0.114 MeV Ions */
  float32 P3p;           /* 0.114-0.190 MeV Ions */
  float32 P4p;           /* 0.190-0.310 MeV Ions */
  float32 P5p;           /* 0.310-0.580 MeV Ions */
  float32 P6p;           /* 0.580-1.05 MeV Ions */
  float32 P7p;           /* 1.05-1.89 MeV Ions */
  float32 P8p;           /* 1.89-4.75 MeV Ions */

  /* LEMS120 uncertainties */
  float32 unc_P1p; 
  float32 unc_P2p; 
  float32 unc_P3p; 
  float32 unc_P4p; 
  float32 unc_P5p; 
  float32 unc_P6p; 
  float32 unc_P7p; 
  float32 unc_P8p; 

  /* LEFS150 Sector Avg,1/(cm**2-s-sr-MeV) */
  float32 E1;            /* 0.045-0.062 MeV Electrons (+Ions) */
  float32 E2;            /* 0.062-0.102 MeV Electrons (+Ions) */
  float32 E3;            /* 0.102-0.175 MeV Electrons (+Ions) */
  float32 E4;            /* 0.175-0.312 MeV Electrons (+Ions) */
  float32 FP5;           /* 0.540-0.765 MeV Ions */
  float32 FP6;           /* 0.765-1.22 MeV Ions */
  float32 FP7;           /* 1.22-4.94 MeV Ions */

  /* LEFS150 uncertainties */
  float32 unc_E1;
  float32 unc_E2; 
  float32 unc_E3; 
  float32 unc_E4; 
  float32 unc_FP5; 
  float32 unc_FP6; 
  float32 unc_FP7; 

  float32 livetime;

};

