#include <stdio.h>
#include <string.h>
#include <time.h>


#include "cris_level2_factors_energy_levels.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SDid;
  struct CRIS_factors_energy_levels *datax;
  int ii,jj,retval,d,i;
  int32 numrec;
  time_t tloc;
  char timestr[80];

  uint8   z_number[NUMBER_OF_ELEMENTS_TOTAL];  
  float32 energy_min[NUMBER_OF_ELEMENTS_TOTAL][NUMBER_OF_ENERGY_LEVELS];
  float32 energy_max[NUMBER_OF_ELEMENTS_TOTAL][NUMBER_OF_ENERGY_LEVELS];
  float32 geo_factor[NUMBER_OF_ELEMENTS_TOTAL][NUMBER_OF_ENERGY_LEVELS];
  float32 spallation[NUMBER_OF_ELEMENTS_TOTAL][NUMBER_OF_ENERGY_LEVELS];
  float32 SOFT[NUMBER_OF_ELEMENTS_TOTAL][NUMBER_OF_ENERGY_LEVELS];
 
  int32   init_rd_cris_level2_factors_energy_levels();
  int32   read_cris_level2_factors_energy_levels();
  void    close_rd_cris_level2_factors_energy_levels();

  if (argc!=2) {
      printf("Usage: cris_l2_factors_rd hdf_file\n");
      exit(1);
  }

  if((datax=malloc(sizeof(struct CRIS_factors_energy_levels)))==NULL) {
    fprintf(stderr,"Allocation error for CRIS_factors_energy_levels - exit");
    exit(-1);
  }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
  }
  Vstart(hdf_fp);

  if ((SDid=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
  }


/*********************************************************************/

  /* read and write the factors_energy_levels data */
  if((d=init_rd_cris_level2_factors_energy_levels(hdf_fp,SDid,"r"))<=0) {
    fprintf(stderr,"\nNo cris factors_energy_levels; Error# = %d\n",d);
    exit(-1);
  }
  for(ii=0;ii<NUMBER_OF_ELEMENTS_TOTAL;ii++) {
    if(read_cris_level2_factors_energy_levels(datax,ii) == FAIL) {
      fprintf(stderr,"\nError reading cris factors_energy_level ");
      exit(-1);
    }
    z_number[ii]=datax->z_number;
    for(i=0;i<NUMBER_OF_ENERGY_LEVELS;i++) {
      energy_min[ii][i]=datax->energy_min[i];
      energy_max[ii][i]=datax->energy_max[i];
      geo_factor[ii][i]=datax->geo_factor[i];
      spallation[ii][i]=datax->spallation[i];
      SOFT[ii][i]=datax->SOFT[i];
      printf("%2d %2d %7.3f %7.3f %7.3f %7.3f %7.3f\n",z_number[ii], i,
	     energy_min[ii][i], energy_max[ii][i], geo_factor[ii][i],
	     spallation[ii][i], SOFT[ii][i]);
    }
  }
  close_rd_cris_level2_factors_energy_levels();


  /* all done, close HDF file */
  Vend(hdf_fp);
  if (SDend(SDid)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
  }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
  }
  exit(0);
}


