#include <stdio.h>
#include <string.h>

#include "swics_swims_level2_data_1hr.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
     int argc;
     char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SWICS_data_1hr *testdata;
  int ii,jj,retval;
  int32 numrec;
  int	read_1st_line;

  if (argc!=2) {
    printf("Usage: swics_l2_1hr_rd hdf_file (optional: read_1st_line equals 1 means only read first line of file)\n");
    exit(1);
  }

  read_1st_line = (int)argv[2]; /* =1 means to read only first line of file */


  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
    fprintf(stderr, "Hopen: could not open hdf file\n");
    exit(-1);
  }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
    fprintf(stderr, "SDstart: could not open hdf file\n");
    exit(-1);
  }

  numrec=init_rd_swics_swims_level2_data_1hr(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No swics level2 1hr data\n");
    exit(-1);
  }

  ii=0;
  while((retval= read_swics_swims_level2_data_1hr(testdata,ii))!=-1) {

    printf("%4d %11.6f %3d %2d %2d %5.2f ",
	   testdata->year,
	   testdata->fp_year,
	   testdata->day,
	   testdata->hr,
	   testdata->min,
	   testdata->sec);
    printf("% 8.2f  %8.2f\n", 
	   testdata->vHe, testdata->vthHe);

    if (read_1st_line) break;
    ii++;
  }

  /* all done, close HDF file */

  close_rd_swics_swims_level2_data_1hr();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
    fprintf(stderr, "SDend: could not close hdf file\n");
    exit(-1);
  }
  if (Hclose(hdf_fp)==FAIL) {
    fprintf(stderr, "Hclose: could not close hdf file\n");
    exit(-1);
  }

  exit(0);
}


