/* $Id: sis_level2_data_256s.h,v 1.2 2003/03/24 18:05:34 asc Exp asc $ */

#include "hdfi.h"
#include "sis_sizes.h"

struct SIS_data_256s {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  /* Element fluxes, 1/(cm**2-s-sr-MeV/nuc */
  /* See ~asc/level2//hdf/sis/sis_energy_bands.txt for energy band info */
  float32  flux_He[NUMBER_OF_ENERGY_BANDS];
  float32  flux_C[NUMBER_OF_ENERGY_BANDS];
  float32  flux_N[NUMBER_OF_ENERGY_BANDS];
  float32  flux_O[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Ne[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Na[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Mg[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Al[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Si[NUMBER_OF_ENERGY_BANDS];
  float32  flux_S[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Ar[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Ca[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Fe[NUMBER_OF_ENERGY_BANDS];
  float32  flux_Ni[NUMBER_OF_ENERGY_BANDS];

  float32  cnt_He[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_C[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_N[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_O[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Ne[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Na[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Mg[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Al[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Si[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_S[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Ar[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Ca[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Fe[NUMBER_OF_ENERGY_BANDS];
  float32  cnt_Ni[NUMBER_OF_ENERGY_BANDS];

  float32 up_time_fraction;
  int32   solar_activity_flag;  /* = 0 less than threshold    */
                                /* = 1 greater than threshold */

};






















