/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

/* The include file used to create this file is: */
/* $Id: uleis_level2_data_1hr.h,v 1.3 2008/09/11 22:41:48 asc Exp  */

#include "uleis_level2_data_1hr.h"
#include "df.h"

int32 vgrp_id_uleis_level2_data_1hr;
static int32 vdata_id_uleis_level2_data_1hr;

  /* 3225 is the size of uleis_level2_data_1hr.h + 1 added line */
char Vgrp_descrp_ULEIS_data_1hr[3225];

/****----  init create function  ----****/

int32 init_cr_uleis_level2_data_1hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_uleis_level2_data_1hr();

  void print_uleis_level2_data_1hr_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_uleis_level2_data_1hr = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_uleis_level2_data_1hr, "VG_ULEIS_data_1hr"); 
  Vsetclass(vgrp_id_uleis_level2_data_1hr, "VG_ULEIS_LEVEL2_DATA_1HR");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_ULEIS_data_1hr" )) ==FAIL) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_uleis_level2_data_1hr(Vgrp_descrp_ULEIS_data_1hr);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_ULEIS_data_1hr, sizeof(Vgrp_descrp_ULEIS_data_1hr))) ==FAIL) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_uleis_level2_data_1hr = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_uleis_level2_data_1hr, "ULEIS_data_1hr");
  VSsetclass(vdata_id_uleis_level2_data_1hr, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_uleis_level2_data_1hr, vdata_id_uleis_level2_data_1hr)) ==FAIL) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "year", DFNT_INT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "day", DFNT_INT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "hr", DFNT_INT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "min", DFNT_INT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "sec", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "fp_year", DFNT_FLOAT64, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "H_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define H_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "H_S2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define H_S2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "H_S3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define H_S3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "H_S4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define H_S4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "H_S5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define H_S5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_H_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_H_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_H_S2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_H_S2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_H_S3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_H_S3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_H_S4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_H_S4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_H_S5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_H_S5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He3_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He3_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He3_S2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He3_S2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He3_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He3_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He3_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He3_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He3_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He3_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He3_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He3_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He3_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He3_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He3_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He3_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He3_S2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He3_S2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He3_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He3_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He3_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He3_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He3_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He3_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He3_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He3_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He3_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He3_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_S2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_S2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_S3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_S3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L8", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L9", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L9");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L10", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L10");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L11", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L11");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "He4_L12", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define He4_L12");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_S2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_S2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_S3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_S3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L8", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L9", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L9");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L10", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L10");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L11", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L11");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_He4_L12", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_He4_L12");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "C_L8", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define C_L8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_C_L8", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_C_L8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "O_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define O_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_S1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_S1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_O_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_O_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Ne_S_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Ne_S_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Ne_S_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Ne_S_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Ne_S_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Ne_S_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Ne_S_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Ne_S_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Ne_S_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Ne_S_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Ne_S_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Ne_S_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Ne_S_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Ne_S_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Ne_S_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne_S_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Ne_S_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne_S_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Ne_S_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne_S_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Ne_S_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne_S_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Ne_S_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne_S_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Ne_S_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne_S_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Ne_S_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne_S_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L8", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "Fe_L9", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define Fe_L9");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L1", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L2", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L3", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L4", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L5", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L6", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L7", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L8", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_uleis_level2_data_1hr, "unc_Fe_L9", DFNT_FLOAT32, (1) )) {
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe_L9");
    retval = -1;
  }

  if (VSsetfields(vdata_id_uleis_level2_data_1hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, H_S1, H_S2, H_S3, H_S4, H_S5, unc_H_S1, unc_H_S2, unc_H_S3, unc_H_S4, unc_H_S5, He3_S1, He3_S2, He3_L2, He3_L3, He3_L4, He3_L5, He3_L6, unc_He3_S1, unc_He3_S2, unc_He3_L2, unc_He3_L3, unc_He3_L4, unc_He3_L5, unc_He3_L6, He4_S1, He4_S2, He4_S3, He4_L1, He4_L2, He4_L3, He4_L4, He4_L5, He4_L6, He4_L7, He4_L8, He4_L9, He4_L10, He4_L11, He4_L12, unc_He4_S1, unc_He4_S2, unc_He4_S3, unc_He4_L1, unc_He4_L2, unc_He4_L3, unc_He4_L4, unc_He4_L5, unc_He4_L6, unc_He4_L7, unc_He4_L8, unc_He4_L9, unc_He4_L10, unc_He4_L11, unc_He4_L12, C_S1, C_L1, C_L2, C_L3, C_L4, C_L5, C_L6, C_L7, C_L8, unc_C_S1, unc_C_L1, unc_C_L2, unc_C_L3, unc_C_L4, unc_C_L5, unc_C_L6, unc_C_L7, unc_C_L8, O_S1, O_L1, O_L2, O_L3, O_L4, O_L5, O_L6, O_L7, unc_O_S1, unc_O_L1, unc_O_L2, unc_O_L3, unc_O_L4, unc_O_L5, unc_O_L6, unc_O_L7, Ne_S_L1, Ne_S_L2, Ne_S_L3, Ne_S_L4, Ne_S_L5, Ne_S_L6, Ne_S_L7, unc_Ne_S_L1, unc_Ne_S_L2, unc_Ne_S_L3, unc_Ne_S_L4, unc_Ne_S_L5, unc_Ne_S_L6, unc_Ne_S_L7, Fe_L1, Fe_L2, Fe_L3, Fe_L4, Fe_L5, Fe_L6, Fe_L7, Fe_L8, Fe_L9, unc_Fe_L1, unc_Fe_L2, unc_Fe_L3, unc_Fe_L4, unc_Fe_L5, unc_Fe_L6, unc_Fe_L7, unc_Fe_L8, unc_Fe_L9")){
    print_uleis_level2_data_1hr_error("init_cr_uleis_level2_data_1hr -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_uleis_level2_data_1hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_uleis_level2_data_1hr(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_uleis_level2_data_1hr(struct ULEIS_data_1hr ULEIS_data_1hr_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_uleis_level2_data_1hr_error();
void pack_uleis_level2_data_1hr();

  odata = (uint8 *) malloc(sizeof(struct ULEIS_data_1hr));
  pack_uleis_level2_data_1hr(odata, &ULEIS_data_1hr_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_uleis_level2_data_1hr, recnum)==-1) {
		print_uleis_level2_data_1hr_error("write_uleis_level2_data_1hr -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_uleis_level2_data_1hr, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_uleis_level2_data_1hr_error("write_uleis_level2_data_1hr -> VSwrite: Couldn't write data.");

  memset(&ULEIS_data_1hr_struc, 0, sizeof(struct ULEIS_data_1hr));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_uleis_level2_data_1hr()
{
  VSdetach(vdata_id_uleis_level2_data_1hr);
  Vdetach(vgrp_id_uleis_level2_data_1hr);
}

/*----     init access function    ----*/

int32 init_acc_uleis_level2_data_1hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_uleis_level2_data_1hr_error();


  if ((vdata_ref = VSfind(hdf_fp, "ULEIS_data_1hr")) <= 0 ) {
    print_uleis_level2_data_1hr_error("init_acc_uleis_level2_data_1hr -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_uleis_level2_data_1hr = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_uleis_level2_data_1hr_error("init_acc_uleis_level2_data_1hr -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_uleis_level2_data_1hr, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_uleis_level2_data_1hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, H_S1, H_S2, H_S3, H_S4, H_S5, unc_H_S1, unc_H_S2, unc_H_S3, unc_H_S4, unc_H_S5, He3_S1, He3_S2, He3_L2, He3_L3, He3_L4, He3_L5, He3_L6, unc_He3_S1, unc_He3_S2, unc_He3_L2, unc_He3_L3, unc_He3_L4, unc_He3_L5, unc_He3_L6, He4_S1, He4_S2, He4_S3, He4_L1, He4_L2, He4_L3, He4_L4, He4_L5, He4_L6, He4_L7, He4_L8, He4_L9, He4_L10, He4_L11, He4_L12, unc_He4_S1, unc_He4_S2, unc_He4_S3, unc_He4_L1, unc_He4_L2, unc_He4_L3, unc_He4_L4, unc_He4_L5, unc_He4_L6, unc_He4_L7, unc_He4_L8, unc_He4_L9, unc_He4_L10, unc_He4_L11, unc_He4_L12, C_S1, C_L1, C_L2, C_L3, C_L4, C_L5, C_L6, C_L7, C_L8, unc_C_S1, unc_C_L1, unc_C_L2, unc_C_L3, unc_C_L4, unc_C_L5, unc_C_L6, unc_C_L7, unc_C_L8, O_S1, O_L1, O_L2, O_L3, O_L4, O_L5, O_L6, O_L7, unc_O_S1, unc_O_L1, unc_O_L2, unc_O_L3, unc_O_L4, unc_O_L5, unc_O_L6, unc_O_L7, Ne_S_L1, Ne_S_L2, Ne_S_L3, Ne_S_L4, Ne_S_L5, Ne_S_L6, Ne_S_L7, unc_Ne_S_L1, unc_Ne_S_L2, unc_Ne_S_L3, unc_Ne_S_L4, unc_Ne_S_L5, unc_Ne_S_L6, unc_Ne_S_L7, Fe_L1, Fe_L2, Fe_L3, Fe_L4, Fe_L5, Fe_L6, Fe_L7, Fe_L8, Fe_L9, unc_Fe_L1, unc_Fe_L2, unc_Fe_L3, unc_Fe_L4, unc_Fe_L5, unc_Fe_L6, unc_Fe_L7, unc_Fe_L8, unc_Fe_L9")) {
      print_uleis_level2_data_1hr_error("init_acc_uleis_level2_data_1hr -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_uleis_level2_data_1hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_uleis_level2_data_1hr(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_uleis_level2_data_1hr(struct ULEIS_data_1hr *ULEIS_data_1hr_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_uleis_level2_data_1hr_error();
void unpack_uleis_level2_data_1hr();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct ULEIS_data_1hr));
  VSinquire(vdata_id_uleis_level2_data_1hr, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_uleis_level2_data_1hr, recnum_rd)==FAIL) {
          print_uleis_level2_data_1hr_error("read_uleis_level2_data_1hr -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_uleis_level2_data_1hr, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_uleis_level2_data_1hr_error("read_uleis_level2_data_1hr -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_uleis_level2_data_1hr(odata, ULEIS_data_1hr_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_uleis_level2_data_1hr()
{
  VSdetach(vdata_id_uleis_level2_data_1hr);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_uleis_level2_data_1hr(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_uleis_level2_data_1hr_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_ULEIS_data_1hr" )) ==FAIL)
    print_uleis_level2_data_1hr_error("rd_Vgrp_uleis_level2_data_1hr -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_uleis_level2_data_1hr_error("rd_Vgrp_uleis_level2_data_1hr -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_uleis_level2_data_1hr_error("rd_Vgrp_uleis_level2_data_1hr -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_uleis_level2_data_1hr_error("rd_Vgrp_uleis_level2_data_1hr -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_ULEIS_data_1hr, HDstrlen(Vgrp_descrp_ULEIS_data_1hr)) ==FAIL)
    print_uleis_level2_data_1hr_error("rd_Vgrp_uleis_level2_data_1hr -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_ULEIS_data_1hr);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_uleis_level2_data_1hr_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_uleis_level2_data_1hr.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_uleis_level2_data_1hr(uint8 *data, struct ULEIS_data_1hr *ULEIS_data_1hr_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &ULEIS_data_1hr_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->H_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->H_S2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->H_S3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->H_S4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->H_S5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_H_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_H_S2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_H_S3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_H_S4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_H_S5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He3_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He3_S2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He3_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He3_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He3_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He3_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He3_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He3_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He3_S2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He3_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He3_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He3_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He3_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He3_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_S2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_S3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L9, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L10, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L11, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->He4_L12, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_S2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_S3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L9, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L10, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L11, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_He4_L12, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->C_L8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_C_L8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->O_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_S1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_O_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Ne_S_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Ne_S_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Ne_S_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Ne_S_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Ne_S_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Ne_S_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Ne_S_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Ne_S_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Ne_S_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Ne_S_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Ne_S_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Ne_S_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Ne_S_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Ne_S_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->Fe_L9, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &ULEIS_data_1hr_ptr->unc_Fe_L9, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_uleis_level2_data_1hr(uint8 *data, struct ULEIS_data_1hr *ULEIS_data_1hr_ptr)
{
int32 ptr=0;

   memcpy(&ULEIS_data_1hr_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&ULEIS_data_1hr_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&ULEIS_data_1hr_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&ULEIS_data_1hr_ptr->H_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->H_S2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->H_S3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->H_S4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->H_S5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_H_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_H_S2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_H_S3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_H_S4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_H_S5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He3_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He3_S2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He3_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He3_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He3_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He3_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He3_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He3_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He3_S2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He3_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He3_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He3_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He3_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He3_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_S2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_S3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L9, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L10, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L11, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->He4_L12, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_S2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_S3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L9, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L10, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L11, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_He4_L12, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->C_L8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_C_L8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->O_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_S1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_O_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Ne_S_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Ne_S_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Ne_S_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Ne_S_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Ne_S_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Ne_S_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Ne_S_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Ne_S_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Ne_S_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Ne_S_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Ne_S_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Ne_S_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Ne_S_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Ne_S_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->Fe_L9, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&ULEIS_data_1hr_ptr->unc_Fe_L9, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_uleis_level2_data_1hr() {return(vgrp_id_uleis_level2_data_1hr);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_uleis_level2_data_1hr(char *wr_strval)
{
  strcpy(wr_strval, "The file 'uleis_level2_data_1hr.h' is shown below, it was used to create the data in the Vgroup named 'VG_ULEIS_data_1hr'.\n\n");
  strcat(wr_strval,"/* Id: uleis_level2_data_1hr.h,v 1.3 2008/09/11 22:41:48 asc Exp $ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct ULEIS_data_1hr {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 H_S1; \n");
  strcat(wr_strval,"  float32 H_S2; \n");
  strcat(wr_strval,"  float32 H_S3; \n");
  strcat(wr_strval,"  float32 H_S4;\n");
  strcat(wr_strval,"  float32 H_S5;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_H_S1; \n");
  strcat(wr_strval,"  float32 unc_H_S2; \n");
  strcat(wr_strval,"  float32 unc_H_S3; \n");
  strcat(wr_strval,"  float32 unc_H_S4;\n");
  strcat(wr_strval,"  float32 unc_H_S5;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 He3_S1; \n");
  strcat(wr_strval,"  float32 He3_S2; \n");
  strcat(wr_strval,"  float32 He3_L2;\n");
  strcat(wr_strval,"  float32 He3_L3;\n");
  strcat(wr_strval,"  float32 He3_L4;\n");
  strcat(wr_strval,"  float32 He3_L5;\n");
  strcat(wr_strval,"  float32 He3_L6;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_He3_S1; \n");
  strcat(wr_strval,"  float32 unc_He3_S2; \n");
  strcat(wr_strval,"  float32 unc_He3_L2;\n");
  strcat(wr_strval,"  float32 unc_He3_L3;\n");
  strcat(wr_strval,"  float32 unc_He3_L4;\n");
  strcat(wr_strval,"  float32 unc_He3_L5;\n");
  strcat(wr_strval,"  float32 unc_He3_L6;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 He4_S1;\n");
  strcat(wr_strval,"  float32 He4_S2;\n");
  strcat(wr_strval,"  float32 He4_S3;\n");
  strcat(wr_strval,"  float32 He4_L1;\n");
  strcat(wr_strval,"  float32 He4_L2;\n");
  strcat(wr_strval,"  float32 He4_L3;\n");
  strcat(wr_strval,"  float32 He4_L4;\n");
  strcat(wr_strval,"  float32 He4_L5;\n");
  strcat(wr_strval,"  float32 He4_L6;\n");
  strcat(wr_strval,"  float32 He4_L7;\n");
  strcat(wr_strval,"  float32 He4_L8;\n");
  strcat(wr_strval,"  float32 He4_L9;\n");
  strcat(wr_strval,"  float32 He4_L10;\n");
  strcat(wr_strval,"  float32 He4_L11;\n");
  strcat(wr_strval,"  float32 He4_L12;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_He4_S1;\n");
  strcat(wr_strval,"  float32 unc_He4_S2;\n");
  strcat(wr_strval,"  float32 unc_He4_S3;\n");
  strcat(wr_strval,"  float32 unc_He4_L1;\n");
  strcat(wr_strval,"  float32 unc_He4_L2;\n");
  strcat(wr_strval,"  float32 unc_He4_L3;\n");
  strcat(wr_strval,"  float32 unc_He4_L4;\n");
  strcat(wr_strval,"  float32 unc_He4_L5;\n");
  strcat(wr_strval,"  float32 unc_He4_L6;\n");
  strcat(wr_strval,"  float32 unc_He4_L7;\n");
  strcat(wr_strval,"  float32 unc_He4_L8;\n");
  strcat(wr_strval,"  float32 unc_He4_L9;\n");
  strcat(wr_strval,"  float32 unc_He4_L10;\n");
  strcat(wr_strval,"  float32 unc_He4_L11;\n");
  strcat(wr_strval,"  float32 unc_He4_L12;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 C_S1;\n");
  strcat(wr_strval,"  float32 C_L1;\n");
  strcat(wr_strval,"  float32 C_L2;\n");
  strcat(wr_strval,"  float32 C_L3;\n");
  strcat(wr_strval,"  float32 C_L4;\n");
  strcat(wr_strval,"  float32 C_L5;\n");
  strcat(wr_strval,"  float32 C_L6;\n");
  strcat(wr_strval,"  float32 C_L7;\n");
  strcat(wr_strval,"  float32 C_L8;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_C_S1;\n");
  strcat(wr_strval,"  float32 unc_C_L1;\n");
  strcat(wr_strval,"  float32 unc_C_L2;\n");
  strcat(wr_strval,"  float32 unc_C_L3;\n");
  strcat(wr_strval,"  float32 unc_C_L4;\n");
  strcat(wr_strval,"  float32 unc_C_L5;\n");
  strcat(wr_strval,"  float32 unc_C_L6;\n");
  strcat(wr_strval,"  float32 unc_C_L7;\n");
  strcat(wr_strval,"  float32 unc_C_L8;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 O_S1;\n");
  strcat(wr_strval,"  float32 O_L1;\n");
  strcat(wr_strval,"  float32 O_L2;\n");
  strcat(wr_strval,"  float32 O_L3;\n");
  strcat(wr_strval,"  float32 O_L4;\n");
  strcat(wr_strval,"  float32 O_L5;\n");
  strcat(wr_strval,"  float32 O_L6;\n");
  strcat(wr_strval,"  float32 O_L7;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_O_S1;\n");
  strcat(wr_strval,"  float32 unc_O_L1;\n");
  strcat(wr_strval,"  float32 unc_O_L2;\n");
  strcat(wr_strval,"  float32 unc_O_L3;\n");
  strcat(wr_strval,"  float32 unc_O_L4;\n");
  strcat(wr_strval,"  float32 unc_O_L5;\n");
  strcat(wr_strval,"  float32 unc_O_L6;\n");
  strcat(wr_strval,"  float32 unc_O_L7;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Ne_S_L1;\n");
  strcat(wr_strval,"  float32 Ne_S_L2;\n");
  strcat(wr_strval,"  float32 Ne_S_L3;\n");
  strcat(wr_strval,"  float32 Ne_S_L4;\n");
  strcat(wr_strval,"  float32 Ne_S_L5;\n");
  strcat(wr_strval,"  float32 Ne_S_L6;\n");
  strcat(wr_strval,"  float32 Ne_S_L7;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_Ne_S_L1;\n");
  strcat(wr_strval,"  float32 unc_Ne_S_L2;\n");
  strcat(wr_strval,"  float32 unc_Ne_S_L3;\n");
  strcat(wr_strval,"  float32 unc_Ne_S_L4;\n");
  strcat(wr_strval,"  float32 unc_Ne_S_L5;\n");
  strcat(wr_strval,"  float32 unc_Ne_S_L6;\n");
  strcat(wr_strval,"  float32 unc_Ne_S_L7;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Fe_L1;\n");
  strcat(wr_strval,"  float32 Fe_L2;\n");
  strcat(wr_strval,"  float32 Fe_L3;\n");
  strcat(wr_strval,"  float32 Fe_L4;\n");
  strcat(wr_strval,"  float32 Fe_L5;\n");
  strcat(wr_strval,"  float32 Fe_L6;\n");
  strcat(wr_strval,"  float32 Fe_L7;\n");
  strcat(wr_strval,"  float32 Fe_L8;\n");
  strcat(wr_strval,"  float32 Fe_L9;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_Fe_L1;\n");
  strcat(wr_strval,"  float32 unc_Fe_L2;\n");
  strcat(wr_strval,"  float32 unc_Fe_L3;\n");
  strcat(wr_strval,"  float32 unc_Fe_L4;\n");
  strcat(wr_strval,"  float32 unc_Fe_L5;\n");
  strcat(wr_strval,"  float32 unc_Fe_L6;\n");
  strcat(wr_strval,"  float32 unc_Fe_L7;\n");
  strcat(wr_strval,"  float32 unc_Fe_L8;\n");
  strcat(wr_strval,"  float32 unc_Fe_L9;\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"\n");
  return(0);
}
