#include <stdio.h>
#include <string.h>
#include <time.h>


#include "cris_level2_data_Bartels.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct CRIS_data_Bartels *testdata;
  int ii,jj,retval;
  int32 numrec;
  time_t tloc;
  char timestr[80];
  

  if (argc!=3) {
      printf("Usage: cris_l2_bartels_rd hdf_file one_of: B thru Ni\n");
      exit(1);
  }

  if (
      (strcmp("B",argv[2])) &&
      (strcmp("C",argv[2])) &&
      (strcmp("N",argv[2])) &&
      (strcmp("O",argv[2])) &&
      (strcmp("F",argv[2])) &&
      (strcmp("Ne",argv[2])) &&
      (strcmp("Na",argv[2])) &&
      (strcmp("Mg",argv[2])) &&
      (strcmp("Al",argv[2])) &&
      (strcmp("Si",argv[2])) &&
      (strcmp("P",argv[2])) &&
      (strcmp("S",argv[2])) &&
      (strcmp("Cl",argv[2])) &&
      (strcmp("Ar",argv[2])) &&
      (strcmp("K",argv[2])) &&
      (strcmp("Ca",argv[2])) &&
      (strcmp("Sc",argv[2])) &&
      (strcmp("Ti",argv[2])) &&
      (strcmp("V",argv[2])) &&
      (strcmp("Cr",argv[2])) &&
      (strcmp("Mn",argv[2])) &&
      (strcmp("Fe",argv[2])) &&
      (strcmp("Co",argv[2])) &&
      (strcmp("Ni",argv[2]))
     ) {
      printf("Usage: cris_l2_bartels_rd hdf_file one_of: B thru Ni\n");
      exit(1);
  }
     

  testdata=malloc(sizeof(struct CRIS_data_Bartels));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
  }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
  }

  numrec=init_rd_cris_level2_data_Bartels(hdf_fp, sd_id, "r");

  if( numrec<=0) {
      fprintf(stderr,"No cris level2 Bartels data\n");
      exit(-1);
  }

  time(&tloc);
  strftime(timestr,79,"%C",localtime(&tloc));
  printf("Bartels rotation %s Data extracted from HDF file on %s\n",argv[2],timestr);
  printf("HDF File: %s\n\n",argv[1]);
  printf("fpyear  day-of-year  7-fluxes 7-counts livetime\n");

  ii=0;
  while( (retval = read_cris_level2_data_Bartels(testdata,ii))!=-1 ) {
     printf("%13.8f %3d ",testdata->fp_year,testdata->day);
     if (!strcmp("B",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_B[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_B[jj]);
     }
     if (!strcmp("C",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_C[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_C[jj]);
     }
     if (!strcmp("N",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_N[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_N[jj]);
     }
     if (!strcmp("O",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_O[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_O[jj]);
     }
     if (!strcmp("F",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_F[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_F[jj]);
     }
     if (!strcmp("Ne",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ne[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ne[jj]);
     }
     if (!strcmp("Na",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Na[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Na[jj]);
     }
     if (!strcmp("Mg",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Mg[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Mg[jj]);
     }
     if (!strcmp("Al",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Al[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Al[jj]);
     }
     if (!strcmp("Si",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Si[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Si[jj]);
     }
     if (!strcmp("P",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_P[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_P[jj]);
     }
     if (!strcmp("S",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_S[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_S[jj]);
     }
     if (!strcmp("Cl",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Cl[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Cl[jj]);
     }
     if (!strcmp("Ar",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ar[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ar[jj]);
     }
     if (!strcmp("K",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_K[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_K[jj]);
     }
     if (!strcmp("Ca",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ca[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ca[jj]);
     }
     if (!strcmp("Sc",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Sc[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Sc[jj]);
     }
     if (!strcmp("Ti",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ti[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ti[jj]);
     }
     if (!strcmp("V",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_V[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_V[jj]);
     }
     if (!strcmp("Cr",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Cr[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Cr[jj]);
     }
     if (!strcmp("Mn",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Mn[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Mn[jj]);
     }
     if (!strcmp("Fe",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Fe[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Fe[jj]);
     }
     if (!strcmp("Co",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Co[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Co[jj]);
     }
     if (!strcmp("Ni",argv[2])) {
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->flux_Ni[jj]);
	  for (jj=0;jj<7;jj++) printf("% 11.4e ",testdata->cnt_Ni[jj]);
     }
     printf("% 7.4f\n",testdata->livetime);
     ii++;
  }

  /* all done, close HDF file */

  close_rd_cris_level2_data_Bartels();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
  }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
  }
  exit(0);
}


