/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExportCreateCDF
implements CDFConstants,
Runnable {
    private ExportCreateCDF exportCreateCDF = this;
    private BuildProgressPanel progressPanel;
    private ExportCDFTable exportCDFTable;
    private CDFExport myCDFExport;
    private CDF sourceCDF;
    private CDF cdf;
    private String destCDF;
    private int totalItems;
    private int currentProgressValue = 0;
    private int irec;
    private int len;
    private int minLen;
    private int maxLen;
    private int filLen;
    private Object oldMin;
    private Object newMin;
    private Object oldMax;
    private Object newMax;
    private Object newFil;
    private Variable variable;
    private Variable newVariable;
    private Vector variableAttributes;
    private Attribute attribute;
    private Attribute newAttribute;
    private boolean padValue;
    private boolean compressed;
    private Object minObj = null;
    private Object maxObj = null;
    private Object filObj = null;
    private boolean deleting;

    ExportCreateCDF(CDFExport cDFExport, ExportCDFTable exportCDFTable) {
        this.exportCDFTable = exportCDFTable;
        this.myCDFExport = cDFExport;
        this.sourceCDF = cDFExport.sourceCDF;
        this.destCDF = cDFExport.outSelection == 3 ? cDFExport.cdfspec3 : cDFExport.cdfspec4;
        boolean bl = this.deleting = cDFExport.overwrite != 0;
        if (this.deleting) {
            File file;
            File file2 = new File(this.destCDF + ".cdf");
            if (file2.exists()) {
                file2.delete();
            }
            if ((file = new File(this.destCDF + ".CDF")).exists()) {
                file.delete();
            }
        }
    }

    @Override
    public void run() {
        int n;
        Enumeration enumeration;
        try {
            this.cdf = CDF.open((String)this.destCDF, (long)0L);
            try {
                if (!this.deleting) {
                    this.cdf.close();
                    this.myCDFExport.info.setText("Error! CDF: " + this.destCDF + " already exists");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.cdf.delete();
            }
            catch (CDFException cDFException) {
                if (this.cdf != null) {
                    this.cdf.close();
                }
                this.myCDFExport.info.setText("Error! CDF: " + this.destCDF + " " + cDFException.toString());
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        this.cdf = null;
        try {
            CDF.setFileBackward((long)this.myCDFExport.backwardFlag);
            this.cdf = CDF.create((String)this.destCDF);
        }
        catch (CDFException cDFException) {
            this.myCDFExport.info.setText("Error: " + cDFException.toString());
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.myCDFExport.info.setText("Exporting starts...\n");
        this.myCDFExport.info.append("from: " + this.sourceCDF.getName() + "\n");
        this.myCDFExport.info.append("  to: " + this.destCDF + "\n");
        try {
            this.cdf.setFormat(this.myCDFExport.format);
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        if (this.myCDFExport.compressionType != -1) {
            try {
                this.cdf.setCompression((long)this.myCDFExport.compressionType, new long[]{this.myCDFExport.compressionLevel});
            }
            catch (CDFException cDFException) {}
        } else {
            try {
                this.cdf.setCompression(this.sourceCDF.getCompressionType(), this.sourceCDF.getCompressionParms());
            }
            catch (CDFException cDFException) {
                // empty catch block
            }
        }
        try {
            if (this.myCDFExport.majority == 0L) {
                this.cdf.setMajority(this.sourceCDF.getMajority());
            } else {
                this.cdf.setMajority(this.myCDFExport.majority);
            }
            this.cdf.setEncoding(this.sourceCDF.getEncoding());
            if (this.myCDFExport.checksum != 0L) {
                this.cdf.setChecksum(this.myCDFExport.checksum);
            }
        }
        catch (CDFException cDFException) {
            System.err.println("Error...1 " + (Object)((Object)cDFException));
        }
        try {
            this.cdf.selectNegtoPosfp0(this.sourceCDF.confirmNegtoPosfp0());
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        try {
            Object object;
            enumeration = this.sourceCDF.getGlobalAttributes();
            n = 0;
            Enumeration enumeration2 = ((Vector)((Object)enumeration)).elements();
            while (enumeration2.hasMoreElements()) {
                object = ((Attribute)enumeration2.nextElement()).getEntries();
                if (object == null) continue;
                n += ((Vector)object).size();
            }
            this.variableAttributes = this.sourceCDF.getVariableAttributes();
            if (this.variableAttributes != null) {
                n += this.variableAttributes.size();
            }
            int n2 = 0;
            object = this.myCDFExport.vars.elements();
            while (object.hasMoreElements()) {
                this.variable = (Variable)object.nextElement();
                if (this.variable.getNumWrittenRecords() <= 0L) continue;
                this.irec = (int)this.variable.getMaxWrittenRecord();
                n2 += this.irec;
            }
            this.totalItems = n + n2;
            this.progressPanel = new BuildProgressPanel(this.exportCreateCDF, this.totalItems);
            object = ((Vector)((Object)enumeration)).elements();
            while (object.hasMoreElements()) {
                this.attribute = (Attribute)object.nextElement();
                this.newAttribute = Attribute.create((CDF)this.cdf, (String)this.attribute.getName(), (long)1L);
                Vector vector = this.attribute.getEntries();
                Enumeration enumeration3 = vector.elements();
                while (enumeration3.hasMoreElements()) {
                    Entry entry = (Entry)enumeration3.nextElement();
                    if (entry == null) continue;
                    Entry entry2 = Entry.create((Attribute)this.newAttribute, (long)entry.getID(), (long)entry.getDataType(), (Object)entry.getData());
                }
                if (vector == null) continue;
                this.currentProgressValue += vector.size();
            }
            new UpdateProgress((Object)this.exportCreateCDF, this.currentProgressValue).start();
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        try {
            enumeration = this.variableAttributes.elements();
            while (enumeration.hasMoreElements()) {
                this.attribute = (Attribute)enumeration.nextElement();
                if (this.attribute == null) continue;
                this.newAttribute = Attribute.create((CDF)this.cdf, (String)this.attribute.getName(), (long)2L);
            }
            if (this.variableAttributes != null) {
                this.currentProgressValue += this.variableAttributes.size();
            }
            new UpdateProgress((Object)this.exportCreateCDF, this.currentProgressValue).start();
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        try {
            enumeration = this.myCDFExport.vars.elements();
            while (enumeration.hasMoreElements()) {
                this.variable = (Variable)enumeration.nextElement();
                n = (Integer)this.exportCDFTable.myHash.get(this.variable.getName());
                this.irec = -1;
                try {
                    if (this.variable.getNumWrittenRecords() > 0L) {
                        this.irec = (int)this.variable.getMaxWrittenRecord();
                    }
                }
                catch (CDFException cDFException) {
                    // empty catch block
                }
                if (((Boolean)this.exportCDFTable.getDataObject()[n][5]).booleanValue()) {
                    Object object;
                    Attribute attribute;
                    Vector vector;
                    Object object2;
                    boolean bl = this.exportCDFTable.numColumns2 <= 0;
                    try {
                        long l = this.variable.getDataType();
                        long l2 = this.variable.getNumElements();
                        long l3 = this.variable.getNumDims();
                        long[] lArray = this.variable.getDimSizes();
                        long l4 = this.variable.getRecVariance() ? -1L : 0L;
                        long[] lArray2 = this.variable.getDimVariances();
                        if (l3 == 0L) {
                            lArray = new long[]{1L};
                            lArray2 = new long[]{-1L};
                        }
                        this.newVariable = Variable.create((CDF)this.cdf, (String)this.variable.getName(), (long)l, (long)l2, (long)l3, (long[])lArray, (long)l4, (long[])lArray2);
                    }
                    catch (CDFException cDFException) {
                        System.err.println("error...00 gettting variable info:" + (Object)((Object)cDFException));
                    }
                    try {
                        long l = this.variable.getBlockingFactor();
                        this.newVariable.setBlockingFactor(l);
                    }
                    catch (CDFException cDFException) {
                        System.err.println("error...1 setBlockingFactor " + (Object)((Object)cDFException));
                    }
                    this.padValue = false;
                    try {
                        Object object3;
                        if (this.variable.checkPadValueExistence() && (object3 = this.variable.getPadValue()) != null) {
                            this.newVariable.setPadValue(object3);
                            this.padValue = true;
                        }
                    }
                    catch (CDFException cDFException) {
                        System.err.println("error...2 setPadValue " + (Object)((Object)cDFException));
                    }
                    try {
                        long l = this.variable.getCompressionType();
                        object2 = this.variable.getCompressionParms();
                        this.newVariable.setCompression(l, object2);
                        this.compressed = true;
                    }
                    catch (CDFException cDFException) {
                        this.compressed = false;
                        System.err.println("error...3 setCompression " + (Object)((Object)cDFException));
                    }
                    try {
                        long l = this.variable.getSparseRecords();
                        this.newVariable.setSparseRecords(l);
                    }
                    catch (CDFException cDFException) {
                        System.err.println("error...3a setSparseRecords " + (Object)((Object)cDFException));
                    }
                    if (!bl) {
                        vector = null;
                        attribute = null;
                        for (int i = 1; i < this.exportCDFTable.numColumns2; ++i) {
                            object = this.exportCDFTable.getFilterObject()[n][i];
                            try {
                                vector = this.cdf.getAttribute(this.exportCDFTable.columnNames2[i]);
                                attribute = this.sourceCDF.getAttribute(this.exportCDFTable.columnNames2[i]);
                                if (object == null && object.toString().trim().length() == 0) continue;
                                vector.deleteEntry(this.newVariable);
                                long l = attribute.getEntry(this.variable).getDataType();
                                Object object4 = null;
                                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                                int n3 = stringTokenizer.countTokens();
                                object4 = n3 == -1 ? null : CDFToolUtils.parseContents((String)object, l);
                                if (object4 == null) continue;
                                Entry.create((Attribute)vector, (long)this.newVariable.getID(), (long)l, (Object)object4);
                                continue;
                            }
                            catch (CDFException cDFException) {
                                System.err.println("error...4 create attribute entry " + (Object)((Object)cDFException));
                            }
                        }
                    } else {
                        vector = this.variable.getMyCDF().getAttributes();
                        object = vector.elements();
                        while (object.hasMoreElements()) {
                            attribute = (Attribute)object.nextElement();
                            if (attribute.getScope() != 2L) continue;
                            try {
                                object2 = attribute.getEntry(this.variable.getID());
                                Attribute attribute2 = this.cdf.getAttributeID(attribute.getName()) == -1L ? Attribute.create((CDF)this.cdf, (String)attribute.getName(), (long)2L) : this.cdf.getAttribute(attribute.getName());
                                Entry.create((Attribute)attribute2, (long)this.newVariable.getID(), (long)object2.getDataType(), (Object)object2.getData());
                            }
                            catch (CDFException cDFException) {}
                        }
                    }
                    if (this.irec > -1) {
                        if (!this.padValue && !this.compressed) {
                            this.newVariable.allocateRecords((long)this.irec + 1L);
                        }
                        this.loadRecords(this.newVariable, this.variable);
                    }
                }
                this.currentProgressValue += this.irec + 1;
                new UpdateProgress((Object)this.exportCreateCDF, this.currentProgressValue).start();
            }
            new CleanProgress().start();
            this.myCDFExport.info.append("\n\nexporting is done");
            this.cdf.close();
            this.cdf = null;
        }
        catch (Exception exception) {
            System.out.println("A bad thing happened on the way to the CDF.");
            exception.printStackTrace();
        }
    }

    private void loadRecords(Variable variable, Variable variable2) {
        Object object;
        long l = variable2.getDataType();
        if (this.myCDFExport.getFiltering() == 0 || this.myCDFExport.getFiltering() == 1 && this.myCDFExport.getValidMin() == 0 && this.myCDFExport.getValidMax() == 0 && this.myCDFExport.getFillVal() == 0) {
            try {
                variable2.copyDataRecords(variable);
            }
            catch (CDFException cDFException) {
                System.err.println("error copying data records");
                return;
            }
        }
        int n = (Integer)this.exportCDFTable.myHash.get(variable2.getName());
        int n2 = 0;
        boolean bl = false;
        if (this.myCDFExport.getValidMin() == 1) {
            this.newMin = this.exportCDFTable.getFilterObject()[n][++n2];
            bl = true;
            if (this.newMin != null && ((String)this.newMin).trim().length() > 0) {
                object = new StringTokenizer((String)this.newMin, ",");
                this.minLen = ((StringTokenizer)object).countTokens();
                this.minObj = this.minLen == -1 ? null : CDFToolUtils.parseContents((String)this.newMin, l);
            } else {
                this.minObj = null;
            }
        }
        if (this.myCDFExport.getValidMax() == 1) {
            this.newMax = this.exportCDFTable.getFilterObject()[n][++n2];
            bl = true;
            if (this.newMax != null && ((String)this.newMax).trim().length() > 0) {
                object = new StringTokenizer((String)this.newMax, ",");
                this.maxLen = ((StringTokenizer)object).countTokens();
                this.maxObj = this.maxLen == -1 ? null : CDFToolUtils.parseContents((String)this.newMax, l);
            } else {
                this.maxObj = null;
            }
        }
        if (this.myCDFExport.getFillVal() == 1) {
            this.newFil = this.exportCDFTable.getFilterObject()[n][++n2];
            if (this.newFil != null && ((String)this.newFil).trim().length() > 0) {
                object = new StringTokenizer((String)this.newFil, ",");
                this.filLen = ((StringTokenizer)object).countTokens();
                this.filObj = this.filLen == -1 ? null : CDFToolUtils.parseContents((String)this.newFil, l);
                bl = true;
            } else {
                this.filObj = null;
            }
        } else {
            try {
                object = variable2.getEntryData("FILLVAL");
                if (object != null) {
                    String string = object.toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    this.filLen = stringTokenizer.countTokens();
                    this.filObj = this.filLen == -1 ? null : CDFToolUtils.parseContents(string, l);
                } else {
                    this.filObj = null;
                }
            }
            catch (CDFException cDFException) {
                this.filObj = null;
            }
        }
        if (!bl) {
            try {
                variable2.copyDataRecords(variable);
            }
            catch (CDFException cDFException) {
                System.err.println("error copying data records");
                return;
            }
        } else {
            for (int i = 0; i <= this.irec; ++i) {
                try {
                    object = variable2.getRecord((long)i);
                    object = this.filterData(object, variable);
                    variable.putRecord((long)i, object);
                    continue;
                }
                catch (CDFException cDFException) {
                    System.err.println("error read/write one record");
                    return;
                }
            }
        }
    }

    private Object filterData(Object object, Variable variable) {
        block276: {
            int n;
            boolean bl;
            long[] lArray;
            int n2;
            long l;
            block274: {
                block288: {
                    block287: {
                        block286: {
                            block285: {
                                block284: {
                                    block283: {
                                        block275: {
                                            block282: {
                                                block281: {
                                                    block280: {
                                                        block279: {
                                                            block278: {
                                                                block277: {
                                                                    l = variable.getDataType();
                                                                    n2 = (int)variable.getNumDims();
                                                                    lArray = variable.getDimSizes();
                                                                    bl = true;
                                                                    if (n2 > 1) break block274;
                                                                    if (n2 != 0) break block275;
                                                                    bl = true;
                                                                    if (l == 51L || l == 52L) break block276;
                                                                    if (l != 41L && l != 1L) break block277;
                                                                    byte by = (Byte)object;
                                                                    if (this.minObj != null && by < ((byte[])this.minObj)[0]) {
                                                                        object = this.filObj != null ? new Byte(((byte[])this.filObj)[0]) : new Byte(0);
                                                                    }
                                                                    if (this.maxObj == null || by <= ((byte[])this.maxObj)[0]) break block276;
                                                                    object = this.filObj != null ? new Byte(((byte[])this.filObj)[0]) : new Byte(0);
                                                                    break block276;
                                                                }
                                                                if (l != 2L && l != 11L) break block278;
                                                                short s = (Short)object;
                                                                short s2 = 0;
                                                                short s3 = 0;
                                                                short s4 = 0;
                                                                if (this.filObj != null) {
                                                                    s2 = ((short[])this.filObj)[0];
                                                                }
                                                                if (this.minObj != null) {
                                                                    s4 = ((short[])this.minObj)[0];
                                                                }
                                                                if (this.maxObj != null) {
                                                                    s3 = ((short[])this.maxObj)[0];
                                                                }
                                                                if (l == 11L) {
                                                                    if (s2 < 0) {
                                                                        s2 = (short)(s2 + 256);
                                                                    }
                                                                    if (s < 0) {
                                                                        s = (short)(s + 256);
                                                                    }
                                                                    if (s4 < 0) {
                                                                        s4 = (short)(s4 + 256);
                                                                    }
                                                                    if (s3 < 0) {
                                                                        s3 = (short)(s3 + 256);
                                                                    }
                                                                }
                                                                if (this.minObj != null && s < s4) {
                                                                    bl = false;
                                                                    object = this.filObj != null ? new Short(s2) : new Short(0);
                                                                }
                                                                if (!bl || this.maxObj == null || s <= s3) break block276;
                                                                object = this.filObj != null ? new Short(s2) : new Short(0);
                                                                break block276;
                                                            }
                                                            if (l != 4L && l != 12L) break block279;
                                                            int n3 = (Integer)object;
                                                            int n4 = 0;
                                                            int n5 = 0;
                                                            int n6 = 0;
                                                            if (this.filObj != null) {
                                                                n4 = ((int[])this.filObj)[0];
                                                            }
                                                            if (this.minObj != null) {
                                                                n6 = ((int[])this.minObj)[0];
                                                            }
                                                            if (this.maxObj != null) {
                                                                n5 = ((int[])this.maxObj)[0];
                                                            }
                                                            if (l == 12L) {
                                                                if (n4 < 0) {
                                                                    n4 += 65536;
                                                                }
                                                                if (n3 < 0) {
                                                                    n3 += 65536;
                                                                }
                                                                if (n6 < 0) {
                                                                    n6 += 65536;
                                                                }
                                                                if (n5 < 0) {
                                                                    n5 += 65536;
                                                                }
                                                            }
                                                            if (this.minObj != null && n3 < n6) {
                                                                bl = false;
                                                                object = this.filObj != null ? new Integer(n4) : new Integer(0);
                                                            }
                                                            if (!bl || this.maxObj == null || n3 <= n5) break block276;
                                                            object = this.filObj != null ? new Integer(n4) : new Integer(0);
                                                            break block276;
                                                        }
                                                        if (l != 14L && l != 8L && l != 33L) break block280;
                                                        long l2 = (Long)object;
                                                        long l3 = 0L;
                                                        long l4 = 0L;
                                                        long l5 = 0L;
                                                        if (this.filObj != null) {
                                                            l3 = ((long[])this.filObj)[0];
                                                        }
                                                        if (this.minObj != null) {
                                                            l5 = ((long[])this.minObj)[0];
                                                        }
                                                        if (this.maxObj != null) {
                                                            l4 = ((long[])this.maxObj)[0];
                                                        }
                                                        if (l == 14L) {
                                                            if (l3 < 0L) {
                                                                l3 -= -4294967296L;
                                                            }
                                                            if (l2 < 0L) {
                                                                l2 -= -4294967296L;
                                                            }
                                                            if (l5 < 0L) {
                                                                l5 -= -4294967296L;
                                                            }
                                                            if (l4 < 0L) {
                                                                l4 -= -4294967296L;
                                                            }
                                                        }
                                                        if (this.minObj != null && l2 < l5) {
                                                            bl = false;
                                                            object = this.filObj != null ? new Long(l3) : new Long(0L);
                                                        }
                                                        if (!bl || this.maxObj == null || l2 <= l4) break block276;
                                                        object = this.filObj != null ? new Long(l3) : new Long(0L);
                                                        break block276;
                                                    }
                                                    if (l != 21L && l != 44L) break block281;
                                                    float f = ((Float)object).floatValue();
                                                    if (this.minObj != null && f < ((float[])this.minObj)[0]) {
                                                        bl = false;
                                                        object = this.filObj != null ? new Float(((float[])this.filObj)[0]) : new Float(0.0f);
                                                    }
                                                    if (!bl || this.maxObj == null || !(f > ((float[])this.maxObj)[0])) break block276;
                                                    object = this.filObj != null ? new Float(((float[])this.filObj)[0]) : new Float(0.0f);
                                                    break block276;
                                                }
                                                if (l != 22L && l != 45L && l != 31L) break block282;
                                                double d = (Double)object;
                                                if (this.minObj != null && d < ((double[])this.minObj)[0]) {
                                                    bl = false;
                                                    object = this.filObj != null ? new Double(((double[])this.filObj)[0]) : new Double(0.0);
                                                }
                                                if (!bl || this.maxObj == null || !(d > ((double[])this.maxObj)[0])) break block276;
                                                object = this.filObj != null ? new Double(((double[])this.filObj)[0]) : new Double(0.0);
                                                break block276;
                                            }
                                            if (l != 32L) break block276;
                                            double[] dArray = new double[]{((double[])object)[0], ((double[])object)[1]};
                                            if (this.minObj != null && (dArray[0] < ((double[])this.minObj)[0] || dArray[0] == ((double[])this.minObj)[0] && dArray[1] < ((double[])this.minObj)[1])) {
                                                bl = false;
                                                if (this.filObj != null) {
                                                    object = new double[2];
                                                    ((double[])object)[0] = ((double[])this.filObj)[0];
                                                    ((double[])object)[1] = ((double[])this.filObj)[1];
                                                } else {
                                                    object = new double[]{0.0, 0.0};
                                                }
                                            }
                                            if (!bl || this.maxObj == null || !(dArray[0] > ((double[])this.maxObj)[0]) && (dArray[0] != ((double[])this.maxObj)[0] || !(dArray[1] > ((double[])this.maxObj)[1]))) break block276;
                                            if (this.filObj != null) {
                                                object = new double[2];
                                                ((double[])object)[0] = ((double[])this.filObj)[0];
                                                ((double[])object)[1] = ((double[])this.filObj)[1];
                                            } else {
                                                object = new double[]{0.0, 0.0};
                                            }
                                            break block276;
                                        }
                                        if (l == 51L || l == 52L) break block276;
                                        if (l != 41L && l != 1L) break block283;
                                        byte by = 0;
                                        byte by2 = 0;
                                        byte by3 = 0;
                                        byte by4 = 0;
                                        if (this.minObj != null && this.minLen == 1) {
                                            by2 = ((byte[])this.minObj)[0];
                                        }
                                        if (this.maxObj != null && this.maxLen == 1) {
                                            by3 = ((byte[])this.maxObj)[0];
                                        }
                                        if (this.filObj != null) {
                                            by4 = ((byte[])this.filObj)[0];
                                        }
                                        for (int i = 0; i < (int)lArray[0]; ++i) {
                                            bl = true;
                                            by = ((byte[])object)[i];
                                            if (this.minObj != null) {
                                                if (this.minLen == 1) {
                                                    if (by < by2) {
                                                        bl = false;
                                                        ((byte[])object)[i] = this.filObj != null ? by4 : (byte)0;
                                                    }
                                                } else if (((byte[])this.minObj).length > i && by < ((byte[])this.minObj)[i]) {
                                                    bl = false;
                                                    ((byte[])object)[i] = this.filObj != null ? by4 : (byte)0;
                                                }
                                            }
                                            if (!bl || this.maxObj == null) continue;
                                            if (this.maxLen == 1) {
                                                if (by <= by3) continue;
                                                if (this.filObj != null) {
                                                    ((byte[])object)[i] = by4;
                                                    continue;
                                                }
                                                ((byte[])object)[i] = 0;
                                                continue;
                                            }
                                            if (((byte[])this.maxObj).length <= i || by <= ((byte[])this.maxObj)[i]) continue;
                                            ((byte[])object)[i] = this.filObj != null ? by4 : (byte)0;
                                        }
                                        break block276;
                                    }
                                    if (l != 2L && l != 11L) break block284;
                                    short s = 0;
                                    short s5 = 0;
                                    short s6 = 0;
                                    short s7 = 0;
                                    if (this.minObj != null) {
                                        s5 = ((short[])this.minObj)[0];
                                    }
                                    if (this.maxObj != null) {
                                        s6 = ((short[])this.maxObj)[0];
                                    }
                                    if (this.filObj != null) {
                                        s7 = ((short[])this.filObj)[0];
                                    }
                                    if (l == 11L) {
                                        if (s5 < 0) {
                                            s5 = (short)(s5 + 256);
                                        }
                                        if (s6 < 0) {
                                            s6 = (short)(s6 + 256);
                                        }
                                        if (s7 < 0) {
                                            s7 = (short)(s7 + 256);
                                        }
                                    }
                                    for (int i = 0; i < (int)lArray[0]; ++i) {
                                        short s8;
                                        bl = true;
                                        s = ((short[])object)[i];
                                        if (l == 11L && s < 0) {
                                            s = (short)(s + 256);
                                        }
                                        if (this.minObj != null) {
                                            if (this.minLen == 1) {
                                                if (s < s5) {
                                                    bl = false;
                                                    ((short[])object)[i] = this.filObj != null ? s7 : (short)0;
                                                }
                                            } else if (((short[])this.minObj).length > i) {
                                                s8 = ((short[])this.minObj)[i];
                                                if (l == 11L && s8 < 0) {
                                                    s8 = (short)(s8 + 256);
                                                }
                                                if (s < s8) {
                                                    bl = false;
                                                    ((short[])object)[i] = this.filObj != null ? s7 : (short)0;
                                                }
                                            }
                                        }
                                        if (!bl || this.maxObj == null) continue;
                                        if (this.maxLen == 1) {
                                            if (s <= s6) continue;
                                            if (this.filObj != null) {
                                                ((short[])object)[i] = s7;
                                                continue;
                                            }
                                            ((short[])object)[i] = 0;
                                            continue;
                                        }
                                        if (((short[])this.maxObj).length <= i) continue;
                                        s8 = ((short[])this.maxObj)[i];
                                        if (l == 11L && s8 < 0) {
                                            s8 = (short)(s8 + 256);
                                        }
                                        if (s <= s8) continue;
                                        ((short[])object)[i] = this.filObj != null ? s7 : (short)0;
                                    }
                                    break block276;
                                }
                                if (l != 4L && l != 12L) break block285;
                                int n7 = 0;
                                int n8 = 0;
                                int n9 = 0;
                                int n10 = 0;
                                if (this.minObj != null) {
                                    n8 = ((int[])this.minObj)[0];
                                }
                                if (this.maxObj != null) {
                                    n9 = ((int[])this.maxObj)[0];
                                }
                                if (this.filObj != null) {
                                    n10 = ((int[])this.filObj)[0];
                                }
                                if (l == 12L) {
                                    if (n8 < 0) {
                                        n8 += 65536;
                                    }
                                    if (n9 < 0) {
                                        n9 += 65536;
                                    }
                                    if (n10 < 0) {
                                        n10 += 65536;
                                    }
                                }
                                for (int i = 0; i < (int)lArray[0]; ++i) {
                                    int n11;
                                    bl = true;
                                    n7 = ((int[])object)[i];
                                    if (l == 12L && n7 < 0) {
                                        n7 += 65536;
                                    }
                                    if (this.minObj != null) {
                                        if (this.minLen == 1) {
                                            if (n7 < n8) {
                                                bl = false;
                                                ((int[])object)[i] = this.filObj != null ? n10 : 0;
                                            }
                                        } else if (((int[])this.minObj).length > i) {
                                            n11 = ((int[])this.minObj)[i];
                                            if (l == 12L && n11 < 0) {
                                                n11 += 65536;
                                            }
                                            if (n7 < n11) {
                                                bl = false;
                                                ((int[])object)[i] = this.filObj != null ? n10 : 0;
                                            }
                                        }
                                    }
                                    if (!bl || this.maxObj == null) continue;
                                    if (this.maxLen == 1) {
                                        if (n7 <= n9) continue;
                                        if (this.filObj != null) {
                                            ((int[])object)[i] = n10;
                                            continue;
                                        }
                                        ((int[])object)[i] = 0;
                                        continue;
                                    }
                                    if (((int[])this.maxObj).length <= i) continue;
                                    n11 = ((int[])this.maxObj)[i];
                                    if (l == 12L && n11 < 0) {
                                        n11 += 65536;
                                    }
                                    if (n7 <= n11) continue;
                                    ((int[])object)[i] = this.filObj != null ? n10 : 0;
                                }
                                break block276;
                            }
                            if (l != 14L && l != 8L && l != 33L) break block286;
                            long l6 = 0L;
                            long l7 = 0L;
                            long l8 = 0L;
                            long l9 = 0L;
                            if (this.minObj != null) {
                                l7 = ((long[])this.minObj)[0];
                            }
                            if (this.maxObj != null) {
                                l8 = ((long[])this.maxObj)[0];
                            }
                            if (this.filObj != null) {
                                l9 = ((long[])this.filObj)[0];
                            }
                            if (l == 14L) {
                                if (l7 < 0L) {
                                    l7 -= -4294967296L;
                                }
                                if (l8 < 0L) {
                                    l8 -= -4294967296L;
                                }
                                if (l9 < 0L) {
                                    l9 -= -4294967296L;
                                }
                            }
                            for (int i = 0; i < (int)lArray[0]; ++i) {
                                long l10;
                                bl = true;
                                l6 = ((long[])object)[i];
                                if (l == 14L && l6 < 0L) {
                                    l6 -= -4294967296L;
                                }
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (l6 < l7) {
                                            bl = false;
                                            ((long[])object)[i] = this.filObj != null ? l9 : 0L;
                                        }
                                    } else if (((long[])this.minObj).length > i) {
                                        l10 = ((long[])this.minObj)[i];
                                        if (l == 14L && l10 < 0L) {
                                            l10 -= -4294967296L;
                                        }
                                        if (l6 < l10) {
                                            bl = false;
                                            ((long[])object)[i] = this.filObj != null ? l9 : 0L;
                                        }
                                    }
                                }
                                if (!bl || this.maxObj == null) continue;
                                if (this.maxLen == 1) {
                                    if (l6 <= l8) continue;
                                    if (this.filObj != null) {
                                        ((long[])object)[i] = l9;
                                        continue;
                                    }
                                    ((long[])object)[i] = 0L;
                                    continue;
                                }
                                if (((long[])this.maxObj).length <= i) continue;
                                l10 = ((long[])this.maxObj)[i];
                                if (l == 14L && l10 < 0L) {
                                    l10 -= -4294967296L;
                                }
                                if (l6 <= l10) continue;
                                ((long[])object)[i] = this.filObj != null ? l9 : 0L;
                            }
                            break block276;
                        }
                        if (l != 21L && l != 44L) break block287;
                        float f = 0.0f;
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        if (this.minObj != null && this.minLen == 1) {
                            f = ((float[])this.minObj)[0];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            f2 = ((float[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            f3 = ((float[])this.filObj)[0];
                        }
                        for (int i = 0; i < (int)lArray[0]; ++i) {
                            bl = true;
                            float f4 = ((float[])object)[i];
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (f4 < f) {
                                        bl = false;
                                        ((float[])object)[i] = this.filObj != null ? f3 : 0.0f;
                                    }
                                } else if (((float[])this.minObj).length > i && f4 < ((float[])this.minObj)[i]) {
                                    bl = false;
                                    ((float[])object)[i] = this.filObj != null ? f3 : 0.0f;
                                }
                            }
                            if (!bl || this.maxObj == null) continue;
                            if (this.maxLen == 1) {
                                if (!(f4 > f2)) continue;
                                if (this.filObj != null) {
                                    ((float[])object)[i] = f3;
                                    continue;
                                }
                                ((float[])object)[i] = 0.0f;
                                continue;
                            }
                            if (((float[])this.maxObj).length <= i || !(f4 > ((float[])this.maxObj)[i])) continue;
                            ((float[])object)[i] = this.filObj != null ? f3 : 0.0f;
                        }
                        break block276;
                    }
                    if (l != 22L && l != 45L && l != 31L) break block288;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    if (this.minObj != null && this.minLen == 1) {
                        d = ((double[])this.minObj)[0];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        d2 = ((double[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        d3 = ((double[])this.filObj)[0];
                    }
                    for (int i = 0; i < (int)lArray[0]; ++i) {
                        bl = true;
                        double d4 = ((double[])object)[i];
                        if (this.minObj != null) {
                            if (this.minLen == 1) {
                                if (d4 < d) {
                                    bl = false;
                                    ((double[])object)[i] = this.filObj != null ? d3 : 0.0;
                                }
                            } else if (((double[])this.minObj).length > i && d4 < ((double[])this.minObj)[i]) {
                                bl = false;
                                ((double[])object)[i] = this.filObj != null ? d3 : 0.0;
                            }
                        }
                        if (!bl || this.maxObj == null) continue;
                        if (this.maxLen == 1) {
                            if (!(d4 > d2)) continue;
                            if (this.filObj != null) {
                                ((double[])object)[i] = d3;
                                continue;
                            }
                            ((double[])object)[i] = 0.0;
                            continue;
                        }
                        if (((double[])this.maxObj).length <= i || !(d4 > ((double[])this.maxObj)[i])) continue;
                        ((double[])object)[i] = this.filObj != null ? d3 : 0.0;
                    }
                    break block276;
                }
                if (l != 32L) break block276;
                double[] dArray = new double[]{0.0, 0.0};
                double[] dArray2 = new double[]{0.0, 0.0};
                double[] dArray3 = new double[]{0.0, 0.0};
                if (this.minObj != null && this.minLen == 1) {
                    dArray[0] = ((double[])this.minObj)[0];
                    dArray[1] = ((double[])this.minObj)[1];
                }
                if (this.maxObj != null && this.maxLen == 1) {
                    dArray2[0] = ((double[])this.maxObj)[0];
                    dArray2[1] = ((double[])this.maxObj)[1];
                }
                if (this.filObj != null) {
                    dArray3[0] = ((double[])this.filObj)[0];
                    dArray3[1] = ((double[])this.filObj)[1];
                }
                for (int i = 0; i < (int)lArray[0]; ++i) {
                    bl = true;
                    double[] dArray4 = new double[]{((double[])object)[2 * i], ((double[])object)[2 * i + 1]};
                    if (this.minObj != null) {
                        if (this.minLen == 1) {
                            if (dArray4[0] < dArray[0] || dArray4[0] == dArray[0] && dArray4[1] < dArray[1]) {
                                bl = false;
                                if (this.filObj != null) {
                                    ((double[])object)[2 * i] = dArray3[0];
                                    ((double[])object)[2 * i + 1] = dArray3[1];
                                } else {
                                    ((double[])object)[2 * i] = 0.0;
                                    ((double[])object)[2 * i + 1] = 0.0;
                                }
                            }
                        } else if (((double[])this.minObj).length > i && (dArray4[0] < ((double[])this.minObj)[2 * i] || dArray4[0] == ((double[])this.minObj)[2 * i] && dArray4[1] < ((double[])this.minObj)[2 * i + 1])) {
                            bl = false;
                            if (this.filObj != null) {
                                ((double[])object)[2 * i] = dArray3[0];
                                ((double[])object)[2 * i + 1] = dArray3[0];
                            } else {
                                ((double[])object)[2 * i] = 0.0;
                                ((double[])object)[2 * i + 1] = 0.0;
                            }
                        }
                    }
                    if (!bl || this.maxObj == null) continue;
                    if (this.maxLen == 1) {
                        if (!(dArray4[0] > dArray2[0]) && (dArray4[0] != dArray2[0] || !(dArray4[1] > dArray2[1]))) continue;
                        if (this.filObj != null) {
                            ((double[])object)[2 * i] = dArray3[0];
                            ((double[])object)[2 * i + 1] = dArray3[1];
                            continue;
                        }
                        ((double[])object)[2 * i] = 0.0;
                        ((double[])object)[2 * i + 1] = 0.0;
                        continue;
                    }
                    if (((double[])this.maxObj).length <= i || !(dArray4[0] > ((double[])this.maxObj)[2 * i]) && (dArray4[0] != ((double[])this.maxObj)[2 * i] || !(dArray4[1] > ((double[])this.maxObj)[2 * i + 1]))) continue;
                    if (this.filObj != null) {
                        ((double[])object)[2 * i] = dArray3[0];
                        ((double[])object)[2 * i + 1] = dArray3[1];
                        continue;
                    }
                    ((double[])object)[2 * i] = 0.0;
                    ((double[])object)[2 * i + 1] = 0.0;
                }
                break block276;
            }
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[n2 - 1];
            int[] nArray = new int[n2 - 1];
            long[] lArray2 = new long[n2 - 1];
            objectArray2[0] = object;
            nArray[0] = 0;
            lArray2[0] = this.product(lArray, 0, n2);
            for (n = 1; n < n2 - 1; ++n) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray2[n] = this.product(lArray, n, n2);
                nArray[n] = 0;
            }
            n = 0;
            Object object2 = object;
            while ((long)n < lArray2[0]) {
                if (n != 0) {
                    for (int i = 0; i < n2 - 1; ++i) {
                        boolean bl2;
                        boolean bl3 = bl2 = (long)n % lArray2[i] == 0L;
                        if (bl2) {
                            int n12 = i;
                            nArray[n12] = nArray[n12] + 1;
                            objectArray2[i] = object2 = Array.get(object2, nArray[i]);
                            for (int j = i + 1; j < n2 - 1; ++j) {
                                nArray[j] = 0;
                                objectArray2[j] = Array.get(objectArray2[j - 1], nArray[j]);
                            }
                            break;
                        }
                        object2 = objectArray2[i];
                    }
                }
                if (l != 51L && l != 52L) {
                    int n13;
                    if (l == 41L || l == 1L) {
                        byte by = 0;
                        byte by5 = 0;
                        byte by6 = 0;
                        if (this.minObj != null && this.minLen == 1) {
                            by = ((byte[])this.minObj)[0];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            by5 = ((byte[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            by6 = ((byte[])this.filObj)[0];
                        }
                        for (n13 = 0; n13 < (int)lArray[n2 - 2]; ++n13) {
                            objectArray = (byte[])Array.get(objectArray2[n2 - 2], n13);
                            for (int i = 0; i < (int)lArray[n2 - 1]; ++i) {
                                bl = true;
                                byte by7 = objectArray[i];
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (by7 < by) {
                                            bl = false;
                                            objectArray[i] = this.filObj != null ? by6 : (byte)0;
                                        }
                                    } else if (((byte[])this.minObj).length > i && by7 < ((byte[])this.minObj)[i]) {
                                        bl = false;
                                        objectArray[i] = this.filObj != null ? by6 : (byte)0;
                                    }
                                }
                                if (!bl || this.maxObj == null) continue;
                                if (this.maxLen == 1) {
                                    if (by7 <= by5) continue;
                                    if (this.filObj != null) {
                                        objectArray[i] = by6;
                                        continue;
                                    }
                                    objectArray[i] = 0;
                                    continue;
                                }
                                if (((byte[])this.maxObj).length <= i || by7 <= ((byte[])this.maxObj)[i]) continue;
                                objectArray[i] = this.filObj != null ? by6 : (byte)0;
                            }
                        }
                    } else if (l == 2L || l == 11L) {
                        short s = 0;
                        short s9 = 0;
                        short s10 = 0;
                        n13 = 0;
                        if (this.minObj != null) {
                            s9 = ((short[])this.minObj)[0];
                        }
                        if (this.maxObj != null) {
                            s10 = ((short[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            n13 = ((short[])this.filObj)[0];
                        }
                        if (l == 11L) {
                            if (s9 < 0) {
                                s9 = (short)(s9 + 256);
                            }
                            if (s10 < 0) {
                                s10 = (short)(s10 + 256);
                            }
                            if (n13 < 0) {
                                n13 = (short)(n13 + 256);
                            }
                        }
                        for (int i = 0; i < (int)lArray[n2 - 2]; ++i) {
                            objectArray = (short[])Array.get(objectArray2[n2 - 2], i);
                            for (int j = 0; j < (int)lArray[n2 - 1]; ++j) {
                                short s11;
                                bl = true;
                                s = ((short[])objectArray)[j];
                                if (l == 11L && s < 0) {
                                    s = (short)(s + 256);
                                }
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (s < s9) {
                                            bl = false;
                                            ((short[])objectArray)[j] = this.filObj != null ? n13 : 0;
                                        }
                                    } else if (((short[])this.minObj).length > j) {
                                        s11 = ((short[])this.minObj)[j];
                                        if (l == 11L && s11 < 0) {
                                            s11 = (short)(s11 + 256);
                                        }
                                        if (s < s11) {
                                            bl = false;
                                            ((short[])objectArray)[j] = this.filObj != null ? n13 : 0;
                                        }
                                    }
                                }
                                if (!bl || this.maxObj == null) continue;
                                if (this.maxLen == 1) {
                                    if (s <= s10) continue;
                                    if (this.filObj != null) {
                                        ((short[])objectArray)[j] = n13;
                                        continue;
                                    }
                                    ((short[])objectArray)[j] = 0;
                                    continue;
                                }
                                if (((short[])this.maxObj).length <= j) continue;
                                s11 = ((short[])this.maxObj)[j];
                                if (l == 11L && s11 < 0) {
                                    s11 = (short)(s11 + 256);
                                }
                                if (s <= s11) continue;
                                ((short[])objectArray)[j] = this.filObj != null ? n13 : 0;
                            }
                        }
                    } else if (l == 4L || l == 12L) {
                        int n14 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        n13 = 0;
                        if (this.minObj != null) {
                            n15 = ((int[])this.minObj)[0];
                        }
                        if (this.maxObj != null) {
                            n16 = ((int[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            n13 = ((int[])this.filObj)[0];
                        }
                        if (l == 12L) {
                            if (n15 < 0) {
                                n15 += 65536;
                            }
                            if (n16 < 0) {
                                n16 += 65536;
                            }
                            if (n13 < 0) {
                                n13 += 65536;
                            }
                        }
                        for (int i = 0; i < (int)lArray[n2 - 2]; ++i) {
                            objectArray = (int[])Array.get(objectArray2[n2 - 2], i);
                            for (int j = 0; j < (int)lArray[n2 - 1]; ++j) {
                                int n17;
                                bl = true;
                                n14 = ((int[])objectArray)[j];
                                if (l == 12L && n14 < 0) {
                                    n14 += 65536;
                                }
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (n14 < n15) {
                                            bl = false;
                                            ((int[])objectArray)[j] = this.filObj != null ? n13 : 0;
                                        }
                                    } else if (((int[])this.minObj).length > j) {
                                        n17 = ((int[])this.minObj)[j];
                                        if (l == 12L && n17 < 0) {
                                            n17 += 65536;
                                        }
                                        if (n14 < n17) {
                                            bl = false;
                                            ((int[])objectArray)[j] = this.filObj != null ? n13 : 0;
                                        }
                                    }
                                }
                                if (!bl || this.maxObj == null) continue;
                                if (this.maxLen == 1) {
                                    if (n14 <= n15) continue;
                                    if (this.filObj != null) {
                                        ((int[])objectArray)[j] = n13;
                                        continue;
                                    }
                                    ((int[])objectArray)[j] = 0;
                                    continue;
                                }
                                if (((int[])this.maxObj).length <= j) continue;
                                n17 = ((int[])this.maxObj)[j];
                                if (l == 12L && n17 < 0) {
                                    n17 += 65536;
                                }
                                if (n14 <= n17) continue;
                                ((int[])objectArray)[j] = this.filObj != null ? n13 : 0;
                            }
                        }
                    } else if (l == 14L || l == 8L || l == 33L) {
                        long l11 = 0L;
                        long l12 = 0L;
                        long l13 = 0L;
                        long l14 = 0L;
                        if (this.minObj != null) {
                            l12 = ((long[])this.minObj)[0];
                        }
                        if (this.maxObj != null) {
                            l13 = ((long[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            l14 = ((long[])this.filObj)[0];
                        }
                        if (l == 14L) {
                            if (l12 < 0L) {
                                l12 -= -4294967296L;
                            }
                            if (l13 < 0L) {
                                l13 -= -4294967296L;
                            }
                            if (l14 < 0L) {
                                l14 -= -4294967296L;
                            }
                        }
                        for (int i = 0; i < (int)lArray[n2 - 2]; ++i) {
                            objectArray = (long[])Array.get(objectArray2[n2 - 2], i);
                            for (int j = 0; j < (int)lArray[n2 - 1]; ++j) {
                                long l15;
                                bl = true;
                                l11 = ((long[])objectArray)[j];
                                if (l == 14L && l11 < 0L) {
                                    l11 -= -4294967296L;
                                }
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (l11 < l12) {
                                            bl = false;
                                            ((long[])objectArray)[j] = this.filObj != null ? l14 : 0L;
                                        }
                                    } else if (((long[])this.minObj).length > j) {
                                        l15 = ((long[])this.minObj)[j];
                                        if (l == 14L && l15 < 0L) {
                                            l15 -= -4294967296L;
                                        }
                                        if (l11 < l15) {
                                            bl = false;
                                            ((long[])objectArray)[j] = this.filObj != null ? l14 : 0L;
                                        }
                                    }
                                }
                                if (!bl || this.maxObj == null) continue;
                                if (this.maxLen == 1) {
                                    if (l11 <= l13) continue;
                                    if (this.filObj != null) {
                                        ((long[])objectArray)[j] = l14;
                                        continue;
                                    }
                                    ((long[])objectArray)[j] = 0L;
                                    continue;
                                }
                                if (((long[])this.maxObj).length <= j) continue;
                                l15 = ((long[])this.maxObj)[j];
                                if (l == 14L && l15 < 0L) {
                                    l15 -= -4294967296L;
                                }
                                if (l11 <= l15) continue;
                                ((long[])objectArray)[j] = this.filObj != null ? l14 : 0L;
                            }
                        }
                    } else if (l == 21L || l == 44L) {
                        float f = 0.0f;
                        float f5 = 0.0f;
                        float f6 = 0.0f;
                        if (this.minObj != null && this.minLen == 1) {
                            f = ((float[])this.minObj)[0];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            f5 = ((float[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            f6 = ((float[])this.filObj)[0];
                        }
                        for (n13 = 0; n13 < (int)lArray[n2 - 2]; ++n13) {
                            objectArray = (float[])Array.get(objectArray2[n2 - 2], n13);
                            for (int i = 0; i < (int)lArray[n2 - 1]; ++i) {
                                bl = true;
                                float f7 = ((float[])objectArray)[i];
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (f7 < f) {
                                            bl = false;
                                            ((float[])objectArray)[i] = this.filObj != null ? f6 : 0.0f;
                                        }
                                    } else if (((float[])this.minObj).length > i && f7 < ((float[])this.minObj)[i]) {
                                        bl = false;
                                        ((float[])objectArray)[i] = this.filObj != null ? f6 : 0.0f;
                                    }
                                }
                                if (!bl || this.maxObj == null) continue;
                                if (this.maxLen == 1) {
                                    if (!(f7 > f5)) continue;
                                    if (this.filObj != null) {
                                        ((float[])objectArray)[i] = f6;
                                        continue;
                                    }
                                    ((float[])objectArray)[i] = 0.0f;
                                    continue;
                                }
                                if (((float[])this.maxObj).length <= i || !(f7 > ((float[])this.maxObj)[i])) continue;
                                ((float[])objectArray)[i] = this.filObj != null ? f6 : 0.0f;
                            }
                        }
                    } else if (l == 22L || l == 45L || l == 31L) {
                        double d = 0.0;
                        double d5 = 0.0;
                        double d6 = 0.0;
                        if (this.minObj != null && this.minLen == 1) {
                            d = ((double[])this.minObj)[0];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            d5 = ((double[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            d6 = ((double[])this.filObj)[0];
                        }
                        for (int i = 0; i < (int)lArray[n2 - 2]; ++i) {
                            objectArray = (double[])Array.get(objectArray2[n2 - 2], i);
                            for (int j = 0; j < (int)lArray[n2 - 1]; ++j) {
                                bl = true;
                                double d7 = ((double[])objectArray)[j];
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (d7 < d) {
                                            bl = false;
                                            ((double[])objectArray)[j] = this.filObj != null ? d6 : 0.0;
                                        }
                                    } else if (((double[])this.minObj).length > j && d7 < ((double[])this.minObj)[j]) {
                                        bl = false;
                                        ((double[])objectArray)[j] = this.filObj != null ? d6 : 0.0;
                                    }
                                }
                                if (!bl || this.maxObj == null) continue;
                                if (this.maxLen == 1) {
                                    if (!(d7 > d5)) continue;
                                    if (this.filObj != null) {
                                        ((double[])objectArray)[j] = d6;
                                        continue;
                                    }
                                    ((double[])objectArray)[j] = 0.0;
                                    continue;
                                }
                                if (((double[])this.maxObj).length <= j || !(d7 > ((double[])this.maxObj)[j])) continue;
                                ((double[])objectArray)[j] = this.filObj != null ? d6 : 0.0;
                            }
                        }
                    } else if (l == 32L) {
                        double[] dArray = new double[]{0.0, 0.0};
                        double[] dArray5 = new double[]{0.0, 0.0};
                        double[] dArray6 = new double[]{0.0, 0.0};
                        if (this.minObj != null && this.minLen == 1) {
                            dArray[0] = ((double[])this.minObj)[0];
                            dArray[1] = ((double[])this.minObj)[1];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            dArray5[0] = ((double[])this.maxObj)[0];
                            dArray5[1] = ((double[])this.maxObj)[1];
                        }
                        if (this.filObj != null) {
                            dArray6[0] = ((double[])this.filObj)[0];
                            dArray6[1] = ((double[])this.filObj)[1];
                        }
                        for (n13 = 0; n13 < (int)lArray[n2 - 2]; ++n13) {
                            objectArray = (double[])Array.get(objectArray2[n2 - 2], n13);
                            for (int i = 0; i < (int)lArray[n2 - 1]; i += 2) {
                                bl = true;
                                double[] dArray7 = new double[]{((double[])objectArray)[2 * i], ((double[])objectArray)[2 * i + 1]};
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (dArray7[0] < dArray[0] || dArray7[0] == dArray[0] && dArray7[1] < dArray[1]) {
                                            bl = false;
                                            if (this.filObj != null) {
                                                ((double[])objectArray)[2 * i] = dArray6[0];
                                                ((double[])objectArray)[2 * i + 1] = dArray6[1];
                                            } else {
                                                ((double[])objectArray)[2 * i] = 0.0;
                                                ((double[])objectArray)[2 * i + 1] = 0.0;
                                            }
                                        }
                                    } else if (((double[])this.minObj).length > i && (dArray7[0] < ((double[])this.minObj)[2 * i] || dArray7[0] == ((double[])this.minObj)[2 * i] && dArray7[1] < ((double[])this.minObj)[2 * i + 1])) {
                                        bl = false;
                                        if (this.filObj != null) {
                                            ((double[])objectArray)[2 * i] = dArray6[0];
                                            ((double[])objectArray)[2 * i + 1] = dArray6[1];
                                        } else {
                                            ((double[])objectArray)[2 * i] = 0.0;
                                            ((double[])objectArray)[2 * i + 1] = 0.0;
                                        }
                                    }
                                }
                                if (bl && this.maxObj != null) {
                                    if (this.maxLen != 1 || !(dArray7[0] > dArray5[0]) && (dArray7[0] != dArray5[0] || !(dArray7[1] > dArray5[1]))) continue;
                                    if (this.filObj != null) {
                                        ((double[])objectArray)[2 * i] = dArray6[0];
                                        ((double[])objectArray)[2 * i + 1] = dArray6[1];
                                        continue;
                                    }
                                    ((double[])objectArray)[2 * i] = 0.0;
                                    ((double[])objectArray)[2 * i + 1] = 0.0;
                                    continue;
                                }
                                if (((double[])this.maxObj).length <= i || !(dArray7[0] > ((double[])this.maxObj)[2 * i]) && (!(dArray7[0] > ((double[])this.maxObj)[2 * i]) || !(dArray7[1] > ((double[])this.maxObj)[2 * i + 1]))) continue;
                                if (this.filObj != null) {
                                    ((double[])objectArray)[2 * i] = dArray6[0];
                                    ((double[])objectArray)[2 * i + 1] = dArray6[1];
                                    continue;
                                }
                                ((double[])objectArray)[2 * i] = 0.0;
                                ((double[])objectArray)[2 * i + 1] = 0.0;
                            }
                        }
                    }
                }
                n = (int)((long)n + lArray[n2 - 1]);
            }
        }
        return object;
    }

    private long product(long[] lArray, int n, int n2) {
        long l = 1L;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] <= 1L) continue;
            l *= lArray[i];
        }
        return l;
    }

    protected BuildProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    class CleanProgress
    extends Thread {
        CleanProgress() {
        }

        @Override
        public void run() {
            ExportCreateCDF.this.progressPanel.dispose();
            ExportCreateCDF.this.progressPanel = null;
            if (((ExportCreateCDF)ExportCreateCDF.this).myCDFExport.MacOS) {
                System.gc();
            }
        }
    }
}

