/*****************************************************************************e
*
*  NSSDC/CDF                      Quick Start Test Program(C# interface).
*
*  Version 1.0,15-Oct-09,Mike Liu
*
*  Modification history:
*
*   V1.0   15-Oct-09,M Liu     Original version(for CDF V3.3).
*                              Using pointers (&) to pass arguments for 
*                              retrieving data fields and values to C# APIs.
*
******************************************************************************/

using System;
using System.Runtime.InteropServices;
using CDF;

public class Qst2 : CDFAPIs {

unsafe public static void Main(string[] args) {
  void* id;
  int status;

  int[]  indices = new int[1] {0};
  int[]  counts1 = new int[1] { 1 };
  int[]  counts2 = new int[1] { 2 };
  int[]  intervals = new int[1] { 1 };
  string strings1a="a";
  string[] strings1b={"abc","  abc"};
  string[] strings2a={"abc","  abc"};
  string[,] strings2b = {{"111", " 123"},{"12345", "1 2 3"}};
  string entry1 = "entry1", entry2 = "entry2";

id = (void *) 0;
try {
status = CDFopen(args[0],&id);

/******************************************************************************
* HyperGET from variables.
******************************************************************************/
status = CDFputzVarPadValue(id, 0, "");
status = CDFputzVarPadValue(id, 1, "xyz");

status = CDFhyperPutzVarData(id,0,0,1,1,
                             indices,counts1,intervals,strings1a);
status = CDFhyperPutzVarData(id,0,1,2,1,
                             indices,counts1,intervals,strings1b);

status = CDFhyperPutzVarData(id,1,0,1,1,
                             indices,counts2,intervals,strings2a);
status = CDFhyperPutzVarData(id,1,1,2,1,
                             indices,counts2,intervals,strings2b);

status = CDFputAttrzEntry(id,0,0, CDF_CHAR, 6, entry1);

status = CDFputAttrzEntry(id,0,1, CDF_CHAR, 6, entry2);

status = CDFcloseCDF(id);  


/******************************************************************************
* Successful completion.
******************************************************************************/
} catch(CDFException ex) {
  Console.WriteLine("Error... "+ex);
} finally {
  try {
    status = CDFselect(id);
    status = CDFcloseCDF(id);
  } catch(CDFException ex) {}
}

}


/******************************************************************************
* QuitCDF.
******************************************************************************/

unsafe static void QuitCDF(string where, int status, void* id)
{
  string text;
  Console.WriteLine("Aborting at "+where);
  if(status < 0) {
    status = CDFgetStatusText(status,out text); 
    Console.WriteLine(" "+text);
  }
  status = CDFcloseCDF(id);
  Console.WriteLine("...test aborted.");
}

}

