/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;

public class StringArray
extends AArray {
    public StringArray(Object object) throws Throwable {
        super(object);
    }

    public StringArray(Object object, boolean bl) throws Throwable {
        super(object, bl);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                String[] stringArray = (String[])this.o;
                return (String[])this.o;
            }
            case 2: {
                return (String[][])this.o;
            }
            case 3: {
                return (String[][][])this.o;
            }
            case 4: {
                return (String[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> clazz, int n) throws Throwable {
        if (clazz != String.class) {
            throw new Throwable("Valid for String type only");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        ByteBuffer byteBuffer = this.allocate(n);
        int[] nArray = this.aa.getDimensions();
        switch (this.dim) {
            case 1: {
                String[] stringArray = (String[])this.o;
                this.addString(byteBuffer, stringArray, n);
                byteBuffer.flip();
                return byteBuffer;
            }
            case 2: {
                String[][] stringArray = (String[][])this.o;
                for (int i = 0; i < nArray[0]; ++i) {
                    this.addString(byteBuffer, stringArray[i], n);
                }
                byteBuffer.flip();
                return byteBuffer;
            }
            case 3: {
                String[][][] stringArray = (String[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            this.addString(byteBuffer, stringArray[i][j], n);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                this.addString(byteBuffer, stringArray[i][k][j], n);
                            }
                        }
                    }
                }
                byteBuffer.flip();
                return byteBuffer;
            }
            case 4: {
                String[][][][] stringArray = (String[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                this.addString(byteBuffer, stringArray[i][j][k], n);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                    this.addString(byteBuffer, stringArray[i][i2][k][j], n);
                                }
                            }
                        }
                    }
                }
                byteBuffer.flip();
                return byteBuffer;
            }
        }
        return null;
    }

    void addString(ByteBuffer byteBuffer, String[] stringArray, int n) throws Throwable {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addString(byteBuffer, stringArray[i], n);
        }
    }

    void addString(ByteBuffer byteBuffer, String string, int n) throws Throwable {
        int n2 = string.length();
        if (n2 > n) {
            throw new Throwable("String " + string + " is longer than the specified max " + n);
        }
        byte[] byArray = string.getBytes();
        byteBuffer.put(byArray);
        for (int i = 0; i < n - byArray.length; ++i) {
            byteBuffer.put((byte)32);
        }
    }
}

