/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditgEntryTablePanel
extends JPanel
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private Attribute selectedAttr;
    private EditgEntryTablePanel aTablePanel = this;
    private MYEditor myEditor;
    private JTable table;
    private MyTableModel myModel;
    private JScrollPane scrollPane;
    private Object[][] dataObject = null;
    private static String[] headcol = new String[]{"Entry", "Data Type", "Entry Data"};

    EditgEntryTablePanel(EditAttrEntryPanel editAttrEntryPanel) {
        this.myEditor = editAttrEntryPanel.getMyEditor();
        this.selectedAttr = editAttrEntryPanel.getSelectedAttr();
        this.scrollPane = new JScrollPane(21, 30);
    }

    public void buildTable(Attribute attribute) {
        this.selectedAttr = attribute;
        if (attribute != null) {
            this.buildDataTable();
        }
        if (this.dataObject != null) {
            this.myModel = new MyTableModel();
            this.table = new JTable(this.myModel);
            this.table.setPreferredScrollableViewportSize(new Dimension(520, 210));
            this.table.setRowSelectionAllowed(false);
            this.table.sizeColumnsToFit(4);
            TableColumn tableColumn = null;
            for (int i = 0; i < headcol.length; ++i) {
                tableColumn = this.table.getColumnModel().getColumn(i);
                tableColumn.setResizable(true);
                if (i == 0) {
                    tableColumn.setPreferredWidth(40);
                }
                if (i == 1) {
                    tableColumn.setPreferredWidth(110);
                }
                if (i != 2) continue;
                tableColumn.setPreferredWidth(370);
            }
            this.table.setCellSelectionEnabled(false);
            this.scrollPane.setViewportView(this.table);
            this.aTablePanel.removeAll();
            this.aTablePanel.revalidate();
            this.aTablePanel.repaint();
            this.aTablePanel.add((Component)this.scrollPane, "Center");
        }
    }

    public void setTable(Object[][] objectArray) {
        this.dataObject = objectArray;
        this.myModel.fireTableChanged(new TableModelEvent(this.myModel));
    }

    public Object[][] getTable() {
        return this.dataObject;
    }

    public void setColumnNames(String[] stringArray) {
        headcol = stringArray;
    }

    public String[] getColumnNames() {
        return headcol;
    }

    public void setUpDataTypeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("CDF_BYTE");
        jComboBox.addItem("CDF_INT1");
        jComboBox.addItem("CDF_UINT1");
        jComboBox.addItem("CDF_INT2");
        jComboBox.addItem("CDF_UINT2");
        jComboBox.addItem("CDF_INT4");
        jComboBox.addItem("CDF_UINT4");
        jComboBox.addItem("CDF_INT8");
        jComboBox.addItem("CDF_REAL4");
        jComboBox.addItem("CDF_FLOAT");
        jComboBox.addItem("CDF_REAL8");
        jComboBox.addItem("CDF_DOUBLE");
        jComboBox.addItem("CDF_EPOCH");
        jComboBox.addItem("CDF_EPOCH16");
        jComboBox.addItem("CDF_TIME_TT2000");
        jComboBox.addItem("CDF_CHAR");
        jComboBox.addItem("CDF_UCHAR");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click for valid data types");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Click the dataType to see a list of choices");
        }
    }

    private void buildDataTable() {
        Vector vector;
        try {
            vector = this.selectedAttr.getEntries();
        }
        catch (CDFException cDFException) {
            vector = null;
        }
        this.dataObject = null;
        if (vector != null) {
            Entry entry = null;
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entry = (Entry)enumeration.nextElement();
                if (entry == null) continue;
                ++n;
            }
            if (n == 0) {
                this.dataObject = null;
                return;
            }
            this.dataObject = new Object[n][headcol.length];
            Object object = null;
            int n2 = -1;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Object object2;
                int n3;
                StringBuffer stringBuffer;
                entry = (Entry)enumeration2.nextElement();
                if (entry == null) continue;
                ++n2;
                long l = entry.getDataType();
                long l2 = entry.getNumElements();
                try {
                    object = entry.getData();
                }
                catch (CDFException cDFException) {
                    // empty catch block
                }
                this.dataObject[n2][0] = "" + (entry.getID() + 1L);
                this.dataObject[n2][1] = CDFUtils.getStringDataType(l) + "/" + l2;
                if (l == 31L) {
                    if (object.getClass().getName().indexOf(91) == 0) {
                        stringBuffer = new StringBuffer();
                        for (n3 = 0; n3 < ((double[])object).length; ++n3) {
                            if (n3 > 0) {
                                stringBuffer.append(", ");
                            }
                            object2 = Epoch.encode4(((double[])object)[n3]);
                            stringBuffer.append((String)object2);
                        }
                        this.dataObject[n2][2] = stringBuffer.toString();
                        continue;
                    }
                    this.dataObject[n2][2] = Epoch.encode4((Double)object);
                    continue;
                }
                if (l == 32L) {
                    if (object.getClass().getName().indexOf(91) != 0) continue;
                    stringBuffer = new StringBuffer();
                    for (n3 = 0; n3 < ((double[])object).length; n3 += 2) {
                        if (n3 > 0) {
                            stringBuffer.append(", ");
                        }
                        object2 = new double[2];
                        object2[0] = ((double[])object)[n3];
                        object2[1] = ((double[])object)[n3 + 1];
                        String string = Epoch16.encode4(object2);
                        stringBuffer.append(string);
                    }
                    this.dataObject[n2][2] = stringBuffer.toString();
                    continue;
                }
                if (l == 33L) {
                    if (object.getClass().getName().indexOf(91) == 0) {
                        stringBuffer = new StringBuffer();
                        for (n3 = 0; n3 < ((long[])object).length; ++n3) {
                            if (n3 > 0) {
                                stringBuffer.append(", ");
                            }
                            object2 = CDFTT2000.toUTCstring(((long[])object)[n3]);
                            stringBuffer.append((String)object2);
                        }
                        this.dataObject[n2][2] = stringBuffer.toString();
                        continue;
                    }
                    this.dataObject[n2][2] = CDFTT2000.toUTCstring((long)((Long)object));
                    continue;
                }
                this.dataObject[n2][2] = CDFUtils.getStringData(object, ",");
            }
        }
    }

    public void reset() {
        if (this.dataObject != null) {
            this.aTablePanel.setVisible(true);
            this.setTable(this.dataObject);
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    class MyTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1L;

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return headcol.length;
        }

        @Override
        public int getRowCount() {
            if (EditgEntryTablePanel.this.dataObject != null) {
                return EditgEntryTablePanel.this.dataObject.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return headcol[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (EditgEntryTablePanel.this.dataObject != null) {
                return EditgEntryTablePanel.this.dataObject[n][n2];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (EditgEntryTablePanel.this.dataObject[0][n2] instanceof Integer) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = new Integer((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only integer values.");
                }
            } else if (EditgEntryTablePanel.this.dataObject[0][n2] instanceof Float) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = new Float((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only float values.");
                }
            } else if (EditgEntryTablePanel.this.dataObject[0][n2] instanceof Byte) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = new Byte((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only yyte values.");
                }
            } else if (EditgEntryTablePanel.this.dataObject[0][n2] instanceof Long) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = new Long((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only long values.");
                }
            } else if (EditgEntryTablePanel.this.dataObject[0][n2] instanceof Short) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = new Short((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only short values.");
                }
            } else if (EditgEntryTablePanel.this.dataObject[0][n2] instanceof Double) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = new Double((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only double values.");
                }
            } else if (EditgEntryTablePanel.this.dataObject[0][n2] instanceof Boolean) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = (Boolean)object;
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only boolean values.");
                }
            } else {
                if (n2 == 1) {
                    this.applyValue(object2, object, n, n2);
                }
                if (n2 == 2) {
                    object = this.checkValue(object, n);
                }
                ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        void applyValue(Object object, Object object2, int n, int n2) {
            if (!((String)object).equals((String)object2) && (((String)object2).equals("CDF_CHAR") || ((String)object2).equals("CDF_UCHAR"))) {
                JOptionPane.showMessageDialog(((EditgEntryTablePanel)EditgEntryTablePanel.this).myEditor.frame, "The data type changed from " + object + " to " + object2 + ". Please change entry value accordingly.");
            }
        }

        void checkNumElem(Object object, int n) {
            String string = (String)this.getValueAt(n, 1);
            ((EditgEntryTablePanel)EditgEntryTablePanel.this).dataObject[n][2] = string.equals("CDF_CHAR") && string.equals("CDF_UCHAR") ? "" + ((String)object).length() : "1";
            this.fireTableCellUpdated(n, 3);
        }

        Object checkValue(Object object, int n) {
            String string = (String)this.getValueAt(n, 1);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (string.equals("CDF_BYTE") || string.equals("CDF_INT1")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Byte) {
                        return new Byte(numberFormat.parse(((Byte)object).toString()).byteValue());
                    }
                    return "" + numberFormat.parse((String)object).byteValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_UINT1") || string.equals("CDF_INT2")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Short) {
                        return new Short(numberFormat.parse(((Short)object).toString()).shortValue());
                    }
                    return "" + numberFormat.parse((String)object).shortValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_UINT2") || string.equals("CDF_INT4")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Integer) {
                        return new Integer(numberFormat.parse(((Integer)object).toString()).intValue());
                    }
                    return "" + numberFormat.parse((String)object).intValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_UINT4") || string.equals("CDF_INT8")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Long) {
                        return new Long(numberFormat.parse(((Long)object).toString()).longValue());
                    }
                    return "" + numberFormat.parse((String)object).longValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_REAL4") || string.equals("CDF_FLOAT")) {
                numberFormat.setParseIntegerOnly(false);
                try {
                    if (object instanceof Float) {
                        return new Float(numberFormat.parse(((Float)object).toString()).floatValue());
                    }
                    return "" + numberFormat.parse((String)object).floatValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_REAL8") || string.equals("CDF_EPOCH")) {
                numberFormat.setParseIntegerOnly(false);
                try {
                    if (object instanceof Double) {
                        return new Double(numberFormat.parse(((Double)object).toString()).doubleValue());
                    }
                    return "" + numberFormat.parse((String)object).doubleValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_EPOCH16")) {
                numberFormat.setParseIntegerOnly(false);
                try {
                    return "" + numberFormat.parse((String)object);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_CHAR") || string.equals("CDF_UCHAR")) {
                return object;
            }
            return null;
        }
    }
}

