/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExportCDFTable
extends JDialog
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private int varNum;
    private Entry[] entries;
    private JFrame myFrame;
    private JPanel mp;
    private JPanel bp;
    private JPanel bpX;
    private CDFSpecPanel cdfspec;
    private JTabbedPane jtp;
    private JCheckBox avc1;
    private JCheckBox avc2;
    private CDFExport myCDFExport;
    private ExportVarListTable aVarListTable;
    private ExportVarFilterTable aVarFilterTable;
    private static ExportCDFTable aCDFTable;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JPanel buttonPanel;
    private String fileName;
    private static Boolean outputT;
    private static Boolean outputF;
    private JButton enterButton;
    private JButton cancelButton;
    private JButton resetButton;
    private String[] columnNames1 = null;
    protected String[] columnNames2 = null;
    private Object[][] dataObject = null;
    private Object[][] filterObject = null;
    private Object[][] filterInitialObject = null;
    private Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
    private static String[] headcol;
    private static String[] headfil;
    protected static String headrow1;
    protected static String headrow2;
    protected static String na;
    protected int numColumns1 = 0;
    protected int numRows = 0;
    protected int numColumns2 = 0;
    protected Hashtable myHash = new Hashtable();
    protected int istart = 0;
    private boolean fromRESET;
    static boolean defaultModal;
    private static final String ENTER = "Continue";
    private static final String RESET = "Reset";
    private static final String CANCEL = "Cancel";

    private ExportCDFTable(JFrame jFrame, CDFExport cDFExport) {
        this(jFrame, cDFExport, defaultModal);
    }

    private ExportCDFTable(JFrame jFrame, CDFExport cDFExport, boolean bl) {
        super((Frame)jFrame, bl);
        this.myFrame = jFrame;
        aCDFTable = this;
        this.myCDFExport = cDFExport;
    }

    public static ExportCDFTable createCDFTable(JFrame jFrame, CDFExport cDFExport, String string) {
        if (aCDFTable == null) {
            aCDFTable = new ExportCDFTable(jFrame, cDFExport);
            aCDFTable.setDefaultCloseOperation(0);
            aCDFTable.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                }
            });
            aCDFTable.getContentPane().setLayout(new BorderLayout());
            ExportCDFTable.aCDFTable.mp = (JPanel)aCDFTable.getContentPane();
            ExportCDFTable.aCDFTable.bp = new JPanel(new BorderLayout(), true);
            ExportCDFTable.aCDFTable.mp.setBorder(new EmptyBorder(10, 10, 10, 10));
            ExportCDFTable.aCDFTable.cdfspec = new CDFSpecPanel();
        } else {
            ExportCDFTable.aCDFTable.mp.removeAll();
        }
        ExportCDFTable.aCDFTable.fileName = string;
        aCDFTable.buildPanel();
        aCDFTable.setSize(aCDFTable.getPreferredSize());
        aCDFTable.pack();
        Dimension dimension = aCDFTable.getSize();
        aCDFTable.setLocation(ExportCDFTable.aCDFTable.ss.width / 2 - dimension.width / 2, ExportCDFTable.aCDFTable.ss.height / 2 - dimension.height / 2);
        aCDFTable.setVisible(true);
        return aCDFTable;
    }

    private void buildPanel() {
        aCDFTable.setTitle("Variable Selection for CDF: " + this.fileName);
        this.cdfspec.set(this.myCDFExport.sourceCDF);
        this.mp.add((Component)this.cdfspec, "North");
        this.buildDataTable();
        this.aVarListTable = ExportVarListTable.createVarListTable(this.dataObject, this.columnNames1, this.myCDFExport, aCDFTable);
        if (this.scrollPane1 == null) {
            this.scrollPane1 = new JScrollPane(this.aVarListTable.getTable());
        } else {
            this.scrollPane1.setViewportView(this.aVarListTable.getTable());
        }
        if (this.numColumns2 > 0) {
            this.aVarFilterTable = new ExportVarFilterTable(this.myFrame, this.filterObject, this.columnNames2, aCDFTable);
            if (this.jtp == null) {
                this.jtp = new JTabbedPane();
                this.jtp.addChangeListener(new TabChangeListener());
                this.scrollPane2 = new JScrollPane(this.aVarFilterTable.getTable());
            } else {
                this.jtp.removeTabAt(1);
                this.jtp.removeTabAt(0);
                this.scrollPane2.setViewportView(this.aVarFilterTable.getTable());
            }
            this.jtp.addTab("Output", null, this.scrollPane1, "Variable list and description");
            this.jtp.addTab("Filtering", null, this.scrollPane2, "Filtering information");
            this.mp.add((Component)this.jtp, "Center");
        } else {
            this.mp.add((Component)this.scrollPane1, "Center");
        }
        this.createCBUIs(this.bp);
        this.createButtons(this.bp);
        this.mp.add((Component)this.bp, "South");
    }

    public void reEnter() {
        if (this.myCDFExport.getFilterChanged()) {
            this.myCDFExport.setFilterChanged(false);
            this.numColumns2 = 0;
            if (this.myCDFExport.getFiltering() == 1) {
                if (this.myCDFExport.getValidMin() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getValidMax() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getFillVal() == 1) {
                    ++this.numColumns2;
                }
                if (this.numColumns2 > 0) {
                    ++this.numColumns2;
                }
            }
            if (this.numColumns2 > 0) {
                this.setupFiltering();
                this.aVarFilterTable = new ExportVarFilterTable(this.myFrame, this.filterObject, this.columnNames2, aCDFTable);
                if (this.jtp == null) {
                    this.jtp = new JTabbedPane();
                    this.jtp.addChangeListener(new TabChangeListener());
                    this.scrollPane2 = new JScrollPane(this.aVarFilterTable.getTable());
                } else {
                    this.jtp.removeTabAt(1);
                    this.jtp.removeTabAt(0);
                    this.scrollPane2.setViewportView(this.aVarFilterTable.getTable());
                }
                this.jtp.addTab("Output", null, this.scrollPane1, "Variable list and description");
                this.jtp.addTab("Filtering", null, this.scrollPane2, "Filtering information");
                this.mp.removeAll();
                this.mp.add((Component)this.cdfspec, "North");
                this.mp.add((Component)this.jtp, "Center");
                this.mp.add((Component)this.bp, "South");
            } else {
                this.filterObject = null;
                this.filterInitialObject = null;
                this.columnNames2 = null;
                this.aVarFilterTable = null;
                this.mp.removeAll();
                this.mp.add((Component)this.cdfspec, "North");
                this.mp.add((Component)this.scrollPane1, "Center");
                this.mp.add((Component)this.bp, "South");
            }
            aCDFTable.pack();
            aCDFTable.setSize(aCDFTable.getPreferredSize());
            Dimension dimension = aCDFTable.getSize();
            aCDFTable.setLocation((this.ss.width - dimension.width) / 2, (this.ss.height - dimension.height) / 2);
        } else {
            aCDFTable.pack();
            Dimension dimension = aCDFTable.getSize();
            aCDFTable.setLocation((this.ss.width - dimension.width) / 2, (this.ss.height - dimension.height) / 2);
        }
        aCDFTable.toFront();
        aCDFTable.show();
    }

    private void buildDataTable() {
        this.varNum = this.myCDFExport.vars.size();
        this.numColumns1 = Array.getLength(headcol);
        this.columnNames1 = new String[this.numColumns1];
        this.istart = this.myCDFExport.recordNum + this.myCDFExport.indiceNum;
        this.numRows = this.varNum + this.istart;
        for (int i = 0; i < this.numColumns1; ++i) {
            this.columnNames1[i] = headcol[i];
        }
        if (this.myCDFExport.getFilterChanged()) {
            this.myCDFExport.setFilterChanged(false);
            this.numColumns2 = 0;
            if (this.myCDFExport.getFiltering() == 1) {
                if (this.myCDFExport.getValidMin() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getValidMax() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getFillVal() == 1) {
                    ++this.numColumns2;
                }
                if (this.numColumns2 > 0) {
                    ++this.numColumns2;
                }
            }
        }
        this.dataObject = new Object[this.numRows][this.numColumns1];
        if (this.myCDFExport.recordNum == 1) {
            this.myHash.put(headrow1, new Integer(0));
            this.dataObject[0][0] = headrow1;
            this.dataObject[0][1] = na;
            this.dataObject[0][2] = na;
            this.dataObject[0][3] = na;
            this.dataObject[0][4] = na;
            this.dataObject[0][5] = this.myCDFExport.outSelection != 3 && this.myCDFExport.outSelection != 4 ? outputT : outputF;
        }
        if (this.myCDFExport.indiceNum == 1) {
            this.myHash.put(headrow2, new Integer(1));
            this.dataObject[this.myCDFExport.recordNum][0] = headrow2;
            this.dataObject[this.myCDFExport.recordNum][1] = na;
            this.dataObject[this.myCDFExport.recordNum][2] = na;
            this.dataObject[this.myCDFExport.recordNum][3] = na;
            this.dataObject[this.myCDFExport.recordNum][4] = na;
            this.dataObject[this.myCDFExport.recordNum][5] = this.myCDFExport.outSelection != 3 && this.myCDFExport.outSelection != 4 ? outputT : outputF;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String string = "LABL_PTR_";
        Variable variable = null;
        Enumeration enumeration = this.myCDFExport.vars.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            StringBuffer stringBuffer2;
            String string3;
            Object object;
            variable = (Variable)enumeration.nextElement();
            String string4 = variable.getName();
            try {
                object = variable.getEntryData("LABLAXIS");
                string3 = object.toString();
            }
            catch (CDFException cDFException) {
                string3 = null;
            }
            if (string3 == null) {
                int n2;
                stringBuffer2 = new StringBuffer();
                for (n2 = 1; n2 < Integer.MAX_VALUE; ++n2) {
                    object = string + n2;
                    try {
                        Object object2 = variable.getEntryData((String)object);
                        String string5 = object2.toString();
                        if (n2 > 1) {
                            stringBuffer2.append(" ");
                        }
                        stringBuffer2.append(string5);
                        continue;
                    }
                    catch (CDFException cDFException) {
                        break;
                    }
                }
                if (n2 > 1) {
                    string3 = stringBuffer2.toString();
                }
            }
            if (string3 == null) {
                string3 = " ";
            }
            try {
                object = variable.getEntryData("CATDESC");
                string2 = object.toString();
            }
            catch (CDFException cDFException) {
                string2 = " ";
            }
            object = variable.getDimSizes();
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(CDFUtils.getStringDataType(variable.getDataType()));
            stringBuffer2.append("/");
            String string6 = stringBuffer2.append(String.valueOf(variable.getNumElements())).toString();
            long l = variable.getNumDims();
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(l).append(":[");
            int n3 = 0;
            while ((long)n3 < l) {
                if (n3 > 0) {
                    stringBuffer3.append(",");
                }
                stringBuffer3.append((long)object[n3]);
                ++n3;
            }
            String string7 = stringBuffer3.append("]").toString();
            this.myHash.put(string4, new Integer(this.istart + n));
            this.dataObject[this.istart + n][0] = string4;
            this.dataObject[this.istart + n][1] = string3;
            this.dataObject[this.istart + n][2] = string2;
            this.dataObject[this.istart + n][3] = string6;
            this.dataObject[this.istart + n][4] = string7;
            this.dataObject[this.istart + n][5] = outputT;
            ++n;
        }
        if (this.numColumns2 > 0) {
            this.setupFiltering();
        }
    }

    private void setupFiltering() {
        this.filterObject = new Object[this.numRows][this.numColumns2];
        this.filterInitialObject = new Object[this.numRows][this.numColumns2];
        if (this.myCDFExport.recordNum == 1) {
            this.filterObject[0][0] = headrow1;
            this.filterInitialObject[0][0] = headrow1;
        }
        if (this.myCDFExport.indiceNum == 1) {
            this.filterObject[this.myCDFExport.recordNum][0] = headrow2;
            this.filterInitialObject[this.myCDFExport.recordNum][0] = headrow2;
        }
        int n = 1;
        if (this.myCDFExport.getValidMin() == 1) {
            if (this.myCDFExport.recordNum == 1) {
                this.filterObject[0][n] = na;
                this.filterInitialObject[0][n] = na;
            }
            if (this.myCDFExport.indiceNum == 1) {
                this.filterObject[this.myCDFExport.recordNum][n] = na;
                this.filterInitialObject[this.myCDFExport.recordNum][n] = na;
            }
            ++n;
        }
        if (this.myCDFExport.getValidMax() == 1) {
            if (this.myCDFExport.recordNum == 1) {
                this.filterObject[0][n] = na;
                this.filterInitialObject[0][n] = na;
            }
            if (this.myCDFExport.indiceNum == 1) {
                this.filterObject[this.myCDFExport.recordNum][n] = na;
                this.filterInitialObject[this.myCDFExport.recordNum][n] = na;
            }
            ++n;
        }
        if (this.myCDFExport.getFillVal() == 1) {
            if (this.myCDFExport.recordNum == 1) {
                this.filterObject[0][n] = na;
                this.filterInitialObject[0][n] = na;
            }
            if (this.myCDFExport.indiceNum == 1) {
                this.filterObject[this.myCDFExport.recordNum][n] = na;
                this.filterInitialObject[this.myCDFExport.recordNum][n] = na;
            }
        }
        this.columnNames2 = new String[this.numColumns2];
        this.columnNames2[0] = headfil[0];
        n = 1;
        if (this.myCDFExport.getValidMin() == 1) {
            this.columnNames2[n++] = headfil[1];
        }
        if (this.myCDFExport.getValidMax() == 1) {
            this.columnNames2[n++] = headfil[2];
        }
        if (this.myCDFExport.getFillVal() == 1) {
            this.columnNames2[n++] = headfil[3];
        }
        int n2 = 0;
        String string = null;
        Variable variable = null;
        Enumeration enumeration = this.myCDFExport.vars.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            Object object;
            variable = (Variable)enumeration.nextElement();
            string = variable.getName();
            long l = variable.getDataType();
            int n3 = l == 33L ? 3 : (l == 31L ? 1 : (l == 32L ? 2 : 0));
            n = 1;
            this.filterObject[this.istart + n2][0] = string;
            if (this.myCDFExport.getValidMin() == 1) {
                try {
                    object = variable.getEntryData("VALIDMIN");
                    string2 = CDFToolUtils.breakdownData(object, n3);
                    this.filterObject[this.istart + n2][n] = string2;
                    this.filterInitialObject[this.istart + n2][n++] = string2;
                }
                catch (CDFException cDFException) {
                    this.filterObject[this.istart + n2][n] = " ";
                    this.filterInitialObject[this.istart + n2][n++] = " ";
                }
            }
            if (this.myCDFExport.getValidMax() == 1) {
                try {
                    object = variable.getEntryData("VALIDMAX");
                    string2 = CDFToolUtils.breakdownData(object, n3);
                    this.filterObject[this.istart + n2][n] = string2;
                    this.filterInitialObject[this.istart + n2][n++] = string2;
                }
                catch (CDFException cDFException) {
                    this.filterObject[this.istart + n2][n] = " ";
                    this.filterInitialObject[this.istart + n2][n++] = " ";
                }
            }
            if (this.myCDFExport.getFillVal() == 1) {
                try {
                    object = variable.getEntryData("FILLVAL");
                    string2 = CDFToolUtils.breakdownData(object, n3);
                    this.filterObject[this.istart + n2][n] = string2;
                    this.filterInitialObject[this.istart + n2][n] = string2;
                }
                catch (CDFException cDFException) {
                    this.filterObject[this.istart + n2][n] = " ";
                    this.filterInitialObject[this.istart + n2][n] = " ";
                }
            }
            ++n2;
        }
    }

    private void createCBUIs(JPanel jPanel) {
        if (this.avc1 == null) {
            this.avc1 = new JCheckBox("Select all variables", true);
            this.avc2 = new JCheckBox("Deselect all variables", false);
            OptionsListener optionsListener = new OptionsListener();
            this.avc1.addActionListener(optionsListener);
            this.avc1.setToolTipText("Select all variables for export");
            this.avc2.addActionListener(optionsListener);
            this.avc2.setToolTipText("Deselect all variables for export");
            this.bpX = new JPanel(new GridLayout(2, 3), true);
            this.bpX.add(this.avc1);
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            this.bpX.add(this.avc2);
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            jPanel.add((Component)this.bpX, "North");
        }
    }

    private void createButtons(JPanel jPanel) {
        if (this.enterButton == null) {
            this.enterButton = new JButton(ENTER);
            this.resetButton = new JButton(RESET);
            this.cancelButton = new JButton(CANCEL);
            this.buttonPanel = new JPanel(true);
            this.buttonPanel.add(this.enterButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(20, 1)));
            this.buttonPanel.add(this.resetButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(20, 1)));
            this.buttonPanel.add(this.cancelButton);
            SelectionListener selectionListener = new SelectionListener();
            this.enterButton.addActionListener(selectionListener);
            this.resetButton.addActionListener(selectionListener);
            this.cancelButton.addActionListener(selectionListener);
            this.enterButton.setToolTipText("Continue to the next step ...");
            this.resetButton.setToolTipText("Reset the selections to their defaults...");
            this.cancelButton.setToolTipText("Stop but keep the selections and retrun to the previous step...");
            jPanel.add((Component)this.buttonPanel, "South");
        }
    }

    private void reset() {
        for (int i = 0; i < this.numRows; ++i) {
            this.dataObject[i][5] = outputT;
            this.aVarListTable.getModel().setValueAt(outputT, i, 5);
            if (!this.fromRESET || this.numColumns2 <= 0) continue;
            for (int j = 1; j < this.numColumns2; ++j) {
                this.filterObject[i][j] = this.filterInitialObject[i][j];
                this.aVarFilterTable.getModel().setValueAt(this.filterObject[i][j], i, j);
            }
        }
    }

    private void deselect() {
        for (int i = this.istart; i < this.numRows; ++i) {
            this.dataObject[i][5] = outputF;
            this.aVarListTable.getModel().setValueAt(outputF, i, 5);
        }
    }

    public Object[][] getDataObject() {
        return this.dataObject;
    }

    public Object[][] getFilterObject() {
        return this.filterObject;
    }

    public JCheckBox getSelectAllCB() {
        return this.avc1;
    }

    public JCheckBox getDeSelectAllCB() {
        return this.avc2;
    }

    static {
        outputT = new Boolean(true);
        outputF = new Boolean(false);
        headcol = new String[]{"Item/Variable", "Description", "CATDESC", "DataType", "Dimension", "Output"};
        headfil = new String[]{"Item/Variable", "VALIDMIN", "VALIDMAX", "FILLVAL"};
        headrow1 = "<Record #>";
        headrow2 = "<Indices>";
        na = "N/A";
        defaultModal = true;
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (((JTabbedPane)object).getSelectedIndex() != 0) {
                ExportCDFTable.this.avc1.setEnabled(false);
                ExportCDFTable.this.avc2.setEnabled(false);
            } else {
                if (ExportCDFTable.this.avc1 != null) {
                    ExportCDFTable.this.avc1.setEnabled(true);
                }
                if (ExportCDFTable.this.avc2 != null) {
                    ExportCDFTable.this.avc2.setEnabled(true);
                }
            }
        }
    }

    class SelectionListener
    implements ActionListener {
        SelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                String string = actionEvent.getActionCommand();
                if (string.equals(ExportCDFTable.CANCEL)) {
                    aCDFTable.setVisible(false);
                    if (((ExportCDFTable)ExportCDFTable.this).myCDFExport.MacOS) {
                        System.gc();
                    }
                } else if (string.equals(ExportCDFTable.ENTER)) {
                    aCDFTable.setVisible(false);
                    if (ExportCDFTable.this.numColumns2 > 0) {
                        ExportCDFTable.this.aVarFilterTable.getTable().editingStopped(new ChangeEvent(ExportCDFTable.this.aVarFilterTable));
                    }
                    if (((ExportCDFTable)ExportCDFTable.this).myCDFExport.outSelection == 3 || ((ExportCDFTable)ExportCDFTable.this).myCDFExport.outSelection == 4) {
                        ExportCreateCDF exportCreateCDF = new ExportCreateCDF(ExportCDFTable.this.myCDFExport, aCDFTable);
                        new Thread(exportCreateCDF).start();
                    } else {
                        boolean bl = ((ExportCDFTable)ExportCDFTable.this).myCDFExport.outSelection == 1;
                        ExportToText exportToText = ExportToText.createToText(ExportCDFTable.this.myFrame, ExportCDFTable.this.myCDFExport, aCDFTable, bl);
                    }
                } else if (string.equals(ExportCDFTable.RESET)) {
                    ExportCDFTable.this.fromRESET = true;
                    ExportCDFTable.this.reset();
                }
            }
        }
    }

    class OptionsListener
    implements ActionListener {
        OptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ExportCDFTable.this.avc1) {
                if (ExportCDFTable.this.avc1.isSelected()) {
                    ExportCDFTable.this.avc2.setSelected(false);
                    ExportCDFTable.this.fromRESET = false;
                    ExportCDFTable.this.reset();
                }
            } else if (object == ExportCDFTable.this.avc2 && ExportCDFTable.this.avc2.isSelected()) {
                ExportCDFTable.this.avc1.setSelected(false);
                ExportCDFTable.this.deselect();
                ExportCDFTable.this.avc2.setSelected(true);
            }
        }
    }
}

