/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.SparseRecordOption;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class VDR {
    ByteBuffer record = ByteBuffer.allocate(344);
    long vDRNext;
    long longMask = 0xFFFFFFFFL;
    byte[] padValues;
    protected int position;
    String sname;
    int dataType;
    int maxRec = -1;
    long vXRHead;
    long vXRTail = -1L;
    int flags;
    int sRecords = 0;
    protected int numElems = 1;
    int num;
    long cPROffset;
    int blockingFactor;
    byte[] name = new byte[256];
    int zNumDims;
    ByteBuffer dimBuf;
    protected int itemsPerPoint = 1;
    protected Vector<Integer> efdim;

    public VDR(String string, int n, int[] nArray, boolean[] blArray, boolean bl, boolean bl2, Object object, int n2, SparseRecordOption sparseRecordOption) throws Throwable {
        this.sname = string;
        this.setName(string);
        this.setDataType(n);
        if (nArray.length != blArray.length) {
            throw new Throwable("Length of varys and dim arrays differ.");
        }
        this.numElems = n2;
        this.itemsPerPoint = n2;
        this.setDimensions(nArray, blArray, n);
        if (bl2) {
            this.flags |= 4;
        }
        if (bl) {
            this.flags |= 1;
        }
        this.setSparseRecordOption(sparseRecordOption);
        if (object != null) {
            Class<?> clazz = object.getClass();
            if (!clazz.isArray()) {
                throw new Throwable("Pad must be an array.");
            }
            Number[] numberArray = null;
            if (clazz.getComponentType() != String.class) {
                numberArray = new Number[1];
                if (clazz.getComponentType() == Double.TYPE) {
                    numberArray[0] = new Double(((double[])object)[0]);
                }
                if (clazz.getComponentType() == Float.TYPE) {
                    numberArray[0] = new Float(((float[])object)[0]);
                }
                if (clazz.getComponentType() == Integer.TYPE) {
                    numberArray[0] = new Integer(((int[])object)[0]);
                }
                if (clazz.getComponentType() == Long.TYPE) {
                    numberArray[0] = new Long(((long[])object)[0]);
                }
                if (clazz.getComponentType() == Short.TYPE) {
                    numberArray[0] = new Short(((short[])object)[0]);
                }
                if (clazz.getComponentType() == Byte.TYPE) {
                    numberArray[0] = new Byte(((byte[])object)[0]);
                }
            }
            int n3 = DataTypes.typeCategory[n];
            this.flags |= 2;
            ByteBuffer byteBuffer = null;
            if (n3 == 2 || n3 == 3) {
                if (DataTypes.size[n] == 4 && n3 == 3) {
                    int n4;
                    long[] lArray = new long[numberArray.length];
                    for (n4 = 0; n4 < lArray.length; ++n4) {
                        lArray[n4] = numberArray[n4].longValue();
                    }
                    byteBuffer = ByteBuffer.allocate(4 * lArray.length);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    for (n4 = 0; n4 < lArray.length; ++n4) {
                        byteBuffer.putInt((int)(lArray[n4] & this.longMask));
                    }
                    byteBuffer.position(0);
                } else {
                    int n5;
                    int[] nArray2 = new int[numberArray.length];
                    for (n5 = 0; n5 < nArray2.length; ++n5) {
                        nArray2[n5] = numberArray[n5].intValue();
                    }
                    byteBuffer = ByteBuffer.allocate(DataTypes.size[n] * nArray2.length);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    if (DataTypes.size[n] == 1) {
                        for (n5 = 0; n5 < nArray2.length; ++n5) {
                            byteBuffer.put((byte)(nArray2[n5] & 0xFF));
                        }
                    } else if (DataTypes.size[n] == 2) {
                        for (n5 = 0; n5 < nArray2.length; ++n5) {
                            byteBuffer.putShort((short)(nArray2[n5] & 0xFFFF));
                        }
                    } else {
                        byteBuffer.asIntBuffer().put(nArray2);
                    }
                }
            } else if (n3 == 0) {
                float[] fArray = new float[numberArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = numberArray[i].floatValue();
                }
                byteBuffer = ByteBuffer.allocate(4 * fArray.length);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.asFloatBuffer().put(fArray);
            } else if (n3 == 1) {
                double[] dArray = new double[numberArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = numberArray[i].doubleValue();
                }
                byteBuffer = ByteBuffer.allocate(8 * dArray.length);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.asDoubleBuffer().put(dArray);
            } else if (n3 == 5) {
                long[] lArray = new long[numberArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = numberArray[i].longValue();
                }
                byteBuffer = ByteBuffer.allocate(8 * lArray.length);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.asLongBuffer().put(lArray);
            } else {
                if (n3 != 4) {
                    throw new Throwable("Unrecognized type  pad value");
                }
                String[] stringArray = new String[]{((String[])object)[0]};
                int n6 = stringArray[0].length();
                byteBuffer = ByteBuffer.allocate(n6 *= stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        byteBuffer.put(stringArray[i].getBytes());
                    }
                    catch (Exception exception) {
                        throw new Throwable("encoding");
                    }
                    byteBuffer.position(0);
                }
            }
            this.padValues = new byte[byteBuffer.limit()];
            byteBuffer.position(0);
            byteBuffer.get(this.padValues);
        }
    }

    public VDR(String string, int n, int[] nArray, boolean[] blArray, boolean bl) throws Throwable {
        this(string, n, nArray, blArray, true, bl, null, 1, SparseRecordOption.NONE);
    }

    public VDR(String string, int n, int[] nArray, boolean[] blArray) throws Throwable {
        this(string, n, nArray, blArray, false);
    }

    public void setVDRNext(long l) {
        this.vDRNext = l;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public void setMaxRec(int n) {
        this.maxRec = n;
    }

    public void setVXRHead(long l) {
        this.vXRHead = l;
    }

    public void setVXRTail(long l) {
        this.vXRTail = l;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public boolean isCompressed() {
        return (this.flags & 4) != 0;
    }

    public void setSparseRecordOption(SparseRecordOption sparseRecordOption) {
        this.sRecords = sparseRecordOption.getValue();
    }

    public void setNumElems(int[] nArray, boolean[] blArray) {
        this.numElems = 1;
    }

    public void setNum(int n) {
        this.num = n;
    }

    public int getNum() {
        return this.num;
    }

    public void setCPROffset(long l) {
        this.cPROffset = l;
    }

    public void setBlockingFactor(int n) {
        this.blockingFactor = n;
    }

    public void setName(String string) {
        int n;
        byte[] byArray = string.getBytes();
        for (n = 0; n < byArray.length; ++n) {
            this.name[n] = byArray[n];
        }
        while (n < this.name.length) {
            this.name[n] = 0;
            ++n;
        }
    }

    public void setDimensions(int[] nArray, boolean[] blArray, int n) {
        int n2;
        this.zNumDims = nArray.length;
        if (n == 32) {
            this.itemsPerPoint = 2;
            this.zNumDims = 0;
        }
        this.efdim = new Vector();
        if (this.zNumDims == 0) {
            return;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (!blArray[n2]) continue;
            this.itemsPerPoint *= nArray[n2];
        }
        this.dimBuf = ByteBuffer.allocate(4 * this.zNumDims * 2);
        for (n2 = 0; n2 < this.zNumDims; ++n2) {
            this.dimBuf.putInt(nArray[n2]);
        }
        for (n2 = 0; n2 < this.zNumDims; ++n2) {
            this.dimBuf.putInt(blArray[n2] ? -1 : 0);
            if (!blArray[n2]) continue;
            this.efdim.add(new Integer(nArray[n2]));
        }
        this.dimBuf.position(0);
    }

    public ByteBuffer get() {
        int n = this.record.capacity();
        if (this.padValues != null) {
            n += this.padValues.length;
        }
        if (this.zNumDims > 0) {
            n += this.dimBuf.capacity();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.record.position(0);
        this.record.putLong(n);
        this.record.putInt(8);
        this.record.putLong(this.vDRNext);
        this.record.putInt(this.dataType);
        this.record.putInt(this.maxRec);
        this.record.putLong(this.vXRHead);
        this.record.putLong(this.vXRTail < 0L ? this.vXRHead : this.vXRTail);
        this.record.putInt(this.flags);
        this.record.putInt(this.sRecords);
        this.record.putInt(0);
        this.record.putInt(-1);
        this.record.putInt(-1);
        this.record.putInt(this.numElems);
        this.record.putInt(this.num);
        this.record.putLong(this.cPROffset);
        this.record.putInt(this.blockingFactor);
        this.record.put(this.name);
        this.record.putInt(this.zNumDims);
        this.record.position(0);
        byteBuffer.put(this.record);
        if (this.zNumDims > 0) {
            byteBuffer.put(this.dimBuf);
        }
        if (this.padValues != null) {
            byteBuffer.put(this.padValues);
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    public int getSize() {
        int n = this.record.capacity();
        if (this.zNumDims > 0) {
            n += this.dimBuf.capacity();
        }
        if (this.padValues != null) {
            n += this.padValues.length;
        }
        return n;
    }

    public String getName() {
        return this.sname;
    }
}

