/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDF2;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;

final class CDF2Impl
extends CDFImpl
implements CDF2,
Serializable {
    public int GDROffset;
    public int VAR_OFFSET_NAME;
    public int OFFSET_zNumDims;
    public int VAR_OFFSET_NUM_ELEMENTS;
    public int OFFSET_NUM;
    FileChannel fc;

    public CDF2Impl(ByteBuffer byteBuffer, int n, FileChannel fileChannel) throws Throwable {
        super(byteBuffer);
        this.fc = fileChannel;
        if (n < 5) {
            this.VAR_OFFSET_NAME = 192;
            this.VAR_OFFSET_NUM_ELEMENTS = 176;
            this.OFFSET_NUM = 180;
        } else {
            this.VAR_OFFSET_NAME = 64;
            this.VAR_OFFSET_NUM_ELEMENTS = 48;
            this.OFFSET_NUM = 52;
        }
        this.OFFSET_zNumDims = this.VAR_OFFSET_NAME + 64;
        this.setOffsets();
        this.thisCDF = this;
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = this.getRecord(0L);
        intBuffer.position(2);
        int n2 = intBuffer.get();
        intBuffer.position(3);
        int n3 = intBuffer.get();
        this.GDROffset = intBuffer.get();
        this.version = intBuffer.get();
        if (this.version != 2) {
            throw new Throwable("Version " + this.version + "is not accepted by this reader.");
        }
        n = intBuffer.get();
        this.encoding = intBuffer.get();
        this.byteOrder = DataTypes.getByteOrder(this.encoding);
        this.setByteOrder(this.byteOrder);
        this.flags = intBuffer.get();
        intBuffer.get();
        intBuffer.get();
        this.increment = intBuffer.get();
        int n4 = this.GDROffset + 4;
        byteBuffer.position(n4);
        int n5 = byteBuffer.getInt();
        if (n5 != 2) {
            throw new Throwable("Bad GDR type " + n5);
        }
        this.rVDRHead = byteBuffer.getInt();
        this.zVDRHead = byteBuffer.getInt();
        this.ADRHead = byteBuffer.getInt();
        int n6 = byteBuffer.getInt();
        this.numberOfRVariables = byteBuffer.getInt();
        this.numberOfAttributes = byteBuffer.getInt();
        byteBuffer.getInt();
        int n7 = byteBuffer.getInt();
        this.numberOfZVariables = byteBuffer.getInt();
        byteBuffer.getInt();
        this.rDimSizes = new int[n7];
        if (n7 > 0) {
            byteBuffer.getInt();
            byteBuffer.getInt();
            byteBuffer.getInt();
            for (int i = 0; i < this.rDimSizes.length; ++i) {
                this.rDimSizes[i] = byteBuffer.getInt();
            }
        }
        byteBuffer.position(0);
        this.variableTable = this.variables();
        this.attributeTable = this.attributes();
    }

    protected CDF2Impl(ByteBuffer byteBuffer, int n) throws Throwable {
        this(byteBuffer, n, null);
    }

    void setOffsets() {
        this.offset_NEXT_VDR = 8;
        this.offset_NEXT_ADR = 8;
        this.offset_ATTR_NAME = 52;
        this.offset_SCOPE = 16;
        this.offset_AgrEDRHead = 12;
        this.offset_AzEDRHead = 36;
        this.offset_NEXT_AEDR = 8;
        this.offset_ENTRYNUM = 20;
        this.offset_ATTR_DATATYPE = 16;
        this.offset_ATTR_NUM_ELEMENTS = 24;
        this.offset_VALUE = 48;
        this.offset_VAR_NAME = this.VAR_OFFSET_NAME;
        this.offset_VAR_NUM_ELEMENTS = this.VAR_OFFSET_NUM_ELEMENTS;
        this.offset_NUM = this.OFFSET_NUM;
        this.offset_FLAGS = 28;
        this.offset_sRecords = 32;
        this.offset_BLOCKING_FACTOR = 60;
        this.offset_VAR_DATATYPE = 12;
        this.offset_zNumDims = this.OFFSET_zNumDims;
        this.offset_FIRST_VXR = 20;
        this.offset_NEXT_VXR = 8;
        this.offset_NENTRIES = 12;
        this.offset_NUSED = 16;
        this.offset_FIRST = 20;
        this.offset_RECORD_TYPE = 4;
        this.offset_RECORDS = 8;
        this.offset_CSIZE = 12;
        this.offset_CDATA = 16;
    }

    @Override
    public String getString(long l) {
        ByteBuffer byteBuffer;
        if (this.fc == null) {
            return this.getString(l, 64);
        }
        try {
            byteBuffer = this.getRecord(l, 64);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        return this.getString(byteBuffer, 64);
    }

    @Override
    public int lowOrderInt(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }

    @Override
    public int lowOrderInt(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer getRecord(long l) {
        if (this.fc == null) {
            return super.getRecord(l);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            try {
                this.fc.position(l + 4L);
                this.fc.read(byteBuffer);
                int n = byteBuffer.getInt(0);
                return this.getRecord(l, n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }
    }

    protected ByteBuffer getRecord(long l, int n) throws Throwable {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.fc.position(l);
        int n2 = this.fc.read(byteBuffer);
        if (n2 != n) {
            System.out.println("Needed " + n + " bytes. Got " + n2);
            return null;
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    @Override
    public long longInt(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }
}

