/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DoubleVarContainer;
import gov.nasa.gsfc.spdf.cdfj.LongVarContainer;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.TSExtractor;
import gov.nasa.gsfc.spdf.cdfj.TimeInstantModel;
import gov.nasa.gsfc.spdf.cdfj.TimePrecision;
import gov.nasa.gsfc.spdf.cdfj.TimeUtil;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableX;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.Date;
import java.util.Vector;

public class TimeVariableFactory {
    public static final double JANUARY_1_1970;
    static final long longFill = -9223372036854775807L;
    static final double doubleFill = -1.0E31;
    private static TimeInstantModel defaultTimeInstantModel;
    public static final long JANUARY_1_1970_LONG;
    public static final long TT2000_DATE;

    private TimeVariableFactory() {
    }

    public static TimeInstantModel getDefaultTimeInstantModel() {
        return (TimeInstantModel)defaultTimeInstantModel.clone();
    }

    public static TimeInstantModel getDefaultTimeInstantModel(double d) {
        TimeInstantModel timeInstantModel = (TimeInstantModel)defaultTimeInstantModel.clone();
        ((DefaultTimeInstantModelImpl)timeInstantModel).setBaseTime(d);
        return timeInstantModel;
    }

    public static CDFTimeVariable getTimeVariable(MetaData metaData, String string) throws Throwable {
        Object object;
        CDFImpl cDFImpl = metaData.thisCDF;
        Variable variable = cDFImpl.getVariable(string);
        int n = -1;
        String string2 = null;
        int n2 = variable.getNumberOfValues();
        if (variable == null) {
            throw new Throwable("Bad variable name " + string);
        }
        string2 = metaData.getTimeVariableName(string);
        Variable variable2 = cDFImpl.getVariable(string2);
        if (variable2 == null) {
            throw new Throwable("Time variable not found for " + string);
        }
        boolean bl = false;
        if (variable2.getNumberOfValues() == 0) {
            object = (Vector)cDFImpl.getAttribute(variable.getName(), "DEPEND_TIME");
            if (((Vector)object).size() > 0) {
                string2 = (String)((Vector)object).elementAt(0);
                variable2 = cDFImpl.getVariable(string2);
                bl = true;
            } else {
                throw new Throwable("Expected unix time variable not found for " + variable.getName());
            }
        }
        if (variable2.getNumberOfValues() == 0) {
            throw new Throwable("Empty time variable for " + variable.getName());
        }
        object = null;
        if (variable2.getType() == 33) {
            LongVarContainer longVarContainer = new LongVarContainer(cDFImpl, variable2, null);
            longVarContainer.run();
            object = longVarContainer.getBuffer();
        } else {
            DoubleVarContainer doubleVarContainer = new DoubleVarContainer(cDFImpl, variable2, null, true);
            doubleVarContainer.run();
            object = doubleVarContainer.getBuffer();
        }
        CDFTimeVariable cDFTimeVariable = variable2.getType() == 32 ? new CDFEpoch16Variable(cDFImpl, string2, (ByteBuffer)object) : (variable2.getType() == 33 ? new CDFTT2000Variable(cDFImpl, string2, (ByteBuffer)object) : (bl ? new UnixTimeVariable(cDFImpl, string2, (ByteBuffer)object) : new CDFEpochVariable(cDFImpl, string2, (ByteBuffer)object)));
        cDFTimeVariable.setRecordCount(n2);
        return cDFTimeVariable;
    }

    static {
        int n = 0;
        for (int i = 0; i < 1970; ++i) {
            int n2 = 365;
            if (i % 4 == 0) {
                ++n2;
                if (i % 100 == 0) {
                    --n2;
                    if (i % 400 == 0) {
                        ++n2;
                    }
                }
            }
            n += n2;
        }
        JANUARY_1_1970 = (double)n * 8.64E7;
        defaultTimeInstantModel = new DefaultTimeInstantModelImpl();
        JANUARY_1_1970_LONG = (long)JANUARY_1_1970;
        TT2000_DATE = JANUARY_1_1970_LONG + Date.UTC(100, 0, 1, 12, 0, 0) - 42184L;
    }

    static class DefaultTimeInstantModelImpl
    implements TimeInstantModel {
        double baseTime = JANUARY_1_1970;
        TimePrecision baseTimeUnits = TimePrecision.MILLISECOND;
        TimePrecision offsetUnits = TimePrecision.MILLISECOND;

        DefaultTimeInstantModelImpl() {
        }

        @Override
        public double getBaseTime() {
            return this.baseTime;
        }

        @Override
        public TimePrecision getBaseTimeUnits() {
            return this.baseTimeUnits;
        }

        @Override
        public TimePrecision getOffsetUnits() {
            return this.offsetUnits;
        }

        @Override
        public void setOffsetUnits(TimePrecision timePrecision) {
            this.offsetUnits = timePrecision;
        }

        void setBaseTime(double d) {
            this.baseTime = d;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }
    }

    public static class UnixTimeVariable
    extends CDFTimeVariable {
        DoubleBuffer _dbuf;

        UnixTimeVariable(CDFImpl cDFImpl, String string, ByteBuffer byteBuffer) {
            super(cDFImpl, string, byteBuffer);
            this.precision = TimePrecision.MICROSECOND;
            this._dbuf = this.tbuf.asDoubleBuffer();
        }

        @Override
        public double[] getTimes(int n, int n2, TimeInstantModel timeInstantModel) throws Throwable {
            TimePrecision timePrecision = TimePrecision.MILLISECOND;
            long l = JANUARY_1_1970_LONG;
            if (timeInstantModel != null) {
                l = (long)timeInstantModel.getBaseTime();
                timePrecision = timeInstantModel.getOffsetUnits();
            }
            int n3 = n2 - n + 1;
            double[] dArray = new double[n3];
            ByteBuffer byteBuffer = this.tbuf.duplicate();
            byteBuffer.order(this.tbuf.order());
            DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
            doubleBuffer.position(n);
            doubleBuffer.get(dArray);
            if (timePrecision == TimePrecision.MILLISECOND) {
                if (l == JANUARY_1_1970_LONG) {
                    for (int i = 0; i < n3; ++i) {
                        if (dArray[i] == -1.0E31) {
                            dArray[i] = Double.NaN;
                            continue;
                        }
                        int n4 = i;
                        dArray[n4] = dArray[n4] * 1000.0;
                    }
                } else {
                    this.offset = l - JANUARY_1_1970_LONG;
                    for (int i = 0; i < n3; ++i) {
                        if (dArray[i] == -1.0E31) {
                            dArray[i] = Double.NaN;
                            continue;
                        }
                        long l2 = (long)(dArray[i] * 1000.0) - this.offset;
                        dArray[i] = l2;
                    }
                }
            } else {
                if (timePrecision != TimePrecision.MICROSECOND) {
                    throw new Throwable("Desired precision exceeds highest available precision -- microsecond");
                }
                if ((double)l == JANUARY_1_1970) {
                    for (int i = 0; i < n3; ++i) {
                        if (dArray[i] == -1.0E31) {
                            dArray[i] = Double.NaN;
                            continue;
                        }
                        int n5 = i;
                        dArray[n5] = dArray[n5] * 1000000.0;
                    }
                } else {
                    this.offset = 1000L * (l - JANUARY_1_1970_LONG);
                    for (int i = 0; i < n3; ++i) {
                        if (dArray[i] == -1.0E31) {
                            dArray[i] = Double.NaN;
                            continue;
                        }
                        long l3 = (long)(dArray[i] * 1000000.0) - this.offset;
                        dArray[i] = l3;
                    }
                }
            }
            return dArray;
        }

        @Override
        void reset() {
            this._dbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return false;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision timePrecision) {
            if (timePrecision == TimePrecision.MICROSECOND) {
                return true;
            }
            return timePrecision == TimePrecision.MILLISECOND;
        }
    }

    public static class CDFEpoch16Variable
    extends CDFTimeVariable {
        DoubleBuffer _dbuf;

        CDFEpoch16Variable(CDFImpl cDFImpl, String string, ByteBuffer byteBuffer) {
            super(cDFImpl, string, byteBuffer);
            this.precision = TimePrecision.PICOSECOND;
            this._dbuf = this.tbuf.asDoubleBuffer();
        }

        @Override
        public double[] getTimes(int n, int n2, TimeInstantModel timeInstantModel) throws Throwable {
            TimePrecision timePrecision = TimePrecision.MILLISECOND;
            long l = JANUARY_1_1970_LONG;
            if (timeInstantModel != null) {
                l = (long)timeInstantModel.getBaseTime();
                timePrecision = timeInstantModel.getOffsetUnits();
            }
            int n3 = n2 - n + 1;
            double[] dArray = new double[n3];
            ByteBuffer byteBuffer = this.tbuf.duplicate();
            byteBuffer.order(this.tbuf.order());
            DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
            if (timePrecision == TimePrecision.MILLISECOND) {
                long l2 = 1000L;
                for (int i = n; i <= n2; ++i) {
                    double d = doubleBuffer.get(2 * i);
                    if (d == -1.0E31) {
                        dArray[i - n] = Double.NaN;
                        continue;
                    }
                    double d2 = (long)doubleBuffer.get(2 * i) * l2 - l;
                    dArray[i - n] = d2 + doubleBuffer.get(2 * i + 1) / 1.0E9;
                }
            } else if (timePrecision == TimePrecision.MICROSECOND) {
                this.offset = 1000L * l;
                long l3 = 1000000L;
                for (int i = n; i <= n2; ++i) {
                    double d = doubleBuffer.get(2 * i);
                    if (d == -1.0E31) {
                        dArray[i - n] = Double.NaN;
                        continue;
                    }
                    double d3 = (long)doubleBuffer.get(2 * i) * l3 - this.offset;
                    dArray[i - n] = d3 + doubleBuffer.get(2 * i + 1) / 1000000.0;
                }
            } else if (timePrecision == TimePrecision.NANOSECOND) {
                this.offset = 1000000L * l;
                long l4 = 1000000000L;
                for (int i = n; i <= n2; ++i) {
                    double d = doubleBuffer.get(2 * i);
                    if (d == -1.0E31) {
                        dArray[i - n] = Double.NaN;
                        continue;
                    }
                    double d4 = (long)doubleBuffer.get(2 * i) * l4 - this.offset;
                    dArray[i - n] = d4 + doubleBuffer.get(2 * i + 1) / 1000.0;
                }
            } else {
                for (int i = n; i <= n2; ++i) {
                    double d = doubleBuffer.get(2 * i);
                    if (d == -1.0E31) {
                        dArray[i - n] = Double.NaN;
                        continue;
                    }
                    double d5 = doubleBuffer.get(2 * i) * 1000.0 - (double)l;
                    dArray[i - n] = d5 * 1.0E9 + doubleBuffer.get(2 * i + 1);
                }
            }
            return dArray;
        }

        @Override
        void reset() {
            this._dbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return false;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision timePrecision) {
            return true;
        }
    }

    public static class CDFTT2000Variable
    extends CDFTimeVariable {
        LongBuffer _lbuf;

        CDFTT2000Variable(CDFImpl cDFImpl, String string, ByteBuffer byteBuffer) {
            super(cDFImpl, string, byteBuffer);
            this.precision = TimePrecision.NANOSECOND;
            this._lbuf = this.tbuf.asLongBuffer();
        }

        @Override
        public double[] getTimes(int n, int n2, TimeInstantModel timeInstantModel) throws Throwable {
            TimePrecision timePrecision = TimePrecision.MILLISECOND;
            long l = JANUARY_1_1970_LONG;
            if (timeInstantModel != null) {
                l = (long)timeInstantModel.getBaseTime();
                timePrecision = timeInstantModel.getOffsetUnits();
            }
            int n3 = n2 - n + 1;
            double[] dArray = new double[n3];
            ByteBuffer byteBuffer = this.tbuf.duplicate();
            byteBuffer.order(this.tbuf.order());
            LongBuffer longBuffer = byteBuffer.asLongBuffer();
            if (timePrecision == TimePrecision.MILLISECOND) {
                this.offset = l - TT2000_DATE;
                for (int i = n; i <= n2; ++i) {
                    long l2 = longBuffer.get(i);
                    if (l2 == -9223372036854775807L) {
                        dArray[i - n] = Double.NaN;
                        continue;
                    }
                    long l3 = l2 / 1000000L - this.offset;
                    double d = (double)(l2 % 1000000L) / 1000000.0;
                    dArray[i - n] = (double)l3 + d;
                }
            } else if (timePrecision == TimePrecision.MICROSECOND) {
                this.offset = 1000L * (l - TT2000_DATE);
                for (int i = n; i <= n2; ++i) {
                    long l4 = longBuffer.get(i);
                    if (l4 == -9223372036854775807L) {
                        dArray[i - n] = Double.NaN;
                        continue;
                    }
                    long l5 = l4 / 1000L - this.offset;
                    double d = (double)(l4 % 1000L) / 1000.0;
                    dArray[i - n] = (double)l5 + d;
                }
            } else {
                if (timePrecision != TimePrecision.NANOSECOND) {
                    throw new Throwable("You may request only millisecond, microsecond or nanosecond offset for a variable whose time variable is TT2000 type.");
                }
                this.offset = 1000000L * (l - TT2000_DATE);
                for (int i = n; i <= n2; ++i) {
                    long l6 = longBuffer.get(i);
                    dArray[i - n] = l6 == -9223372036854775807L ? Double.NaN : (double)(l6 - this.offset);
                }
            }
            return dArray;
        }

        @Override
        void reset() {
            this._lbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return true;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision timePrecision) {
            return timePrecision != TimePrecision.PICOSECOND;
        }
    }

    public static class CDFEpochVariable
    extends CDFTimeVariable {
        TimePrecision offsetUnits = TimePrecision.MILLISECOND;
        DoubleBuffer _dbuf;

        CDFEpochVariable(CDFImpl cDFImpl, String string, ByteBuffer byteBuffer) {
            super(cDFImpl, string, byteBuffer);
            this.precision = TimePrecision.MILLISECOND;
            this._dbuf = this.tbuf.asDoubleBuffer();
        }

        @Override
        public double[] getTimes(int n, int n2, TimeInstantModel timeInstantModel) throws Throwable {
            double d = JANUARY_1_1970_LONG;
            if (timeInstantModel != null) {
                if (timeInstantModel.getOffsetUnits() != TimePrecision.MILLISECOND) {
                    throw new Throwable("Unsupported offset units: Only millisecond offset units are supported for this variable.");
                }
                d = timeInstantModel.getBaseTime();
            }
            int n3 = n2 - n + 1;
            double[] dArray = new double[n3];
            ByteBuffer byteBuffer = this.tbuf.duplicate();
            byteBuffer.order(this.tbuf.order());
            DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
            doubleBuffer.position(n);
            doubleBuffer.get(dArray);
            for (int i = 0; i < n3; ++i) {
                if (dArray[i] == -1.0E31) {
                    System.out.println("at " + i + " fill found");
                    dArray[i] = Double.NaN;
                    continue;
                }
                int n4 = i;
                dArray[n4] = dArray[n4] - d;
            }
            return dArray;
        }

        @Override
        void reset() {
            this._dbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return false;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision timePrecision) {
            return timePrecision == TimePrecision.MILLISECOND;
        }
    }

    public static abstract class CDFTimeVariable
    implements TimeVariableX {
        CDFImpl cdf;
        String name;
        TimePrecision precision;
        final ByteBuffer tbuf;
        long offset;
        int recordCount;

        CDFTimeVariable(CDFImpl cDFImpl, String string, ByteBuffer byteBuffer) {
            this.name = string;
            this.cdf = cDFImpl;
            this.tbuf = byteBuffer;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TimePrecision getPrecision() {
            return this.precision;
        }

        @Override
        public double[] getTimes() {
            try {
                return this.getTimes(0, this.recordCount - 1, null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double[] getTimes(TimeInstantModel timeInstantModel) throws Throwable {
            return this.getTimes(0, this.recordCount - 1, timeInstantModel);
        }

        @Override
        public double[] getTimes(int[] nArray) throws Throwable {
            try {
                return this.getTimes(nArray, defaultTimeInstantModel);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        abstract double[] getTimes(int var1, int var2, TimeInstantModel var3) throws Throwable;

        @Override
        public double[] getTimes(int[] nArray, TimeInstantModel timeInstantModel) throws Throwable {
            return this.getTimes(nArray[0], nArray[1], timeInstantModel);
        }

        public double[] getTimes(double[] dArray) {
            try {
                return this.getTimes(dArray, null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double[] getTimes(double[] dArray, TimeInstantModel timeInstantModel) throws Throwable {
            if (dArray == null) {
                return this.getTimes(0, this.recordCount - 1, timeInstantModel);
            }
            int[] nArray = this.getRecordRange(dArray, timeInstantModel);
            if (nArray == null) {
                return null;
            }
            return this.getTimes(nArray[0], nArray[1], timeInstantModel);
        }

        @Override
        public double[] getTimes(int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws Throwable {
            if (nArray == null) {
                throw new Throwable("start time is required");
            }
            if (nArray2 == null) {
                throw new Throwable("stop time is required");
            }
            if (nArray.length < 3) {
                throw new Throwable("incomplete start time definition.");
            }
            long l = TSExtractor.getTime(nArray);
            if (nArray2.length < 3) {
                throw new Throwable("incomplete stop time definition.");
            }
            long l2 = TSExtractor.getTime(nArray2);
            if (this.isTT2000()) {
                l = (long)TimeUtil.milliSecondSince1970(l);
                l2 = (long)TimeUtil.milliSecondSince1970(l2);
            }
            return this.getTimes(new double[]{l, l2}, timeInstantModel);
        }

        @Override
        public double[] getTimes(int[] nArray, int[] nArray2) throws Throwable {
            return this.getTimes(nArray, nArray2, null);
        }

        @Override
        public int[] getRecordRange(double[] dArray) throws Throwable {
            return this.getRecordRange(dArray, null);
        }

        @Override
        public int[] getRecordRange(int[] nArray, int[] nArray2) throws Throwable {
            return this.getRecordRange(nArray, nArray2, null);
        }

        @Override
        public int[] getRecordRange(int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws Throwable {
            if (nArray.length < 3) {
                throw new Throwable("incomplete start time definition.");
            }
            if (nArray2.length < 3) {
                throw new Throwable("incomplete stop time definition.");
            }
            long l = TSExtractor.getTime(nArray);
            long l2 = TSExtractor.getTime(nArray2);
            if (this.isTT2000()) {
                l = (long)TimeUtil.milliSecondSince1970(l);
                l2 = (long)TimeUtil.milliSecondSince1970(l2);
            }
            return this.getRecordRange(new double[]{l, l2}, timeInstantModel);
        }

        public int[] getRecordRange(double[] dArray, TimeInstantModel timeInstantModel) throws Throwable {
            int n;
            double[] dArray2 = this.getTimes(0, this.recordCount - 1, timeInstantModel);
            double d = dArray[0];
            double d2 = dArray[1];
            if (timeInstantModel != null && timeInstantModel != defaultTimeInstantModel) {
                d = d - timeInstantModel.getBaseTime() + (double)JANUARY_1_1970_LONG;
                d2 = d2 - timeInstantModel.getBaseTime() + (double)JANUARY_1_1970_LONG;
                if (timeInstantModel.getOffsetUnits() == TimePrecision.MICROSECOND) {
                    d *= 1000.0;
                    d2 *= 1000.0;
                } else if (timeInstantModel.getOffsetUnits() == TimePrecision.NANOSECOND) {
                    d *= 1000000.0;
                    d2 *= 1000000.0;
                }
            }
            for (n = 0; n < dArray2.length && (dArray2[n] == Double.NaN || d > dArray2[n]); ++n) {
            }
            if (n == dArray2.length) {
                return null;
            }
            int n2 = n;
            int n3 = n;
            while (n < dArray2.length) {
                if (dArray2[n] != Double.NaN) {
                    n3 = n;
                    if (d2 < dArray2[n]) break;
                    if (d2 == dArray2[n]) {
                        n3 = n - 1;
                        break;
                    }
                }
                ++n;
            }
            return new int[]{n2, n3};
        }

        protected void setRecordCount(int n) {
            this.recordCount = n;
        }

        @Override
        public double getFirstMilliSecond() {
            TimeInstantModel timeInstantModel = TimeVariableFactory.getDefaultTimeInstantModel();
            ((DefaultTimeInstantModelImpl)timeInstantModel).setBaseTime(0.0);
            timeInstantModel.setOffsetUnits(TimePrecision.MILLISECOND);
            try {
                double d = Double.NaN;
                for (int i = 0; i < this.recordCount; ++i) {
                    d = this.getTimes(i, i, timeInstantModel)[0];
                    if (d == Double.NaN) continue;
                    return d;
                }
                return d;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return Double.NaN;
            }
        }

        abstract void reset();

        @Override
        public abstract boolean isTT2000();

        @Override
        public ByteBuffer getRawBuffer() {
            return this.tbuf;
        }
    }
}

