/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class LongArray
extends AArray {
    public LongArray(Object object) throws Throwable {
        super(object);
    }

    public LongArray(Object object, boolean bl) throws Throwable {
        super(object, bl);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                return (long[])this.o;
            }
            case 2: {
                return (long[][])this.o;
            }
            case 3: {
                return (long[][][])this.o;
            }
            case 4: {
                return (long[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> clazz, int n) throws Throwable {
        if (clazz != Long.TYPE && clazz != Integer.TYPE) {
            throw new Throwable("Only int and long targets supported");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        int n2 = clazz == Integer.TYPE ? 4 : 8;
        ByteBuffer byteBuffer = this.allocate(n2);
        if (clazz == Integer.TYPE) {
            return this.doInt(byteBuffer);
        }
        return this.doLong(byteBuffer);
    }

    ByteBuffer doInt(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        int[] nArray2 = null;
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        switch (this.dim) {
            case 1: {
                long[] lArray = (long[])this.o;
                nArray2 = new int[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    nArray2[i] = (int)lArray[i];
                }
                intBuffer.put(nArray2);
                return byteBuffer;
            }
            case 2: {
                long[][] lArray = (long[][])this.o;
                nArray2 = new int[nArray[1]];
                for (int i = 0; i < nArray[0]; ++i) {
                    long[] lArray2 = lArray[i];
                    for (int j = 0; j < nArray[1]; ++j) {
                        nArray2[j] = (int)lArray2[j];
                    }
                    intBuffer.put(nArray2);
                }
                return byteBuffer;
            }
            case 3: {
                long[][][] lArray = (long[][][])this.o;
                if (this.rowMajority) {
                    nArray2 = new int[nArray[2]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            long[] lArray3 = lArray[i][j];
                            for (int k = 0; k < nArray[2]; ++k) {
                                nArray2[k] = (int)lArray3[k];
                            }
                            intBuffer.put(nArray2);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                intBuffer.put((int)lArray[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                long[][][][] lArray = (long[][][][])this.o;
                if (this.rowMajority) {
                    nArray2 = new int[nArray[3]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                long[] lArray4 = lArray[i][j][k];
                                for (int i2 = 0; i2 < nArray[3]; ++i2) {
                                    nArray2[i2] = (int)lArray4[i2];
                                }
                                intBuffer.put(nArray2);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i3 = 0; i3 < nArray[1]; ++i3) {
                                    intBuffer.put((int)lArray[i][i3][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }

    ByteBuffer doLong(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        switch (this.dim) {
            case 1: {
                long[] lArray = (long[])this.o;
                longBuffer.put(lArray);
                return byteBuffer;
            }
            case 2: {
                long[][] lArray = (long[][])this.o;
                for (int i = 0; i < nArray[0]; ++i) {
                    longBuffer.put(lArray[i]);
                }
                return byteBuffer;
            }
            case 3: {
                long[][][] lArray = (long[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            longBuffer.put(lArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                longBuffer.put(lArray[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                long[][][][] lArray = (long[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                longBuffer.put(lArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                    longBuffer.put(lArray[i][i2][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }
}

